/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.api.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog.HyperLogLogPlusPlus;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.TypeInfoWrappedDataType;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;

public class ApproximateCountDistinct {

    public static class StringApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return new TypeInfoWrappedDataType(BinaryStringTypeInfo.INSTANCE);
        }
    }

    public static class TimestampApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIMESTAMP;
        }
    }

    public static class TimeApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.TIME;
        }
    }

    public static class DateApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DATE;
        }
    }

    public static class BooleanApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BOOLEAN;
        }
    }

    public static class ShortApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.SHORT;
        }
    }

    public static class LongApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.LONG;
        }
    }

    public static class IntApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.INT;
        }
    }

    public static class FloatApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.FLOAT;
        }
    }

    public static class DoubleApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.DOUBLE;
        }
    }

    public static class DecimalApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        public final DecimalType decimalType;

        public DecimalApproximateCountDistinctAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getValueTypeInfo() {
            return this.decimalType;
        }
    }

    public static class ByteApproximateCountDistinctAggFunction
    extends ApproximateCountDistinctAggFunction {
        @Override
        public DataType getValueTypeInfo() {
            return DataTypes.BYTE;
        }
    }

    public static class HllBuffer {
        public long[] array;
    }

    public static abstract class ApproximateCountDistinctAggFunction
    extends AggregateFunction<Long, HllBuffer> {
        private static final Double RELATIVE_SD = 0.01;
        private HyperLogLogPlusPlus hyperLogLogPlusPlus;

        public abstract DataType getValueTypeInfo();

        @Override
        public HllBuffer createAccumulator() {
            this.hyperLogLogPlusPlus = new HyperLogLogPlusPlus(RELATIVE_SD);
            HllBuffer buffer = new HllBuffer();
            buffer.array = new long[this.hyperLogLogPlusPlus.numWords()];
            this.resetAccumulator(buffer);
            return buffer;
        }

        public void accumulate(HllBuffer buffer, Object input) throws Exception {
            if (input != null) {
                this.hyperLogLogPlusPlus.update(buffer, input);
            }
        }

        public void merge(HllBuffer buffer, Iterable<HllBuffer> it) throws Exception {
            for (HllBuffer tmpBuffer : it) {
                this.hyperLogLogPlusPlus.merge(buffer, tmpBuffer);
            }
        }

        public void resetAccumulator(HllBuffer buffer) {
            for (int word = 0; word < this.hyperLogLogPlusPlus.numWords(); ++word) {
                buffer.array[word] = 0L;
            }
        }

        @Override
        public Long getValue(HllBuffer buffer) {
            return this.hyperLogLogPlusPlus.query(buffer);
        }

        @Override
        public DataType[] getUserDefinedInputTypes(Class[] signature) {
            if (signature.length == 1) {
                return new DataType[]{this.getValueTypeInfo()};
            }
            if (signature.length == 0) {
                return new DataType[0];
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public DataType getAccumulatorType() {
            return new GenericType<HllBuffer>(new GenericTypeInfo<HllBuffer>(HllBuffer.class));
        }
    }
}

