/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.table.api.functions.AggregateFunction;
import org.apache.flink.table.runtime.functions.aggfunctions.cardinality.CardinalityCountAccumulator;
import org.apache.flink.table.runtime.functions.aggfunctions.cardinality.HyperLogLog;

public class CardinalityCountAggFunction
extends AggregateFunction<Long, CardinalityCountAccumulator> {
    @Override
    public CardinalityCountAccumulator createAccumulator() {
        return new CardinalityCountAccumulator();
    }

    public void accumulate(CardinalityCountAccumulator acc, Double rsd, Object value) {
        HyperLogLog ce;
        if (acc.f0 == null) {
            if (rsd <= 0.0 || rsd >= 1.0) {
                throw new IllegalArgumentException("Relative standard deviation should be > 0.0 and < 1.0, but get [" + rsd + "].");
            }
            acc.f0 = rsd;
            try {
                ce = new HyperLogLog((Double)acc.f0);
                acc.f1 = ce.getBytes();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2.getCause());
            }
        }
        if (value != null) {
            try {
                ce = HyperLogLog.Builder.build((byte[])acc.f1);
                ce.offer(value);
                acc.f1 = ce.getBytes();
            }
            catch (IOException e3) {
                throw new RuntimeException(e3.getCause());
            }
        }
    }

    public void accumulate(CardinalityCountAccumulator acc, BigDecimal rsd, Object value) {
        this.accumulate(acc, rsd.doubleValue(), value);
    }

    public void retract(Tuple1<byte[]> acc, Object value) {
    }

    public void resetAccumulator(CardinalityCountAccumulator acc) {
        acc.f0 = null;
        acc.f1 = null;
    }

    @Override
    public Long getValue(CardinalityCountAccumulator acc) {
        try {
            if (acc.f0 == null) {
                return 0L;
            }
            return HyperLogLog.Builder.build((byte[])acc.f1).cardinality();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2.getCause());
        }
    }
}

