/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.functions.AggregateFunction;
import org.apache.flink.table.api.scala.package$;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.functions.aggfunctions.ConcatAggFunction$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.typeutils.BinaryStringTypeInfo;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001#\t\t2i\u001c8dCR\fum\u001a$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001D1hO\u001a,hn\u0019;j_:\u001c(BA\u0003\u0007\u0003%1WO\\2uS>t7O\u0003\u0002\b\u0011\u00059!/\u001e8uS6,'BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001BaE\f\u001a?5\tAC\u0003\u0002\u0006+)\u0011a\u0003C\u0001\u0004CBL\u0017B\u0001\r\u0015\u0005E\tum\u001a:fO\u0006$XMR;oGRLwN\u001c\t\u00035ui\u0011a\u0007\u0006\u00039!\t!\u0002Z1uC\u001a|'/\\1u\u0013\tq2D\u0001\u0007CS:\f'/_*ue&tw\r\u0005\u0002\u001bA%\u0011\u0011e\u0007\u0002\u000b\u000f\u0016tWM]5d%><\b\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\u0003\u0011\u0015A\u0003\u0001\"\u0001*\u0003)\t7mY;nk2\fG/\u001a\u000b\u0004UA\u0012\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#\u0001B+oSRDQ!M\u0014A\u0002}\t1!Y2d\u0011\u0015\u0019t\u00051\u0001\u001a\u0003\u00151\u0018\r\\;f\u0011\u0015)\u0004\u0001\"\u00017\u0003\u001d\u0011X\r\u001e:bGR$2AK\u001c9\u0011\u0015\tD\u00071\u0001 \u0011\u0015\u0019D\u00071\u0001\u001a\u0011\u0015Q\u0004\u0001\"\u0011<\u0003!9W\r\u001e,bYV,GCA\r=\u0011\u0015\t\u0014\b1\u0001 \u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0015iWM]4f)\rQ\u0003)\u0011\u0005\u0006cu\u0002\ra\b\u0005\u0006\u0005v\u0002\raQ\u0001\u0004SR\u001c\bc\u0001#J?5\tQI\u0003\u0002G\u000f\u0006!A.\u00198h\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\u0011%#XM]1cY\u0016DQ\u0001\u0014\u0001\u0005B5\u000b\u0011c\u0019:fCR,\u0017iY2v[Vd\u0017\r^8s)\u0005y\u0002\"B(\u0001\t\u0003\u0001\u0016\u0001\u0005:fg\u0016$\u0018iY2v[Vd\u0017\r^8s)\tQ\u0013\u000bC\u00032\u001d\u0002\u0007q\u0004C\u0003T\u0001\u0011\u0005C+\u0001\nhKR\f5mY;nk2\fGo\u001c:UsB,G#A+\u0011\u0005YKV\"A,\u000b\u0005aC\u0011!\u0002;za\u0016\u001c\u0018B\u0001.X\u0005!!\u0015\r^1UsB,w!\u0002/\u0003\u0011\u0003i\u0016!E\"p]\u000e\fG/Q4h\rVt7\r^5p]B\u0011aE\u0018\u0004\u0006\u0003\tA\taX\n\u0004=\u0002\u001c\u0007CA\u0016b\u0013\t\u0011GF\u0001\u0004B]f\u0014VM\u001a\t\u0003W\u0011L!!\u001a\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\rrF\u0011A4\u0015\u0003uCq!\u001b0C\u0002\u0013\u0005!.A\u0007mS:,G)\u001a7j[&$XM]\u000b\u00023!1AN\u0018Q\u0001\ne\ta\u0002\\5oK\u0012+G.[7ji\u0016\u0014\b\u0005C\u0004o=\u0006\u0005I\u0011B8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002aB\u0011A)]\u0005\u0003e\u0016\u0013aa\u00142kK\u000e$\b")
public class ConcatAggFunction
extends AggregateFunction<BinaryString, GenericRow> {
    public static BinaryString lineDelimiter() {
        return ConcatAggFunction$.MODULE$.lineDelimiter();
    }

    public void accumulate(GenericRow acc, BinaryString value) {
        if (value != null) {
            ListView list = (ListView)acc.getField(0);
            list.add(value);
        }
    }

    public void retract(GenericRow acc, BinaryString value) {
        ListView list;
        if (value != null && !(list = (ListView)acc.getField(0)).remove(value)) {
            ListView retractList = (ListView)acc.getField(1);
            retractList.add(value);
        }
    }

    @Override
    public BinaryString getValue(GenericRow acc) {
        ListView list = (ListView)acc.getField(0);
        Iterable accList = list.get();
        return accList != null && accList.iterator().hasNext() ? BinaryString.concatWs(ConcatAggFunction$.MODULE$.lineDelimiter(), list.get()) : null;
    }

    public void merge(GenericRow acc, Iterable<GenericRow> its) {
        for (GenericRow otherAcc : its) {
            ListView thisList = (ListView)acc.getField(0);
            ListView otherList = (ListView)otherAcc.getField(0);
            Iterable accList = otherList.get();
            if (accList != null) {
                Iterator listIter = accList.iterator();
                while (listIter.hasNext()) {
                    thisList.add(listIter.next());
                }
            }
            ListView otherRetractList = (ListView)otherAcc.getField(1);
            ListView thisRetractList = (ListView)acc.getField(1);
            Iterable retractList = otherRetractList.get();
            if (retractList == null) continue;
            Iterator retractListIter = retractList.iterator();
            List buffer = null;
            if (retractListIter.hasNext()) {
                buffer = (List)thisList.get();
            }
            boolean listChanged = false;
            while (retractListIter.hasNext()) {
                BinaryString element = (BinaryString)retractListIter.next();
                if (buffer != null && buffer.remove(element)) {
                    listChanged = true;
                    continue;
                }
                thisRetractList.add(element);
            }
            if (!listChanged) continue;
            thisList.clear();
            thisList.addAll(buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GenericRow createAccumulator() {
        void var1_1;
        GenericRow acc = new GenericRow(2);
        acc.update(0, new ListView(package$.MODULE$.typeInfo2DataType(BinaryStringTypeInfo.INSTANCE)));
        acc.update(1, new ListView(package$.MODULE$.typeInfo2DataType(BinaryStringTypeInfo.INSTANCE)));
        return var1_1;
    }

    public void resetAccumulator(GenericRow acc) {
        ListView list = (ListView)acc.getField(0);
        ListView retractList = (ListView)acc.getField(1);
        list.clear();
        retractList.clear();
    }

    @Override
    public DataType getAccumulatorType() {
        DataType[] fieldTypes2 = (DataType[])((Object[])new DataType[]{DataTypes.createGenericType(ListView.class), DataTypes.createGenericType(ListView.class)});
        String[] fieldNames = (String[])((Object[])new String[]{"list", "retractList"});
        return new RowType(fieldTypes2, fieldNames);
    }
}

