/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions.cardinality;

public class RegisterSet {
    public static final int LOG2_BITS_PER_WORD = 6;
    public static final int REGISTER_SIZE = 5;
    public final int count;
    public final int size;
    private final int[] m;

    public static int getBits(int count) {
        return count / 6;
    }

    public static int getSizeForCount(int count) {
        int bits = RegisterSet.getBits(count);
        if (bits == 0) {
            return 1;
        }
        if (bits % 32 == 0) {
            return bits;
        }
        return bits + 1;
    }

    public RegisterSet(int count) {
        this(count, null);
    }

    public RegisterSet(int count, int[] initialValues) {
        this.count = count;
        this.m = initialValues == null ? new int[RegisterSet.getSizeForCount(count)] : initialValues;
        this.size = this.m.length;
    }

    public void set(int position, int value) {
        int bucketPos = position / 6;
        int shift = 5 * (position - bucketPos * 6);
        this.m[bucketPos] = this.m[bucketPos] & ~(31 << shift) | value << shift;
    }

    public int get(int position) {
        int bucketPos = position / 6;
        int shift = 5 * (position - bucketPos * 6);
        return (this.m[bucketPos] & 31 << shift) >>> shift;
    }

    public boolean updateIfGreater(int position, int value) {
        int bucket = position / 6;
        int shift = 5 * (position - bucket * 6);
        int mask = 31 << shift;
        long curVal = this.m[bucket] & mask;
        long newVal = value << shift;
        if (curVal < newVal) {
            this.m[bucket] = (int)((long)(this.m[bucket] & ~mask) | newVal);
            return true;
        }
        return false;
    }

    public void merge(RegisterSet that) {
        for (int bucket = 0; bucket < this.m.length; ++bucket) {
            int word = 0;
            for (int j2 = 0; j2 < 6; ++j2) {
                int mask = 31 << 5 * j2;
                int thisVal = this.m[bucket] & mask;
                int thatVal = that.m[bucket] & mask;
                word |= thisVal < thatVal ? thatVal : thisVal;
            }
            this.m[bucket] = word;
        }
    }

    int[] readOnlyBits() {
        return this.m;
    }
}

