/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggfunctions.hyperloglog;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.errorcode.TableErrors;
import org.apache.flink.table.util.hash.XXH64;
import scala.runtime.BoxesRunTime;

public final class XxHash64Function$ {
    public static final XxHash64Function$ MODULE$;

    static {
        new XxHash64Function$();
    }

    private long hashInt(int i, long seed) {
        return XXH64.hashInt(i, seed);
    }

    private long hashLong(long l, long seed) {
        return XXH64.hashLong(l, seed);
    }

    private long hashUnsafeBytes(MemorySegment base, int offset, int length, long seed) {
        return XXH64.hashUnsafeBytes(base, offset, length, seed);
    }

    public long hash(Object value, long seed) {
        block18: {
            long l;
            block6: {
                Object object;
                block17: {
                    long l2;
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block5: {
                                                                object = value;
                                                                if (object != null) break block5;
                                                                l = seed;
                                                                break block6;
                                                            }
                                                            if (!(object instanceof Boolean)) break block7;
                                                            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                                                            l = this.hashInt(bl ? 1 : 0, seed);
                                                            break block6;
                                                        }
                                                        if (!(object instanceof Byte)) break block8;
                                                        byte by = BoxesRunTime.unboxToByte((Object)object);
                                                        l = this.hashInt(by, seed);
                                                        break block6;
                                                    }
                                                    if (!(object instanceof Short)) break block9;
                                                    short s = BoxesRunTime.unboxToShort((Object)object);
                                                    l = this.hashInt(s, seed);
                                                    break block6;
                                                }
                                                if (!(object instanceof Integer)) break block10;
                                                int n = BoxesRunTime.unboxToInt((Object)object);
                                                l = this.hashInt(n, seed);
                                                break block6;
                                            }
                                            if (!(object instanceof Long)) break block11;
                                            long l3 = BoxesRunTime.unboxToLong((Object)object);
                                            l = this.hashLong(l3, seed);
                                            break block6;
                                        }
                                        if (!(object instanceof Float)) break block12;
                                        float f = BoxesRunTime.unboxToFloat((Object)object);
                                        l = this.hashInt(Float.floatToIntBits(f), seed);
                                        break block6;
                                    }
                                    if (!(object instanceof Double)) break block13;
                                    double d = BoxesRunTime.unboxToDouble((Object)object);
                                    l = this.hashLong(Double.doubleToLongBits(d), seed);
                                    break block6;
                                }
                                if (!(object instanceof Date)) break block14;
                                Date date = (Date)object;
                                l = this.hashLong(date.getTime(), seed);
                                break block6;
                            }
                            if (!(object instanceof Time)) break block15;
                            Time time = (Time)object;
                            l = this.hashLong(time.getTime(), seed);
                            break block6;
                        }
                        if (!(object instanceof Timestamp)) break block16;
                        Timestamp timestamp = (Timestamp)object;
                        l = this.hashLong(timestamp.getTime(), seed);
                        break block6;
                    }
                    if (!(object instanceof BigDecimal)) break block17;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (bigDecimal.precision() <= 18) {
                        l2 = this.hashLong(bigDecimal.unscaledValue().longValueExact(), seed);
                    } else {
                        byte[] bytes = bigDecimal.unscaledValue().toByteArray();
                        HeapMemorySegment hms = HeapMemorySegment.FACTORY.wrap(bytes);
                        l2 = this.hashUnsafeBytes(hms, 0, hms.size(), seed);
                    }
                    l = l2;
                    break block6;
                }
                if (!(object instanceof BinaryString)) break block18;
                BinaryString binaryString = (BinaryString)object;
                MemorySegment[] segments = binaryString.getSegments();
                l = segments.length == 1 ? this.hashUnsafeBytes(segments[0], binaryString.getOffset(), binaryString.numBytes(), seed) : this.hashUnsafeBytes(MemorySegmentFactory.wrap(binaryString.getBytes()), 0, binaryString.numBytes(), seed);
            }
            return l;
        }
        throw new TableException(TableErrors.INST.sqlAggExecDataTypeNotSupported("Approximate Count Distinct", value.toString()));
    }

    private XxHash64Function$() {
        MODULE$ = this;
    }
}

