/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputSelection;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.collector.HeaderCollector;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001\u0002eI\u001aC!\r\t\u0002DG\u0007\u0002%)\u00111\u0003F\u0001\n_B,'/\u0019;peNT!!\u0006\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0018\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00033I\u0011a#\u00112tiJ\f7\r^*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\t!\u0002Z1uC\u001a|'/\\1u\u0013\tyBDA\u0004CCN,'k\\<\u0011\u000bE\t#D\u0007\u000e\n\u0005\t\u0012\"A\u0006+x_&s\u0007/\u001e;TiJ,\u0017-\\(qKJ\fGo\u001c:\u0011\tE!c\u0005L\u0005\u0003KI\u00111\u0002\u0016:jO\u001e,'/\u00192mKB\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011I\\=\u0011\u00055\nT\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:uCR,'BA\u0003\t\u0013\t\u0011dFA\u0007W_&$g*Y7fgB\f7-\u001a\t\u0004i]JT\"A\u001b\u000b\u0005Y2\u0011aB2pI\u0016<WM\\\u0005\u0003qU\u0012\u0001bQ8na&dWM\u001d\t\u0006u\u0001S\"DG\u0007\u0002w)\u0011A(P\u0001\nMVt7\r^5p]NT!AP \u0002\r\r|W.\\8o\u0015\t)\u0002\"\u0003\u0002Bw\t\u0001b\t\\1u\u0015>LgNR;oGRLwN\u001c\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u001a\tA!\u001e;jY&\u0011q\t\u0012\u0002\b\u0019><w-\u001b8h\u0011!I\u0005A!A!\u0002\u0013Q\u0015\u0001\u00037fMR$\u0016\u0010]3\u0011\u0007-s%$D\u0001M\u0015\tiU(\u0001\u0005usB,\u0017N\u001c4p\u0013\tyEJA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!\t\u0006A!A!\u0002\u0013Q\u0015!\u0003:jO\"$H+\u001f9f\u0011!\u0019\u0006A!A!\u0002\u0013!\u0016aD4f]*{\u0017N\u001c$v]\u000et\u0015-\\3\u0011\u0005UCfBA\u0014W\u0013\t9\u0006&\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,)\u0011!a\u0006A!A!\u0002\u0013!\u0016aD4f]*{\u0017N\u001c$v]\u000e\u001cu\u000eZ3\t\u0011y\u0003!\u0011!Q\u0001\n}\u000b\u0011\u0003\\3giRKW.Z!uiJL'-\u001e;f!\t9\u0003-\u0003\u0002bQ\t\u0019\u0011J\u001c;\t\u0011\r\u0004!\u0011!Q\u0001\n}\u000b!C]5hQR$\u0016.\\3BiR\u0014\u0018NY;uK\")Q\r\u0001C\u0001M\u00061A(\u001b8jiz\"raZ5kW2lg\u000e\u0005\u0002i\u00015\t!\u0001C\u0003JI\u0002\u0007!\nC\u0003RI\u0002\u0007!\nC\u0003TI\u0002\u0007A\u000bC\u0003]I\u0002\u0007A\u000bC\u0003_I\u0002\u0007q\fC\u0003dI\u0002\u0007q\fC\u0004q\u0001\t\u0007I\u0011B9\u000259+\u0005\fV0M\u000b\u001a#v,\u0013(E\u000bb{6\u000bV!U\u000b~s\u0015)T#\u0016\u0003I\u0004\"a\u001d=\u000e\u0003QT!!\u001e<\u0002\t1\fgn\u001a\u0006\u0002o\u0006!!.\u0019<b\u0013\tIF\u000f\u0003\u0004{\u0001\u0001\u0006IA]\u0001\u001c\u001d\u0016CFk\u0018'F\rR{\u0016J\u0014#F1~\u001bF+\u0011+F?:\u000bU*\u0012\u0011\t\u000fq\u0004!\u0019!C\u0005c\u0006yA*\u0012$U?N#\u0016\tV#`\u001d\u0006kU\t\u0003\u0004\u007f\u0001\u0001\u0006IA]\u0001\u0011\u0019\u00163EkX*U\u0003R+uLT!N\u000b\u0002B\u0001\"!\u0001\u0001\u0005\u0004%I!]\u0001\u0011%&;\u0005\nV0T)\u0006#Vi\u0018(B\u001b\u0016Cq!!\u0002\u0001A\u0003%!/A\tS\u0013\u001eCEkX*U\u0003R+uLT!N\u000b\u0002B\u0001\"!\u0003\u0001\u0005\u0004%I!]\u0001\u001c%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#\t\u000f\u00055\u0001\u0001)A\u0005e\u0006a\"+R$J'R+%+\u0012#`)&kUIU0T)\u0006#Vi\u0018(B\u001b\u0016\u0003\u0003\u0002CA\t\u0001\t\u0007I\u0011B9\u0002#QKU*\u0012*T?N#\u0016\tV#`\u001d\u0006kU\tC\u0004\u0002\u0016\u0001\u0001\u000b\u0011\u0002:\u0002%QKU*\u0012*T?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\n\u00033\u0001!\u0019!C\u0005\u00037\taC]5hQR\u0014vn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN]\u000b\u0003\u0003;\u00012\u0001[A\u0010\u0013\r\t\tC\u0001\u0002\u0012%><H/[7f\u0007>l\u0007/\u0019:bi>\u0014\b\u0002CA\u0013\u0001\u0001\u0006I!!\b\u0002/ILw\r\u001b;S_^$\u0018.\\3D_6\u0004\u0018M]1u_J\u0004\u0003bCA\u0015\u0001\u0001\u0007\t\u0019!C\u0005\u0003W\tQB\\3yi2+g\r^%oI\u0016DXCAA\u0017!\u0019\ty#a\r\u000285\u0011\u0011\u0011\u0007\u0006\u0003_uJA!!\u000e\u00022\tQa+\u00197vKN#\u0018\r^3\u0011\u0007M\fI$C\u0002\u0002<Q\u0014A\u0001T8oO\"Y\u0011q\b\u0001A\u0002\u0003\u0007I\u0011BA!\u0003EqW\r\u001f;MK\u001a$\u0018J\u001c3fq~#S-\u001d\u000b\u0005\u0003\u0007\nI\u0005E\u0002(\u0003\u000bJ1!a\u0012)\u0005\u0011)f.\u001b;\t\u0015\u0005-\u0013QHA\u0001\u0002\u0004\ti#A\u0002yIEB\u0001\"a\u0014\u0001A\u0003&\u0011QF\u0001\u000f]\u0016DH\u000fT3gi&sG-\u001a=!\u0011-\t\u0019\u0006\u0001a\u0001\u0002\u0004%I!!\u0016\u0002\u00131,g\r^*uCR,WCAA,!\u001d\ty#!\u0017\u00028iIA!a\u0017\u00022\tAQ*\u00199Ti\u0006$X\rC\u0006\u0002`\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0014!\u00047fMR\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002D\u0005\r\u0004BCA&\u0003;\n\t\u00111\u0001\u0002X!A\u0011q\r\u0001!B\u0013\t9&\u0001\u0006mK\u001a$8\u000b^1uK\u0002B1\"a\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002V\u0005Q!/[4iiN#\u0018\r^3\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011O\u0001\u000fe&<\u0007\u000e^*uCR,w\fJ3r)\u0011\t\u0019%a\u001d\t\u0015\u0005-\u0013QNA\u0001\u0002\u0004\t9\u0006\u0003\u0005\u0002x\u0001\u0001\u000b\u0015BA,\u0003-\u0011\u0018n\u001a5u'R\fG/\u001a\u0011\t\u0017\u0005m\u0004\u00011AA\u0002\u0013%\u00111F\u0001\u0010e\u0016<\u0017n\u001d;fe\u0016$G+[7fe\"Y\u0011q\u0010\u0001A\u0002\u0003\u0007I\u0011BAA\u0003M\u0011XmZ5ti\u0016\u0014X\r\u001a+j[\u0016\u0014x\fJ3r)\u0011\t\u0019%a!\t\u0015\u0005-\u0013QPA\u0001\u0002\u0004\ti\u0003\u0003\u0005\u0002\b\u0002\u0001\u000b\u0015BA\u0017\u0003A\u0011XmZ5ti\u0016\u0014X\r\u001a+j[\u0016\u0014\b\u0005C\u0006\u0002\f\u0002\u0001\r\u00111A\u0005\u0012\u00055\u0015a\u00045fC\u0012,'oQ8mY\u0016\u001cGo\u001c:\u0016\u0005\u0005=\u0005#BAI\u0003/SRBAAJ\u0015\r\t)\nB\u0001\nG>dG.Z2u_JLA!!'\u0002\u0014\ny\u0001*Z1eKJ\u001cu\u000e\u001c7fGR|'\u000fC\u0006\u0002\u001e\u0002\u0001\r\u00111A\u0005\u0012\u0005}\u0015a\u00055fC\u0012,'oQ8mY\u0016\u001cGo\u001c:`I\u0015\fH\u0003BA\"\u0003CC!\"a\u0013\u0002\u001c\u0006\u0005\t\u0019AAH\u0011!\t)\u000b\u0001Q!\n\u0005=\u0015\u0001\u00055fC\u0012,'oQ8mY\u0016\u001cGo\u001c:!\u0011-\t)\n\u0001a\u0001\u0002\u0004%I!!+\u0016\u0005\u0005-\u0006\u0003B\t\u0002.jI1!a,\u0013\u0005Q!\u0016.\\3ti\u0006l\u0007/\u001a3D_2dWm\u0019;pe\"Y\u00111\u0017\u0001A\u0002\u0003\u0007I\u0011BA[\u00035\u0019w\u000e\u001c7fGR|'o\u0018\u0013fcR!\u00111IA\\\u0011)\tY%!-\u0002\u0002\u0003\u0007\u00111\u0016\u0005\t\u0003w\u0003\u0001\u0015)\u0003\u0002,\u0006Q1m\u001c7mK\u000e$xN\u001d\u0011\t\u0017\u0005}\u0006\u00011AA\u0002\u0013%\u0011\u0011Y\u0001\ri&lWM]*feZL7-Z\u000b\u0003\u0003\u0007\u0004B!EAcY%\u0019\u0011q\u0019\n\u0003)%sG/\u001a:oC2$\u0016.\\3s'\u0016\u0014h/[2f\u0011-\tY\r\u0001a\u0001\u0002\u0004%I!!4\u0002!QLW.\u001a:TKJ4\u0018nY3`I\u0015\fH\u0003BA\"\u0003\u001fD!\"a\u0013\u0002J\u0006\u0005\t\u0019AAb\u0011!\t\u0019\u000e\u0001Q!\n\u0005\r\u0017!\u0004;j[\u0016\u00148+\u001a:wS\u000e,\u0007\u0005C\u0006\u0002X\u0002\u0001\r\u00111A\u0005\n\u0005e\u0017\u0001\u00046pS:4UO\\2uS>tW#A\u001d\t\u0017\u0005u\u0007\u00011AA\u0002\u0013%\u0011q\\\u0001\u0011U>LgNR;oGRLwN\\0%KF$B!a\u0011\u0002b\"I\u00111JAn\u0003\u0003\u0005\r!\u000f\u0005\b\u0003K\u0004\u0001\u0015)\u0003:\u00035Qw.\u001b8Gk:\u001cG/[8oA!9\u0011\u0011\u001e\u0001\u0005B\u0005-\u0018\u0001B8qK:$\"!a\u0011\t\u000f\u0005=\b\u0001\"\u0011\u0002r\u0006y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007\u0006\u0003\u0002t\u0006e\bcA\t\u0002v&\u0019\u0011q\u001f\n\u0003#Q;x.\u00138qkR\u001cV\r\\3di&|g\u000e\u0003\u0005\u0002|\u00065\b\u0019AA\u007f\u0003\u001d)G.Z7f]R\u0004R!a@\u0003\bii!A!\u0001\u000b\t\t\r!QA\u0001\rgR\u0014X-Y7sK\u000e|'\u000f\u001a\u0006\u0003\u000bYIAA!\u0003\u0003\u0002\ta1\u000b\u001e:fC6\u0014VmY8sI\"9!Q\u0002\u0001\u0005B\t=\u0011a\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u001a\u0015\t\u0005M(\u0011\u0003\u0005\t\u0003w\u0014Y\u00011\u0001\u0002~\"9!Q\u0003\u0001\u0005\n\t]\u0011!\u0006:fO&\u001cH/\u001a:T[\u0006dG.Z:u)&lWM\u001d\u000b\u0005\u0003\u0007\u0012I\u0002\u0003\u0005\u0003\u001c\tM\u0001\u0019\u0001B\u000f\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002(\u0005?I1!a\u000f)\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K\tQB]3hSN$XM\u001d+j[\u0016\u0014H\u0003BA\"\u0005OA\u0001Ba\u0007\u0003\"\u0001\u0007!Q\u0004\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0003Ayg\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\r\u0006\u0003\u0002D\t=\u0002\u0002\u0003B\u0019\u0005S\u0001\rAa\r\u0002\u000bQLW.\u001a:\u0011\u000bE\u0011)D\n\u0017\n\u0007\t]\"CA\u0007J]R,'O\\1m)&lWM\u001d\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0003-yg.\u0012<f]R$\u0016.\\3\u0015\t\u0005\r#q\b\u0005\t\u0005c\u0011I\u00041\u0001\u00034!9!1\t\u0001\u0005\n\t\u0015\u0013!G3nSR\u0014Vm];mi\u0006sGm\u00117fC:,\u0006o\u0015;bi\u0016$BA!\b\u0003H!A!\u0011\nB!\u0001\u0004\u0011i\"\u0001\buS6,'\u000fV5nKN$\u0018-\u001c9\t\u000f\t5\u0003\u0001\"\u0003\u0003P\u0005a1\r\\3b]V\u00038\u000b^1uKR1\u00111\tB)\u0005'B\u0001B!\u0013\u0003L\u0001\u0007!Q\u0004\u0005\t\u0005+\u0012Y\u00051\u0001\u0003X\u0005y!/[4iiJ{wo]*peR,G\rE\u0003\u0003Z\tu#$\u0004\u0002\u0003\\)\u0011QI^\u0005\u0005\u0005?\u0012YF\u0001\u0003MSN$\bb\u0002B2\u0001\u0011%!QM\u0001\u0011M&\u00148\u000f^%oI\u0016DHk\\&fKB$Ra\u0018B4\u0005SB\u0001B!\u0013\u0003b\u0001\u0007!Q\u0004\u0005\t\u0005+\u0012\t\u00071\u0001\u0003X!9!Q\u000e\u0001\u0005\n\t=\u0014!I5oI\u0016DxJ\u001a$jeN$X\t\\3nK:$h*Z<feRC\u0017M\u001c+j[\u0016\u0014H#B0\u0003r\tM\u0004\u0002\u0003B%\u0005W\u0002\rA!\b\t\u0011\tU$1\u000ea\u0001\u0005/\nA\u0001\\5ti\"9!\u0011\u0010\u0001\u0005\n\tm\u0014\u0001\u00067bi\u0016\u001cHOU5hQR\u0014vn\u001e+p\u0015>Lg\u000e\u0006\u0004\u0003~\t\r%Q\u0011\t\u0006\u00053\u0012yHG\u0005\u0005\u0005\u0003\u0013YF\u0001\u0005PaRLwN\\1m\u0011!\u0011)Fa\u001eA\u0002\t]\u0003\u0002\u0003BD\u0005o\u0002\rA!\b\u0002\u00111,g\r\u001e+j[\u0016DqA!\u001f\u0001\t\u0013\u0011Y\t\u0006\u0006\u0003~\t5%q\u0012BJ\u0005/C\u0001B!\u0016\u0003\n\u0002\u0007!q\u000b\u0005\b\u0005#\u0013I\t1\u0001`\u0003\rawn\u001e\u0005\b\u0005+\u0013I\t1\u0001`\u0003\u0011A\u0017n\u001a5\t\u0011\t\u001d%\u0011\u0012a\u0001\u0005;AqAa'\u0001\t\u0013\u0011i*\u0001\nhKR\u0014\u0016n\u001a5u%><8oU8si\u0016$G\u0003\u0002B,\u0005?C\u0001B!)\u0003\u001a\u0002\u0007\u0011QD\u0001\u0012e><H/[7f\u0007>l\u0007/\u0019:bi>\u0014\bb\u0002BS\u0001\u0011%!qU\u0001\u0011O\u0016$h*\u001a=u\u0019\u00164G/\u00138eKb,\"!a\u000e\t\u000f\t-\u0006\u0001\"\u0003\u0003.\u0006Yq-\u001a;MK\u001a$H+[7f)\u0011\u0011iBa,\t\u000f\tE&\u0011\u0016a\u00015\u00059A.\u001a4u%><\bb\u0002B[\u0001\u0011%!qW\u0001\rO\u0016$(+[4iiRKW.\u001a\u000b\u0005\u0005;\u0011I\fC\u0004\u0003<\nM\u0006\u0019\u0001\u000e\u0002\u0011ILw\r\u001b;S_^DqAa0\u0001\t\u0013\u0011\t-\u0001\ndQ\u0016\u001c7NT8u%\u0016$(/Y2uS>tG\u0003BA\"\u0005\u0007DqA!2\u0003>\u0002\u0007!$A\u0002s_^DqA!3\u0001\t\u0003\u0012Y-A\ngSJ\u001cH/\u00138qkR\u001cV\r\\3di&|g\u000e\u0006\u0002\u0002t\"9!q\u001a\u0001\u0005B\u0005-\u0018!C3oI&s\u0007/\u001e;2\u0011\u001d\u0011\u0019\u000e\u0001C!\u0003W\f\u0011\"\u001a8e\u0013:\u0004X\u000f\u001e\u001a")
public class TemporalRowtimeJoin
extends AbstractStreamOperator<BaseRow>
implements TwoInputStreamOperator<BaseRow, BaseRow, BaseRow>,
Triggerable<Object, VoidNamespace>,
Compiler<FlatJoinFunction<BaseRow, BaseRow, BaseRow>>,
Logging {
    private final TypeInformation<BaseRow> leftType;
    private final TypeInformation<BaseRow> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, BaseRow> leftState;
    private MapState<Long, BaseRow> rightState;
    private ValueState<Long> registeredTimer;
    private HeaderCollector<BaseRow> headerCollector;
    private TimestampedCollector<BaseRow> collector;
    private InternalTimerService<VoidNamespace> timerService;
    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, BaseRow> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, BaseRow> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, BaseRow> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, BaseRow> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    public HeaderCollector<BaseRow> headerCollector() {
        return this.headerCollector;
    }

    public void headerCollector_$eq(HeaderCollector<BaseRow> x$1) {
        this.headerCollector = x$1;
    }

    private TimestampedCollector<BaseRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<BaseRow> x$1) {
        this.collector = x$1;
    }

    private InternalTimerService<VoidNamespace> timerService() {
        return this.timerService;
    }

    private void timerService_$eq(InternalTimerService<VoidNamespace> x$1) {
        this.timerService = x$1;
    }

    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<BaseRow, BaseRow, BaseRow> x$1) {
        this.joinFunction = x$1;
    }

    public void open() {
        Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), new Configuration());
        this.nextLeftIndex_$eq(this.getRuntimeContext().getState(new ValueStateDescriptor<Long>(this.NEXT_LEFT_INDEX_STATE_NAME(), BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq(this.getRuntimeContext().getMapState(new MapStateDescriptor<Long, BaseRow>(this.LEFT_STATE_NAME(), (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq(this.getRuntimeContext().getMapState(new MapStateDescriptor<Long, BaseRow>(this.RIGHT_STATE_NAME(), (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq(this.getRuntimeContext().getState(new ValueStateDescriptor<Long>(this.REGISTERED_TIMER_STATE_NAME(), BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<BaseRow>)new TimestampedCollector(this.output));
        this.headerCollector_$eq(new HeaderCollector<BaseRow>());
        this.headerCollector().out_$eq((Collector<BaseRow>)this.collector());
        this.headerCollector().setHeader((byte)0);
        this.timerService_$eq((InternalTimerService<VoidNamespace>)this.getInternalTimerService(this.TIMERS_STATE_NAME(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this));
    }

    public TwoInputSelection processElement1(StreamRecord<BaseRow> element) {
        BaseRow row2 = (BaseRow)element.getValue();
        this.checkNotRetraction(row2);
        this.leftState().put(this.getNextLeftIndex(), row2);
        this.registerSmallestTimer(this.getLeftTime(row2));
        return TwoInputSelection.ANY;
    }

    public TwoInputSelection processElement2(StreamRecord<BaseRow> element) {
        BaseRow row2 = (BaseRow)element.getValue();
        this.checkNotRetraction(row2);
        long rowTime = this.getRightTime(row2);
        this.rightState().put(Predef$.MODULE$.long2Long(rowTime), row2);
        this.registerSmallestTimer(rowTime);
        return TwoInputSelection.ANY;
    }

    private void registerSmallestTimer(long timestamp) {
        Long currentRegisteredTimer = this.registeredTimer().value();
        if (currentRegisteredTimer == null) {
            this.registerTimer(timestamp);
        } else if (currentRegisteredTimer != null && Predef$.MODULE$.Long2long(currentRegisteredTimer) > timestamp) {
            this.timerService().deleteEventTimeTimer((Object)VoidNamespace.INSTANCE, Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update(Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer((Object)VoidNamespace.INSTANCE, timestamp);
    }

    public void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        throw new IllegalStateException("This should never happen");
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        this.registeredTimer().clear();
        long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
        if (lastUnprocessedTime < Long.MAX_VALUE) {
            this.registerTimer(lastUnprocessedTime);
        }
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<BaseRow> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator<Map.Entry<Long, BaseRow>> leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry<Long, BaseRow> leftEntry = leftIterator.next();
            BaseRow leftRow = leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<BaseRow> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join(leftRow, rightRow.get(), this.headerCollector());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<BaseRow> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove(Predef$.MODULE$.long2Long(rightTime));
        }
    }

    private int firstIndexToKeep(long timerTimestamp, List<BaseRow> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<BaseRow> list) {
        ListIterator<BaseRow> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<BaseRow> latestRightRowToJoin(List<BaseRow> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<BaseRow> latestRightRowToJoin(List<BaseRow> rightRowsSorted, int low, int high, long leftTime) {
        Optional<BaseRow> optional;
        block3: {
            BaseRow midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<BaseRow> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<BaseRow> rightRows = new ArrayList<BaseRow>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(this.rightState().values()).foreach((Function1)new Serializable(this, rightRows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rightRows$1;

            public final boolean apply(BaseRow row2) {
                return this.rightRows$1.add(row2);
            }
            {
                this.rightRows$1 = rightRows$1;
            }
        });
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update(Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(BaseRow leftRow) {
        return leftRow.getLong(this.leftTimeAttribute);
    }

    private long getRightTime(BaseRow rightRow) {
        return rightRow.getLong(this.rightTimeAttribute);
    }

    private void checkNotRetraction(BaseRow row2) {
        if (BaseRowUtil.isRetractMsg(row2)) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retractions are not supported by [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TemporalRowtimeJoin.class.getSimpleName()}))).append((Object)"If this can happen it should be validated during planning!").toString());
        }
    }

    public TwoInputSelection firstInputSelection() {
        return TwoInputSelection.ANY;
    }

    public void endInput1() {
    }

    public void endInput2() {
    }

    public TemporalRowtimeJoin(TypeInformation<BaseRow> leftType, TypeInformation<BaseRow> rightType, String genJoinFuncName, String genJoinFuncCode, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

