/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.FlinkJoinRelType;
import org.apache.flink.table.runtime.join.EmitAwareCollector;
import org.apache.flink.table.runtime.join.EmitAwareCollector$;
import org.apache.flink.table.runtime.join.OuterJoinPaddingUtil;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%g!B\u0001\u0003\u0003\u0003y!!\u0006+j[\u0016\u0014u.\u001e8eK\u0012\u001cFO]3b[*{\u0017N\u001c\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t#aA)\u0011C\u0007\u000f\u001d95\t!C\u0003\u0002\u0014)\u0005\u00111m\u001c\u0006\u0003+Y\t\u0011BZ;oGRLwN\\:\u000b\u0005]A\u0012aA1qS*\u0011\u0011\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!a\u0007\n\u0003#\r{\u0007K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u0005QA-\u0019;bM>\u0014X.\u0019;\n\u0005\u0005r\"a\u0002\"bg\u0016\u0014vn\u001e\t\u0004G\u0019BS\"\u0001\u0013\u000b\u0005\u00152\u0011aB2pI\u0016<WM\\\u0005\u0003O\u0011\u0012\u0001bQ8na&dWM\u001d\t\u0006S9bB\u0004H\u0007\u0002U)\u0011Qc\u000b\u0006\u0003Y5\naaY8n[>t'BA\f\t\u0013\ty#F\u0001\tGY\u0006$(j\\5o\rVt7\r^5p]B\u0011\u0011\u0007N\u0007\u0002e)\u00111GB\u0001\u0005kRLG.\u0003\u00026e\t9Aj\\4hS:<\u0007\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011\u0002\u001d\u0002\u0011)|\u0017N\u001c+za\u0016,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y\u0019\tA\u0001\u001d7b]&\u0011ah\u000f\u0002\u0011\r2Lgn\u001b&pS:\u0014V\r\u001c+za\u0016D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!O\u0001\nU>Lg\u000eV=qK\u0002B\u0001B\u0011\u0001\u0003\u0006\u0004%IaQ\u0001\u000fY\u00164G\u000fT8xKJ\u0014u.\u001e8e+\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%\u0001\u0002'p]\u001eD\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u0010Y\u00164G\u000fT8xKJ\u0014u.\u001e8eA!AQ\n\u0001BC\u0002\u0013%1)\u0001\bmK\u001a$X\u000b\u001d9fe\n{WO\u001c3\t\u0011=\u0003!\u0011!Q\u0001\n\u0011\u000bq\u0002\\3giV\u0003\b/\u001a:C_VtG\r\t\u0005\t#\u0002\u0011)\u0019!C\u0005\u0007\u0006i\u0011\r\u001c7po2\u000bG/\u001a8fgND\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001R\u0001\u000fC2dwn\u001e'bi\u0016tWm]:!\u0011!)\u0006A!b\u0001\n\u00131\u0016\u0001\u00037fMR$\u0016\u0010]3\u0016\u0003]\u00032\u0001W.\u001d\u001b\u0005I&B\u0001.,\u0003!!\u0018\u0010]3j]\u001a|\u0017B\u0001/Z\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B,\u0002\u00131,g\r\u001e+za\u0016\u0004\u0003\u0002\u00031\u0001\u0005\u000b\u0007I\u0011\u0002,\u0002\u0013ILw\r\u001b;UsB,\u0007\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B,\u0002\u0015ILw\r\u001b;UsB,\u0007\u0005\u0003\u0005e\u0001\t\u0015\r\u0011\"\u0003f\u0003=9WM\u001c&pS:4UO\\2OC6,W#\u00014\u0011\u0005\u001dTgBA#i\u0013\tIg)\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5G\u0011!q\u0007A!A!\u0002\u00131\u0017\u0001E4f]*{\u0017N\u001c$v]\u000et\u0015-\\3!\u0011!\u0001\bA!a\u0001\n\u0013)\u0017aD4f]*{\u0017N\u001c$v]\u000e\u001cu\u000eZ3\t\u0011I\u0004!\u00111A\u0005\nM\f1cZ3o\u0015>LgNR;oG\u000e{G-Z0%KF$\"\u0001^<\u0011\u0005\u0015+\u0018B\u0001<G\u0005\u0011)f.\u001b;\t\u000fa\f\u0018\u0011!a\u0001M\u0006\u0019\u0001\u0010J\u0019\t\u0011i\u0004!\u0011!Q!\n\u0019\f\u0001cZ3o\u0015>LgNR;oG\u000e{G-\u001a\u0011\t\u000bq\u0004A\u0011A?\u0002\rqJg.\u001b;?)Eq\u0018\u0011AA\u0002\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011q\u0002\t\u0003\u007f\u0002i\u0011A\u0001\u0005\u0006om\u0004\r!\u000f\u0005\u0006\u0005n\u0004\r\u0001\u0012\u0005\u0006\u001bn\u0004\r\u0001\u0012\u0005\u0006#n\u0004\r\u0001\u0012\u0005\u0006+n\u0004\ra\u0016\u0005\u0006An\u0004\ra\u0016\u0005\u0006In\u0004\rA\u001a\u0005\u0006an\u0004\rA\u001a\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+\t1\u0002]1eI&tw-\u0016;jYV\u0011\u0011q\u0003\t\u0004\u007f\u0006e\u0011bAA\u000e\u0005\t!r*\u001e;fe*{\u0017N\u001c)bI\u0012LgnZ+uS2D\u0001\"a\b\u0001A\u0003%\u0011qC\u0001\ra\u0006$G-\u001b8h+RLG\u000e\t\u0005\f\u0003G\u0001\u0001\u0019!a\u0001\n\u0013\t)#A\u0007k_&t7i\u001c7mK\u000e$xN]\u000b\u0003\u0003O\u00012a`A\u0015\u0013\r\tYC\u0001\u0002\u0013\u000b6LG/Q<be\u0016\u001cu\u000e\u001c7fGR|'\u000fC\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0012!\u00056pS:\u001cu\u000e\u001c7fGR|'o\u0018\u0013fcR\u0019A/a\r\t\u0013a\fi#!AA\u0002\u0005\u001d\u0002\u0002CA\u001c\u0001\u0001\u0006K!a\n\u0002\u001d)|\u0017N\\\"pY2,7\r^8sA!Y\u00111\b\u0001A\u0002\u0003\u0007I\u0011BA\u001f\u00031Qw.\u001b8Gk:\u001cG/[8o+\u0005A\u0003bCA!\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007\n\u0001C[8j]\u001a+hn\u0019;j_:|F%Z9\u0015\u0007Q\f)\u0005\u0003\u0005y\u0003\u007f\t\t\u00111\u0001)\u0011\u001d\tI\u0005\u0001Q!\n!\nQB[8j]\u001a+hn\u0019;j_:\u0004\u0003bCA'\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001f\n\u0011\u0002\\3gi\u000e\u000b7\r[3\u0016\u0005\u0005E\u0003cBA*\u00033\"\u0015QL\u0007\u0003\u0003+R1!a\u0016,\u0003\u0015\u0019H/\u0019;f\u0013\u0011\tY&!\u0016\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004R!a\u0018\u0002hqi!!!\u0019\u000b\u0007M\n\u0019G\u0003\u0002\u0002f\u0005!!.\u0019<b\u0013\u0011\tI'!\u0019\u0003\t1K7\u000f\u001e\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty'A\u0007mK\u001a$8)Y2iK~#S-\u001d\u000b\u0004i\u0006E\u0004\"\u0003=\u0002l\u0005\u0005\t\u0019AA)\u0011!\t)\b\u0001Q!\n\u0005E\u0013A\u00037fMR\u001c\u0015m\u00195fA!Y\u0011\u0011\u0010\u0001A\u0002\u0003\u0007I\u0011BA(\u0003)\u0011\u0018n\u001a5u\u0007\u0006\u001c\u0007.\u001a\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty(\u0001\bsS\u001eDGoQ1dQ\u0016|F%Z9\u0015\u0007Q\f\t\tC\u0005y\u0003w\n\t\u00111\u0001\u0002R!A\u0011Q\u0011\u0001!B\u0013\t\t&A\u0006sS\u001eDGoQ1dQ\u0016\u0004\u0003bCAE\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\u000ba\u0002\\3giRKW.\u001a:Ti\u0006$X-\u0006\u0002\u0002\u000eB)\u00111KAH\t&!\u0011\u0011SA+\u0005)1\u0016\r\\;f'R\fG/\u001a\u0005\f\u0003+\u0003\u0001\u0019!a\u0001\n\u0013\t9*\u0001\nmK\u001a$H+[7feN#\u0018\r^3`I\u0015\fHc\u0001;\u0002\u001a\"I\u00010a%\u0002\u0002\u0003\u0007\u0011Q\u0012\u0005\t\u0003;\u0003\u0001\u0015)\u0003\u0002\u000e\u0006yA.\u001a4u)&lWM]*uCR,\u0007\u0005C\u0006\u0002\"\u0002\u0001\r\u00111A\u0005\n\u0005-\u0015a\u0004:jO\"$H+[7feN#\u0018\r^3\t\u0017\u0005\u0015\u0006\u00011AA\u0002\u0013%\u0011qU\u0001\u0014e&<\u0007\u000e\u001e+j[\u0016\u00148\u000b^1uK~#S-\u001d\u000b\u0004i\u0006%\u0006\"\u0003=\u0002$\u0006\u0005\t\u0019AAG\u0011!\ti\u000b\u0001Q!\n\u00055\u0015\u0001\u0005:jO\"$H+[7feN#\u0018\r^3!\u0011!\t\t\f\u0001b\u0001\n#\u0019\u0015\u0001\u00057fMR\u0014V\r\\1uSZ,7+\u001b>f\u0011\u001d\t)\f\u0001Q\u0001\n\u0011\u000b\u0011\u0003\\3giJ+G.\u0019;jm\u0016\u001c\u0016N_3!\u0011!\tI\f\u0001b\u0001\n#\u0019\u0015!\u0005:jO\"$(+\u001a7bi&4XmU5{K\"9\u0011Q\u0018\u0001!\u0002\u0013!\u0015A\u0005:jO\"$(+\u001a7bi&4XmU5{K\u0002B\u0001\"!1\u0001\u0001\u0004%IaQ\u0001\u0013Y\u00164G/\u0012=qSJ\fG/[8o)&lW\rC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002H\u00061B.\u001a4u\u000bb\u0004\u0018N]1uS>tG+[7f?\u0012*\u0017\u000fF\u0002u\u0003\u0013D\u0001\u0002_Ab\u0003\u0003\u0005\r\u0001\u0012\u0005\b\u0003\u001b\u0004\u0001\u0015)\u0003E\u0003MaWM\u001a;FqBL'/\u0019;j_:$\u0016.\\3!\u0011!\t\t\u000e\u0001a\u0001\n\u0013\u0019\u0015a\u0005:jO\"$X\t\u001f9je\u0006$\u0018n\u001c8US6,\u0007\"CAk\u0001\u0001\u0007I\u0011BAl\u0003]\u0011\u0018n\u001a5u\u000bb\u0004\u0018N]1uS>tG+[7f?\u0012*\u0017\u000fF\u0002u\u00033D\u0001\u0002_Aj\u0003\u0003\u0005\r\u0001\u0012\u0005\b\u0003;\u0004\u0001\u0015)\u0003E\u0003Q\u0011\u0018n\u001a5u\u000bb\u0004\u0018N]1uS>tG+[7fA!A\u0011\u0011\u001d\u0001A\u0002\u0013E1)\u0001\tmK\u001a$x\n]3sCR|'\u000fV5nK\"I\u0011Q\u001d\u0001A\u0002\u0013E\u0011q]\u0001\u0015Y\u00164Go\u00149fe\u0006$xN\u001d+j[\u0016|F%Z9\u0015\u0007Q\fI\u000f\u0003\u0005y\u0003G\f\t\u00111\u0001E\u0011\u001d\ti\u000f\u0001Q!\n\u0011\u000b\u0011\u0003\\3gi>\u0003XM]1u_J$\u0016.\\3!\u0011!\t\t\u0010\u0001a\u0001\n#\u0019\u0015!\u0005:jO\"$x\n]3sCR|'\u000fV5nK\"I\u0011Q\u001f\u0001A\u0002\u0013E\u0011q_\u0001\u0016e&<\u0007\u000e^(qKJ\fGo\u001c:US6,w\fJ3r)\r!\u0018\u0011 \u0005\tq\u0006M\u0018\u0011!a\u0001\t\"9\u0011Q \u0001!B\u0013!\u0015A\u0005:jO\"$x\n]3sCR|'\u000fV5nK\u0002B\u0001B!\u0001\u0001\u0005\u0004%IaQ\u0001\u0012[&\u001cE.Z1o+BLe\u000e^3sm\u0006d\u0007b\u0002B\u0003\u0001\u0001\u0006I\u0001R\u0001\u0013[&\u001cE.Z1o+BLe\u000e^3sm\u0006d\u0007\u0005C\u0004\u0003\n\u0001!\tEa\u0003\u0002\t=\u0004XM\u001c\u000b\u0004i\n5\u0001\u0002\u0003B\b\u0005\u000f\u0001\rA!\u0005\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119\u0002C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\tm!Q\u0003\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\t}\u0001\u0001\"\u0011\u0003\"\u0005y\u0001O]8dKN\u001cX\t\\3nK:$\u0018\u0007F\u0004u\u0005G\u00119C!\r\t\u000f\t\u0015\"Q\u0004a\u00019\u0005)a/\u00197vK\"A!\u0011\u0006B\u000f\u0001\u0004\u0011Y#A\u0002dib\u00042\u0001\u0005B\u0017\u0013\r\u0011yC\u0007\u0002\b\u0007>tG/\u001a=u\u0011!\u0011\u0019D!\bA\u0002\tU\u0012aA8viB)!q\u0007B\u001e95\u0011!\u0011\b\u0006\u0003g!IAA!\u0010\u0003:\tI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0003=\u0001(o\\2fgN,E.Z7f]R\u0014Dc\u0002;\u0003F\t\u001d#\u0011\n\u0005\b\u0005K\u0011y\u00041\u0001\u001d\u0011!\u0011ICa\u0010A\u0002\t-\u0002\u0002\u0003B\u001a\u0005\u007f\u0001\rA!\u000e\t\u000f\t5\u0003\u0001\"\u0011\u0003P\u00059qN\u001c+j[\u0016\u0014Hc\u0002;\u0003R\tU#Q\f\u0005\b\u0005'\u0012Y\u00051\u0001E\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0003*\t-\u0003\u0019\u0001B,!\r\u0001\"\u0011L\u0005\u0004\u00057R\"AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0005g\u0011Y\u00051\u0001\u00036!9!\u0011\r\u0001\u0005\n\t\r\u0014!E2bY\u0016C\b/\u001b:bi&|g\u000eV5nKR)AI!\u001a\u0003j!9!q\rB0\u0001\u0004!\u0015\u0001D8qKJ\fGo\u001c:US6,\u0007b\u0002B6\u0005?\u0002\r\u0001R\u0001\re\u0016d\u0017\r^5wKNK'0\u001a\u0005\b\u0005_\u0002A\u0011\u0002B9\u0003Q\u0011XmZ5ti\u0016\u00148\t\\3b]V\u0003H+[7feR9AOa\u001d\u0003v\te\u0004\u0002\u0003B\u0015\u0005[\u0002\rAa\u000b\t\u000f\t]$Q\u000ea\u0001\t\u00069!o\\<US6,\u0007\u0002\u0003B>\u0005[\u0002\rA! \u0002\u000f1,g\r\u001e*poB\u0019QIa \n\u0007\t\u0005eIA\u0004C_>dW-\u00198\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u0006\t\"/Z7pm\u0016,\u0005\u0010]5sK\u0012\u0014vn^:\u0015\u001bQ\u0014II!$\u0003\u0012\nU%\u0011\u0014BN\u0011!\u0011YIa!A\u0002\tU\u0012!C2pY2,7\r^8s\u0011\u001d\u0011yIa!A\u0002\u0011\u000ba\"\u001a=qSJ\fG/[8o)&lW\r\u0003\u0005\u0003\u0014\n\r\u0005\u0019AA)\u0003!\u0011xn^\"bG\",\u0007\u0002\u0003BL\u0005\u0007\u0003\r!!$\u0002\u0015QLW.\u001a:Ti\u0006$X\r\u0003\u0005\u0003*\t\r\u0005\u0019\u0001B,\u0011!\u0011iJa!A\u0002\tu\u0014A\u0003:f[>4X\rT3gi\"9!\u0011\u0015\u0001\u0007\u0002\t\r\u0016AE;qI\u0006$Xm\u00149fe\u0006$xN\u001d+j[\u0016$2\u0001\u001eBS\u0011!\u0011ICa(A\u0002\t-\u0002b\u0002BU\u0001\u0019\u0005!1V\u0001\u0015O\u0016$H+[7f\r>\u0014H*\u001a4u'R\u0014X-Y7\u0015\u000b\u0011\u0013iKa,\t\u0011\t%\"q\u0015a\u0001\u0005WAqA!-\u0003(\u0002\u0007A$A\u0002s_^DqA!.\u0001\r\u0003\u00119,A\u000bhKR$\u0016.\\3G_J\u0014\u0016n\u001a5u'R\u0014X-Y7\u0015\u000b\u0011\u0013ILa/\t\u0011\t%\"1\u0017a\u0001\u0005WAqA!-\u00034\u0002\u0007A\u0004C\u0004\u0003@\u00021\tA!1\u0002\u001bI,w-[:uKJ$\u0016.\\3s)\u0015!(1\u0019Bc\u0011!\u0011IC!0A\u0002\t-\u0002b\u0002Bd\u0005{\u0003\r\u0001R\u0001\fG2,\u0017M\\;q)&lW\r")
public abstract class TimeBoundedStreamJoin
extends CoProcessFunction<BaseRow, BaseRow, BaseRow>
implements Compiler<FlatJoinFunction<BaseRow, BaseRow, BaseRow>>,
Logging {
    private final FlinkJoinRelType joinType;
    private final long leftLowerBound;
    private final long leftUpperBound;
    private final long allowLateness;
    private final TypeInformation<BaseRow> leftType;
    private final TypeInformation<BaseRow> rightType;
    private final String genJoinFuncName;
    private String genJoinFuncCode;
    private final OuterJoinPaddingUtil paddingUtil;
    private EmitAwareCollector joinCollector;
    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction;
    private MapState<Object, List<BaseRow>> leftCache;
    private MapState<Object, List<BaseRow>> rightCache;
    private ValueState<Object> leftTimerState;
    private ValueState<Object> rightTimerState;
    private final long leftRelativeSize;
    private final long rightRelativeSize;
    private long leftExpirationTime;
    private long rightExpirationTime;
    private long leftOperatorTime;
    private long rightOperatorTime;
    private final long miCleanUpInterval;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TimeBoundedStreamJoin timeBoundedStreamJoin = this;
        synchronized (timeBoundedStreamJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private FlinkJoinRelType joinType() {
        return this.joinType;
    }

    private long leftLowerBound() {
        return this.leftLowerBound;
    }

    private long leftUpperBound() {
        return this.leftUpperBound;
    }

    private long allowLateness() {
        return this.allowLateness;
    }

    private TypeInformation<BaseRow> leftType() {
        return this.leftType;
    }

    private TypeInformation<BaseRow> rightType() {
        return this.rightType;
    }

    private String genJoinFuncName() {
        return this.genJoinFuncName;
    }

    private String genJoinFuncCode() {
        return this.genJoinFuncCode;
    }

    private void genJoinFuncCode_$eq(String x$1) {
        this.genJoinFuncCode = x$1;
    }

    private OuterJoinPaddingUtil paddingUtil() {
        return this.paddingUtil;
    }

    private EmitAwareCollector joinCollector() {
        return this.joinCollector;
    }

    private void joinCollector_$eq(EmitAwareCollector x$1) {
        this.joinCollector = x$1;
    }

    private FlatJoinFunction<BaseRow, BaseRow, BaseRow> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<BaseRow, BaseRow, BaseRow> x$1) {
        this.joinFunction = x$1;
    }

    private MapState<Object, List<BaseRow>> leftCache() {
        return this.leftCache;
    }

    private void leftCache_$eq(MapState<Object, List<BaseRow>> x$1) {
        this.leftCache = x$1;
    }

    private MapState<Object, List<BaseRow>> rightCache() {
        return this.rightCache;
    }

    private void rightCache_$eq(MapState<Object, List<BaseRow>> x$1) {
        this.rightCache = x$1;
    }

    private ValueState<Object> leftTimerState() {
        return this.leftTimerState;
    }

    private void leftTimerState_$eq(ValueState<Object> x$1) {
        this.leftTimerState = x$1;
    }

    private ValueState<Object> rightTimerState() {
        return this.rightTimerState;
    }

    private void rightTimerState_$eq(ValueState<Object> x$1) {
        this.rightTimerState = x$1;
    }

    public long leftRelativeSize() {
        return this.leftRelativeSize;
    }

    public long rightRelativeSize() {
        return this.rightRelativeSize;
    }

    private long leftExpirationTime() {
        return this.leftExpirationTime;
    }

    private void leftExpirationTime_$eq(long x$1) {
        this.leftExpirationTime = x$1;
    }

    private long rightExpirationTime() {
        return this.rightExpirationTime;
    }

    private void rightExpirationTime_$eq(long x$1) {
        this.rightExpirationTime = x$1;
    }

    public long leftOperatorTime() {
        return this.leftOperatorTime;
    }

    public void leftOperatorTime_$eq(long x$1) {
        this.leftOperatorTime = x$1;
    }

    public long rightOperatorTime() {
        return this.rightOperatorTime;
    }

    public void rightOperatorTime_$eq(long x$1) {
        this.rightOperatorTime = x$1;
    }

    private long miCleanUpInterval() {
        return this.miCleanUpInterval;
    }

    public void open(Configuration parameters) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling JoinFunction: ", " \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncCode()}))).toString());
        Class<FlatJoinFunction<BaseRow, BaseRow, BaseRow>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName(), this.genJoinFuncCode());
        this.genJoinFuncCode_$eq(null);
        this.LOG().debug("Instantiating JoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        this.joinCollector_$eq(new EmitAwareCollector());
        ListTypeInfo<BaseRow> leftRowListTypeInfo = new ListTypeInfo<BaseRow>(this.leftType());
        MapStateDescriptor<Long, BaseRow> leftMapStateDescriptor = new MapStateDescriptor<Long, BaseRow>("leftRowMapState", (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation<BaseRow>)leftRowListTypeInfo);
        this.leftCache_$eq(this.getRuntimeContext().getMapState(leftMapStateDescriptor));
        ListTypeInfo<BaseRow> rightRowListTypeInfo = new ListTypeInfo<BaseRow>(this.rightType());
        MapStateDescriptor<Long, BaseRow> rightMapStateDescriptor = new MapStateDescriptor<Long, BaseRow>("rightMapState", (TypeInformation<Long>)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation<BaseRow>)rightRowListTypeInfo);
        this.rightCache_$eq(this.getRuntimeContext().getMapState(rightMapStateDescriptor));
        ValueStateDescriptor<Long> leftValueStateDescriptor = new ValueStateDescriptor<Long>("leftTimerValueState", Long.TYPE);
        this.leftTimerState_$eq(this.getRuntimeContext().getState(leftValueStateDescriptor));
        ValueStateDescriptor<Long> rightValueStateDescriptor = new ValueStateDescriptor<Long>("rightTimerState", Long.TYPE);
        this.rightTimerState_$eq(this.getRuntimeContext().getState(rightValueStateDescriptor));
    }

    public void processElement1(BaseRow value, CoProcessFunction.Context ctx, Collector<BaseRow> out) {
        block21: {
            boolean emitted;
            BaseRow leftRow;
            block22: {
                block20: {
                    long rightQualifiedUpperBound;
                    long timeForLeftRow;
                    block17: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        leftRow = value;
                        timeForLeftRow = this.getTimeForLeftStream(ctx, leftRow);
                        long rightQualifiedLowerBound = timeForLeftRow - this.rightRelativeSize();
                        rightQualifiedUpperBound = timeForLeftRow + this.leftRelativeSize();
                        emitted = false;
                        if (this.rightExpirationTime() >= rightQualifiedUpperBound) break block17;
                        this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
                        Iterator<Map.Entry<Object, List<BaseRow>>> rightIterator = this.rightCache().iterator();
                        while (rightIterator.hasNext()) {
                            block19: {
                                Map.Entry<Object, List<BaseRow>> rightEntry;
                                block18: {
                                    Object object;
                                    rightEntry = rightIterator.next();
                                    long rightTime = BoxesRunTime.unboxToLong((Object)rightEntry.getKey());
                                    if (rightTime >= rightQualifiedLowerBound && rightTime <= rightQualifiedUpperBound) {
                                        List<BaseRow> rightRows = rightEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < rightRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            BaseRow row2 = rightRows.get(i);
                                            this.joinFunction().join(leftRow, row2, this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            FlinkJoinRelType flinkJoinRelType = this.joinType();
                                            FlinkJoinRelType flinkJoinRelType2 = FlinkJoinRelType.RIGHT;
                                            if (flinkJoinRelType == null ? flinkJoinRelType2 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType2)) {
                                                FlinkJoinRelType flinkJoinRelType3 = this.joinType();
                                                FlinkJoinRelType flinkJoinRelType4 = FlinkJoinRelType.FULL;
                                                if (flinkJoinRelType3 != null ? !((Object)((Object)flinkJoinRelType3)).equals((Object)flinkJoinRelType4) : flinkJoinRelType4 != null) continue;
                                            }
                                            if (EmitAwareCollector$.MODULE$.isJoined(row2) || !this.joinCollector().emitted()) continue;
                                            row2.setHeader(EmitAwareCollector$.MODULE$.JOINED());
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? rightEntry.setValue(rightRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (rightTime > this.rightExpirationTime()) continue;
                                    FlinkJoinRelType flinkJoinRelType = this.joinType();
                                    FlinkJoinRelType flinkJoinRelType5 = FlinkJoinRelType.RIGHT;
                                    if (!(flinkJoinRelType == null ? flinkJoinRelType5 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType5))) break block18;
                                    FlinkJoinRelType flinkJoinRelType6 = this.joinType();
                                    FlinkJoinRelType flinkJoinRelType7 = FlinkJoinRelType.FULL;
                                    if (flinkJoinRelType6 != null ? !((Object)((Object)flinkJoinRelType6)).equals((Object)flinkJoinRelType7) : flinkJoinRelType7 != null) break block19;
                                }
                                List<BaseRow> rightRows = rightEntry.getValue();
                                for (int i = 0; i < rightRows.size(); ++i) {
                                    BaseRow row3 = rightRows.get(i);
                                    if (EmitAwareCollector$.MODULE$.isJoined(row3)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padRight(row3));
                                }
                            }
                            rightIterator.remove();
                        }
                    }
                    if (this.rightOperatorTime() >= rightQualifiedUpperBound) break block20;
                    List<BaseRow> leftRowList = this.leftCache().get(BoxesRunTime.boxToLong((long)timeForLeftRow));
                    if (leftRowList == null) {
                        leftRowList = new ArrayList<BaseRow>(1);
                    }
                    leftRow.setHeader(emitted ? EmitAwareCollector$.MODULE$.JOINED() : EmitAwareCollector$.MODULE$.NONJOINED());
                    leftRowList.add(leftRow);
                    this.leftCache().put(BoxesRunTime.boxToLong((long)timeForLeftRow), leftRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) == 0L) {
                        this.registerCleanUpTimer(ctx, timeForLeftRow, true);
                    }
                    break block21;
                }
                FlinkJoinRelType flinkJoinRelType = this.joinType();
                FlinkJoinRelType flinkJoinRelType8 = FlinkJoinRelType.LEFT;
                if (!(flinkJoinRelType == null ? flinkJoinRelType8 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType8))) break block22;
                FlinkJoinRelType flinkJoinRelType9 = this.joinType();
                FlinkJoinRelType flinkJoinRelType10 = FlinkJoinRelType.FULL;
                if (flinkJoinRelType9 != null ? !((Object)((Object)flinkJoinRelType9)).equals((Object)flinkJoinRelType10) : flinkJoinRelType10 != null) break block21;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padLeft(leftRow));
            }
        }
    }

    public void processElement2(BaseRow value, CoProcessFunction.Context ctx, Collector<BaseRow> out) {
        block21: {
            boolean emitted;
            BaseRow rightRow;
            block22: {
                block20: {
                    long leftQualifiedUpperBound;
                    long timeForRightRow;
                    block17: {
                        this.joinCollector().innerCollector_$eq(out);
                        this.updateOperatorTime(ctx);
                        rightRow = value;
                        timeForRightRow = this.getTimeForRightStream(ctx, rightRow);
                        long leftQualifiedLowerBound = timeForRightRow - this.leftRelativeSize();
                        leftQualifiedUpperBound = timeForRightRow + this.rightRelativeSize();
                        emitted = false;
                        if (this.leftExpirationTime() >= leftQualifiedUpperBound) break block17;
                        this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
                        Iterator<Map.Entry<Object, List<BaseRow>>> leftIterator = this.leftCache().iterator();
                        while (leftIterator.hasNext()) {
                            block19: {
                                Map.Entry<Object, List<BaseRow>> leftEntry;
                                block18: {
                                    Object object;
                                    leftEntry = leftIterator.next();
                                    long leftTime = BoxesRunTime.unboxToLong((Object)leftEntry.getKey());
                                    if (leftTime >= leftQualifiedLowerBound && leftTime <= leftQualifiedUpperBound) {
                                        List<BaseRow> leftRows = leftEntry.getValue();
                                        boolean entryUpdated = false;
                                        for (int i = 0; i < leftRows.size(); ++i) {
                                            this.joinCollector().reset();
                                            BaseRow row2 = leftRows.get(i);
                                            this.joinFunction().join(row2, rightRow, this.joinCollector());
                                            emitted = emitted || this.joinCollector().emitted();
                                            FlinkJoinRelType flinkJoinRelType = this.joinType();
                                            FlinkJoinRelType flinkJoinRelType2 = FlinkJoinRelType.LEFT;
                                            if (flinkJoinRelType == null ? flinkJoinRelType2 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType2)) {
                                                FlinkJoinRelType flinkJoinRelType3 = this.joinType();
                                                FlinkJoinRelType flinkJoinRelType4 = FlinkJoinRelType.FULL;
                                                if (flinkJoinRelType3 != null ? !((Object)((Object)flinkJoinRelType3)).equals((Object)flinkJoinRelType4) : flinkJoinRelType4 != null) continue;
                                            }
                                            if (EmitAwareCollector$.MODULE$.isJoined(row2) || !this.joinCollector().emitted()) continue;
                                            row2.setHeader(EmitAwareCollector$.MODULE$.JOINED());
                                            entryUpdated = true;
                                        }
                                        object = entryUpdated ? leftEntry.setValue(leftRows) : BoxedUnit.UNIT;
                                    } else {
                                        object = BoxedUnit.UNIT;
                                    }
                                    if (leftTime > this.leftExpirationTime()) continue;
                                    FlinkJoinRelType flinkJoinRelType = this.joinType();
                                    FlinkJoinRelType flinkJoinRelType5 = FlinkJoinRelType.LEFT;
                                    if (!(flinkJoinRelType == null ? flinkJoinRelType5 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType5))) break block18;
                                    FlinkJoinRelType flinkJoinRelType6 = this.joinType();
                                    FlinkJoinRelType flinkJoinRelType7 = FlinkJoinRelType.FULL;
                                    if (flinkJoinRelType6 != null ? !((Object)((Object)flinkJoinRelType6)).equals((Object)flinkJoinRelType7) : flinkJoinRelType7 != null) break block19;
                                }
                                List<BaseRow> leftRows = leftEntry.getValue();
                                for (int i = 0; i < leftRows.size(); ++i) {
                                    BaseRow row3 = leftRows.get(i);
                                    if (EmitAwareCollector$.MODULE$.isJoined(row3)) continue;
                                    this.joinCollector().collect(this.paddingUtil().padLeft(row3));
                                }
                            }
                            leftIterator.remove();
                        }
                    }
                    if (this.leftOperatorTime() >= leftQualifiedUpperBound) break block20;
                    List<BaseRow> rightRowList = this.rightCache().get(BoxesRunTime.boxToLong((long)timeForRightRow));
                    if (rightRowList == null) {
                        rightRowList = new ArrayList<BaseRow>(1);
                    }
                    value.setHeader(emitted ? EmitAwareCollector$.MODULE$.JOINED() : EmitAwareCollector$.MODULE$.NONJOINED());
                    rightRowList.add(value);
                    this.rightCache().put(BoxesRunTime.boxToLong((long)timeForRightRow), rightRowList);
                    if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) == 0L) {
                        this.registerCleanUpTimer(ctx, timeForRightRow, false);
                    }
                    break block21;
                }
                FlinkJoinRelType flinkJoinRelType = this.joinType();
                FlinkJoinRelType flinkJoinRelType8 = FlinkJoinRelType.RIGHT;
                if (!(flinkJoinRelType == null ? flinkJoinRelType8 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType8))) break block22;
                FlinkJoinRelType flinkJoinRelType9 = this.joinType();
                FlinkJoinRelType flinkJoinRelType10 = FlinkJoinRelType.FULL;
                if (flinkJoinRelType9 != null ? !((Object)((Object)flinkJoinRelType9)).equals((Object)flinkJoinRelType10) : flinkJoinRelType10 != null) break block21;
            }
            if (!emitted) {
                this.joinCollector().collect(this.paddingUtil().padRight(rightRow));
            }
        }
    }

    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) {
        this.joinCollector().innerCollector_$eq(out);
        this.updateOperatorTime((CoProcessFunction.Context)ctx);
        if (BoxesRunTime.unboxToLong((Object)this.leftTimerState().value()) == timestamp) {
            this.rightExpirationTime_$eq(this.calExpirationTime(this.leftOperatorTime(), this.rightRelativeSize()));
            this.removeExpiredRows(this.joinCollector(), this.rightExpirationTime(), this.rightCache(), this.leftTimerState(), ctx, false);
        }
        if (BoxesRunTime.unboxToLong((Object)this.rightTimerState().value()) == timestamp) {
            this.leftExpirationTime_$eq(this.calExpirationTime(this.rightOperatorTime(), this.leftRelativeSize()));
            this.removeExpiredRows(this.joinCollector(), this.leftExpirationTime(), this.leftCache(), this.rightTimerState(), ctx, true);
        }
    }

    private long calExpirationTime(long operatorTime, long relativeSize) {
        return operatorTime < Long.MAX_VALUE ? operatorTime - relativeSize - this.allowLateness() - 1L : Long.MAX_VALUE;
    }

    private void registerCleanUpTimer(CoProcessFunction.Context ctx, long rowTime, boolean leftRow) {
        if (leftRow) {
            long cleanUpTime = rowTime + this.leftRelativeSize() + this.miCleanUpInterval() + this.allowLateness() + 1L;
            this.registerTimer(ctx, cleanUpTime);
            this.rightTimerState().update(BoxesRunTime.boxToLong((long)cleanUpTime));
        } else {
            long cleanUpTime = rowTime + this.rightRelativeSize() + this.miCleanUpInterval() + this.allowLateness() + 1L;
            this.registerTimer(ctx, cleanUpTime);
            this.leftTimerState().update(BoxesRunTime.boxToLong((long)cleanUpTime));
        }
    }

    private void removeExpiredRows(Collector<BaseRow> collector, long expirationTime, MapState<Object, List<BaseRow>> rowCache, ValueState<Object> timerState, CoProcessFunction.OnTimerContext ctx, boolean removeLeft) {
        Iterator<Map.Entry<Object, List<BaseRow>>> iterator = rowCache.iterator();
        long earliestTimestamp = -1L;
        while (iterator.hasNext()) {
            long rowTime;
            block6: {
                block9: {
                    Map.Entry<Object, List<BaseRow>> entry;
                    block10: {
                        block7: {
                            block8: {
                                entry = iterator.next();
                                rowTime = BoxesRunTime.unboxToLong((Object)entry.getKey());
                                if (rowTime > expirationTime) break block6;
                                if (!removeLeft) break block7;
                                FlinkJoinRelType flinkJoinRelType = this.joinType();
                                FlinkJoinRelType flinkJoinRelType2 = FlinkJoinRelType.LEFT;
                                if (!(flinkJoinRelType == null ? flinkJoinRelType2 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType2))) break block8;
                                FlinkJoinRelType flinkJoinRelType3 = this.joinType();
                                FlinkJoinRelType flinkJoinRelType4 = FlinkJoinRelType.FULL;
                                if (flinkJoinRelType3 != null ? !((Object)((Object)flinkJoinRelType3)).equals((Object)flinkJoinRelType4) : flinkJoinRelType4 != null) break block7;
                            }
                            List<BaseRow> rows = entry.getValue();
                            for (int i = 0; i < rows.size(); ++i) {
                                BaseRow row2 = rows.get(i);
                                if (EmitAwareCollector$.MODULE$.isJoined(row2)) continue;
                                collector.collect(this.paddingUtil().padLeft(row2));
                            }
                            break block9;
                        }
                        if (removeLeft) break block9;
                        FlinkJoinRelType flinkJoinRelType = this.joinType();
                        FlinkJoinRelType flinkJoinRelType5 = FlinkJoinRelType.RIGHT;
                        if (!(flinkJoinRelType == null ? flinkJoinRelType5 != null : !((Object)((Object)flinkJoinRelType)).equals((Object)flinkJoinRelType5))) break block10;
                        FlinkJoinRelType flinkJoinRelType6 = this.joinType();
                        FlinkJoinRelType flinkJoinRelType7 = FlinkJoinRelType.FULL;
                        if (flinkJoinRelType6 != null ? !((Object)((Object)flinkJoinRelType6)).equals((Object)flinkJoinRelType7) : flinkJoinRelType7 != null) break block9;
                    }
                    List<BaseRow> rows = entry.getValue();
                    for (int i = 0; i < rows.size(); ++i) {
                        BaseRow row3 = rows.get(i);
                        if (EmitAwareCollector$.MODULE$.isJoined(row3)) continue;
                        collector.collect(this.paddingUtil().padRight(row3));
                    }
                }
                iterator.remove();
                continue;
            }
            if (rowTime >= earliestTimestamp && earliestTimestamp >= 0L) continue;
            earliestTimestamp = rowTime;
        }
        if (earliestTimestamp > 0L) {
            this.registerCleanUpTimer((CoProcessFunction.Context)ctx, earliestTimestamp, removeLeft);
        } else {
            timerState.clear();
            rowCache.clear();
        }
    }

    public abstract void updateOperatorTime(CoProcessFunction.Context var1);

    public abstract long getTimeForLeftStream(CoProcessFunction.Context var1, BaseRow var2);

    public abstract long getTimeForRightStream(CoProcessFunction.Context var1, BaseRow var2);

    public abstract void registerTimer(CoProcessFunction.Context var1, long var2);

    public TimeBoundedStreamJoin(FlinkJoinRelType joinType, long leftLowerBound, long leftUpperBound, long allowLateness, TypeInformation<BaseRow> leftType, TypeInformation<BaseRow> rightType, String genJoinFuncName, String genJoinFuncCode) {
        this.joinType = joinType;
        this.leftLowerBound = leftLowerBound;
        this.leftUpperBound = leftUpperBound;
        this.allowLateness = allowLateness;
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.paddingUtil = new OuterJoinPaddingUtil(leftType.getArity(), rightType.getArity());
        this.leftRelativeSize = -leftLowerBound;
        this.rightRelativeSize = leftUpperBound;
        this.leftExpirationTime = 0L;
        this.rightExpirationTime = 0L;
        this.leftOperatorTime = 0L;
        this.rightOperatorTime = 0L;
        this.miCleanUpInterval = (this.leftRelativeSize() + this.rightRelativeSize()) / 2L;
        if (allowLateness < 0L) {
            throw new IllegalArgumentException("The allowed lateness must be non-negative.");
        }
    }
}

