/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch;

import org.apache.flink.table.plan.FlinkJoinRelType;

public enum HashJoinType {
    INNER,
    BUILD_OUTER,
    PROBE_OUTER,
    FULL_OUTER,
    SEMI,
    ANTI,
    BUILD_LEFT_SEMI,
    BUILD_LEFT_ANTI;


    public boolean isBuildOuter() {
        return this.equals((Object)BUILD_OUTER) || this.equals((Object)FULL_OUTER);
    }

    public boolean isProbeOuter() {
        return this.equals((Object)PROBE_OUTER) || this.equals((Object)FULL_OUTER);
    }

    public boolean buildLeftSemiOrAnti() {
        return this.equals((Object)BUILD_LEFT_SEMI) || this.equals((Object)BUILD_LEFT_ANTI);
    }

    public boolean needSetProbed() {
        return this.isBuildOuter() || this.buildLeftSemiOrAnti();
    }

    public static HashJoinType of(FlinkJoinRelType joinType, boolean leftIsBuild) {
        switch (joinType) {
            case INNER: {
                return INNER;
            }
            case LEFT: {
                return leftIsBuild ? BUILD_OUTER : PROBE_OUTER;
            }
            case RIGHT: {
                return leftIsBuild ? PROBE_OUTER : BUILD_OUTER;
            }
            case FULL: {
                return FULL_OUTER;
            }
            case SEMI: {
                return leftIsBuild ? BUILD_LEFT_SEMI : SEMI;
            }
            case ANTI: {
                return leftIsBuild ? BUILD_LEFT_ANTI : ANTI;
            }
        }
        throw new IllegalArgumentException("invalid: " + (Object)((Object)joinType));
    }

    public static HashJoinType of(boolean leftIsBuild, boolean leftOuter, boolean rightOuter) {
        if (leftOuter && rightOuter) {
            return FULL_OUTER;
        }
        if (leftOuter) {
            return leftIsBuild ? BUILD_OUTER : PROBE_OUTER;
        }
        if (rightOuter) {
            return leftIsBuild ? PROBE_OUTER : BUILD_OUTER;
        }
        return INNER;
    }
}

