/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.batch.hashtable.longtable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.SeekableDataInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.join.batch.hashtable.longtable.LongHashContext;
import org.apache.flink.table.runtime.join.batch.hashtable.longtable.LongHybridHashTable;
import org.apache.flink.table.runtime.util.AbstractChannelWriterOutputView;
import org.apache.flink.table.runtime.util.FileChannelUtil;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongHashPartition
extends AbstractPagedInputView
implements SeekableDataInputView {
    private static final Logger LOG = LoggerFactory.getLogger(LongHashPartition.class);
    private static final int SIZE_BITS = 28;
    private static final int SIZE_MASK = 0xFFFFFFF;
    static final long INVALID_ADDRESS = 0xFFFFFFFFFL;
    private final LongHashContext context;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private final int segmentSize;
    private int partitionNum;
    private final BinaryRowSerializer buildSideSerializer;
    private final BinaryRow buildReuseRow;
    private int recursionLevel;
    private int numBuckets;
    private long minKey = Long.MAX_VALUE;
    private long maxKey = Long.MIN_VALUE;
    private MemorySegment[] buckets;
    private int numBucketsMask;
    private MemorySegment[] partitionBuffers;
    private int finalBufferLimit;
    private int currentBufferNum;
    private BuildSideBuffer buildSideWriteBuffer;
    AbstractChannelWriterOutputView probeSideBuffer;
    long probeSideRecordCounter;
    private long numKeys;
    private final MatchIterator iterator;
    private BlockChannelWriter<MemorySegment> buildSideChannel;
    private long buildSideRecordCounter;
    int probeNumBytesInLastSeg;

    LongHashPartition(LongHashContext context, int partitionNum, BinaryRowSerializer buildSideSerializer, double estimatedRowCount, int maxSegs, int recursionLevel) {
        this(context, partitionNum, buildSideSerializer, LongHashPartition.getBucketBuffersByRowCount((long)estimatedRowCount, maxSegs, context.pageSize()), recursionLevel, null, 0);
        this.buildSideWriteBuffer = new BuildSideBuffer(context.nextSegment());
    }

    LongHashPartition(LongHashContext context, int partitionNum, BinaryRowSerializer buildSideSerializer, int bucketNumSegs, int recursionLevel, List<MemorySegment> buffers, int lastSegmentLimit) {
        this(context, buildSideSerializer, LongHashPartition.listToArray(buffers));
        this.partitionNum = partitionNum;
        this.recursionLevel = recursionLevel;
        int numBuckets = MathUtils.roundDownToPowerOf2(bucketNumSegs * this.segmentSize / 16);
        MemorySegment[] buckets = new MemorySegment[bucketNumSegs];
        for (int i = 0; i < bucketNumSegs; ++i) {
            buckets[i] = context.nextSegment();
        }
        this.setNewBuckets(buckets, numBuckets);
        this.finalBufferLimit = lastSegmentLimit;
    }

    LongHashPartition(LongHashContext context, BinaryRowSerializer buildSideSerializer, MemorySegment[] partitionBuffers) {
        super(0);
        this.context = context;
        this.buildSideSerializer = buildSideSerializer;
        this.buildReuseRow = buildSideSerializer.createInstance();
        this.segmentSize = context.pageSize();
        Preconditions.checkArgument(this.segmentSize % 16 == 0);
        this.partitionBuffers = partitionBuffers;
        this.segmentSizeBits = MathUtils.log2strict(this.segmentSize);
        this.segmentSizeMask = this.segmentSize - 1;
        this.finalBufferLimit = this.segmentSize;
        this.iterator = new MatchIterator();
    }

    private static MemorySegment[] listToArray(List<MemorySegment> list) {
        if (list != null) {
            return list.toArray(new MemorySegment[list.size()]);
        }
        return null;
    }

    private static int getBucketBuffersByRowCount(long rowCount, int maxSegs, int segmentSize) {
        int minNumBuckets = (int)Math.ceil((double)rowCount / 0.5);
        Preconditions.checkArgument(segmentSize % 16 == 0);
        return MathUtils.roundDownToPowerOf2((int)Math.max(1.0, Math.min((double)maxSegs, Math.ceil((double)minNumBuckets * 16.0 / (double)segmentSize))));
    }

    private void setNewBuckets(MemorySegment[] buckets, int numBuckets) {
        for (MemorySegment segment : buckets) {
            for (int i = 0; i < this.segmentSize; i += 16) {
                segment.putLong(i, 0L);
                segment.putLong(i + 8, 0xFFFFFFFFFL);
            }
        }
        this.buckets = buckets;
        Preconditions.checkArgument(MathUtils.isPowerOf2(numBuckets));
        this.numBuckets = numBuckets;
        this.numBucketsMask = numBuckets - 1;
        this.numKeys = 0L;
    }

    static long toAddrAndLen(long address, int size) {
        return address << 28 | (long)size;
    }

    static long toAddress(long addrAndLen) {
        return addrAndLen >>> 28;
    }

    static int toLength(long addrAndLen) {
        return (int)(addrAndLen & 0xFFFFFFFL);
    }

    MatchIterator valueIter(long address) {
        this.iterator.set(address);
        return this.iterator;
    }

    public MatchIterator get(long key) {
        return this.get(key, LongHybridHashTable.hashLong(key, this.recursionLevel));
    }

    public MatchIterator get(long key, int hashCode2) {
        long address;
        int bucket = hashCode2 & this.numBucketsMask;
        int bucketOffset = bucket << 4;
        MemorySegment segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        int segOffset = bucketOffset & this.segmentSizeMask;
        while ((address = segment.getLong(segOffset + 8)) != 0xFFFFFFFFFL) {
            if (segment.getLong(segOffset) == key) {
                return this.valueIter(address);
            }
            bucket = bucket + 1 & this.numBucketsMask;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            bucketOffset = bucket << 4;
            segOffset = bucketOffset & this.segmentSizeMask;
            segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        }
        return this.valueIter(0xFFFFFFFFFL);
    }

    private void updateIndex(long key, int hashCode2, long address, int size, MemorySegment dataSegment, int currentPositionInSegment) throws IOException {
        long currAddress;
        assert (this.numKeys <= (long)(this.numBuckets / 2));
        int bucket = hashCode2 & this.numBucketsMask;
        int bucketOffset = bucket << 4;
        MemorySegment segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
        int segOffset = bucketOffset & this.segmentSizeMask;
        while (true) {
            currAddress = segment.getLong(segOffset + 8);
            if (segment.getLong(segOffset) == key || currAddress == 0xFFFFFFFFFL) break;
            bucket = bucket + 1 & this.numBucketsMask;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            bucketOffset = bucket << 4;
            segment = this.buckets[bucketOffset >>> this.segmentSizeBits];
            segOffset = bucketOffset & this.segmentSizeMask;
        }
        if (currAddress == 0xFFFFFFFFFL) {
            segment.putLong(segOffset, key);
            segment.putLong(segOffset + 8, address);
            ++this.numKeys;
            if (dataSegment != null) {
                dataSegment.putLong(currentPositionInSegment, LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, size));
            }
            if (this.numKeys * 2L > (long)this.numBuckets) {
                this.resize();
            }
        } else {
            dataSegment.putLong(currentPositionInSegment, LongHashPartition.toAddrAndLen(currAddress, size));
            segment.putLong(segOffset + 8, address);
        }
    }

    private void resize() throws IOException {
        MemorySegment[] oldBuckets = this.buckets;
        int oldNumBuckets = this.numBuckets;
        int newNumSegs = oldBuckets.length * 2;
        int newNumBuckets = MathUtils.roundDownToPowerOf2(newNumSegs * this.segmentSize / 16);
        MemorySegment[] newBuckets = new MemorySegment[newNumSegs];
        for (int i = 0; i < newNumSegs; ++i) {
            MemorySegment seg = this.context.getNextBuffer();
            if (seg == null) {
                int spilledPart = this.context.spillPartition();
                if (spilledPart == this.partitionNum) {
                    this.context.returnAll(Arrays.asList(newBuckets));
                    return;
                }
                seg = this.context.getNextBuffer();
                if (seg == null) {
                    throw new RuntimeException("Bug in HybridHashJoin: No memory became available after spilling a partition.");
                }
            }
            newBuckets[i] = seg;
        }
        this.setNewBuckets(newBuckets, newNumBuckets);
        this.reHash(oldBuckets, oldNumBuckets);
    }

    private void reHash(MemorySegment[] oldBuckets, int oldNumBuckets) throws IOException {
        long reHashStartTime = System.currentTimeMillis();
        int bucketOffset = 0;
        MemorySegment segment = oldBuckets[bucketOffset];
        int segOffset = 0;
        for (int i = 0; i < oldNumBuckets; ++i) {
            long address = segment.getLong(segOffset + 8);
            if (address != 0xFFFFFFFFFL) {
                long key = segment.getLong(segOffset);
                this.updateIndex(key, LongHybridHashTable.hashLong(key, this.recursionLevel), address, 0, null, 0);
            }
            if (i == oldNumBuckets - 1) continue;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            segment = oldBuckets[++bucketOffset];
            segOffset = 0;
        }
        this.context.returnAll(Arrays.asList(oldBuckets));
        LOG.info("The rehash take {} ms for {} segments", (Object)(System.currentTimeMillis() - reHashStartTime), (Object)this.numBuckets);
    }

    public MemorySegment[] getBuckets() {
        return this.buckets;
    }

    int getBuildSideBlockCount() {
        return this.partitionBuffers == null ? this.buildSideWriteBuffer.getBlockCount() : this.partitionBuffers.length;
    }

    int getProbeSideBlockCount() {
        return this.probeSideBuffer == null ? -1 : this.probeSideBuffer.getBlockCount();
    }

    BlockChannelWriter<MemorySegment> getBuildSideChannel() {
        return this.buildSideChannel;
    }

    FileIOChannel.ID getProbeSideChannelID() {
        return this.probeSideBuffer.getChannelID();
    }

    int getPartitionNumber() {
        return this.partitionNum;
    }

    MemorySegment[] getPartitionBuffers() {
        return this.partitionBuffers;
    }

    int getRecursionLevel() {
        return this.recursionLevel;
    }

    int getNumOccupiedMemorySegments() {
        int numPartitionBuffers = this.partitionBuffers != null ? this.partitionBuffers.length : this.buildSideWriteBuffer.getNumOccupiedMemorySegments();
        return numPartitionBuffers + this.buckets.length;
    }

    int spillPartition(IOManager ioAccess, FileIOChannel.ID targetChannel, LinkedBlockingQueue<MemorySegment> bufferReturnQueue) throws IOException {
        if (!this.isInMemory()) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition that has already been spilled.");
        }
        if (this.getNumOccupiedMemorySegments() < 2) {
            throw new RuntimeException("Bug in Hybrid Hash Join: Request to spill a partition with less than two buffers.");
        }
        this.buildSideChannel = FileChannelUtil.createBlockChannelWriter(ioAccess, targetChannel, bufferReturnQueue, this.context.compressionEnable(), this.context.compressionCodecFactory(), this.context.compressionBlockSize(), this.segmentSize);
        return this.buildSideWriteBuffer.spill(this.buildSideChannel);
    }

    int finalizeBuildPhase(IOManager ioAccess, FileIOChannel.Enumerator probeChannelEnumerator) throws IOException {
        this.finalBufferLimit = this.buildSideWriteBuffer.getCurrentPositionInSegment();
        this.partitionBuffers = this.buildSideWriteBuffer.close();
        if (!this.isInMemory()) {
            this.buildSideChannel.close();
            this.probeSideBuffer = FileChannelUtil.createOutputView(ioAccess, probeChannelEnumerator.next(), this.context.compressionEnable(), this.context.compressionCodecFactory(), this.context.compressionBlockSize(), this.segmentSize);
            return 1;
        }
        return 0;
    }

    void finalizeProbePhase(List<LongHashPartition> spilledPartitions) throws IOException {
        if (this.isInMemory()) {
            this.releaseBuckets();
            this.context.returnAll(this.partitionBuffers);
            this.partitionBuffers = null;
        } else if (this.probeSideRecordCounter == 0L) {
            this.probeSideBuffer.close();
            this.buildSideChannel.deleteChannel();
            this.probeSideBuffer.deleteChannel();
        } else {
            this.probeNumBytesInLastSeg = this.probeSideBuffer.close();
            spilledPartitions.add(this);
        }
    }

    final PartitionIterator newPartitionIterator() {
        return new PartitionIterator();
    }

    final int getLastSegmentLimit() {
        return this.finalBufferLimit;
    }

    @Override
    public void setReadPosition(long pointer) {
        int bufferNum = (int)(pointer >>> this.segmentSizeBits);
        int offset = (int)(pointer & (long)this.segmentSizeMask);
        this.currentBufferNum = bufferNum;
        this.seekInput(this.partitionBuffers[bufferNum], offset, bufferNum < this.partitionBuffers.length - 1 ? this.segmentSize : this.finalBufferLimit);
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        ++this.currentBufferNum;
        if (this.currentBufferNum < this.partitionBuffers.length) {
            return this.partitionBuffers[this.currentBufferNum];
        }
        throw new EOFException();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return segment == this.partitionBuffers[this.partitionBuffers.length - 1] ? this.finalBufferLimit : this.segmentSize;
    }

    boolean isInMemory() {
        return this.buildSideChannel == null;
    }

    final void insertIntoProbeBuffer(BinaryRowSerializer probeSer, BinaryRow record) throws IOException {
        probeSer.serialize(record, (DataOutputView)this.probeSideBuffer);
        ++this.probeSideRecordCounter;
    }

    long getBuildSideRecordCount() {
        return this.buildSideRecordCounter;
    }

    long getMinKey() {
        return this.minKey;
    }

    long getMaxKey() {
        return this.maxKey;
    }

    private void updateMinMax(long key) {
        if (key < this.minKey) {
            this.minKey = key;
        }
        if (key > this.maxKey) {
            this.maxKey = key;
        }
    }

    void insertIntoBucket(long key, int hashCode2, int size, long address) throws IOException {
        ++this.buildSideRecordCounter;
        this.updateMinMax(key);
        int bufferNum = (int)(address >>> this.segmentSizeBits);
        int offset = (int)(address & (long)(this.segmentSize - 1));
        this.updateIndex(key, hashCode2, address, size, this.partitionBuffers[bufferNum], offset);
    }

    void insertIntoTable(long key, int hashCode2, BinaryRow row2) throws IOException {
        ++this.buildSideRecordCounter;
        this.updateMinMax(key);
        int sizeInBytes = row2.getSizeInBytes();
        if (sizeInBytes >= 0x10000000) {
            throw new UnsupportedOperationException("Does not support row that is larger than 256M");
        }
        if (this.isInMemory()) {
            this.checkWriteAdvance();
            if (this.isInMemory()) {
                this.updateIndex(key, hashCode2, this.buildSideWriteBuffer.getCurrentPointer(), sizeInBytes, this.buildSideWriteBuffer.getCurrentSegment(), this.buildSideWriteBuffer.getCurrentPositionInSegment());
            } else {
                this.buildSideWriteBuffer.getCurrentSegment().putLong(this.buildSideWriteBuffer.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, sizeInBytes));
            }
            this.buildSideWriteBuffer.skipBytesToWrite(8);
            if (row2.getAllSegments().length == 1) {
                this.buildSideWriteBuffer.write(row2.getMemorySegment(), row2.getBaseOffset(), sizeInBytes);
            } else {
                this.buildSideSerializer.serializeRowToPagesSlow(row2, this.buildSideWriteBuffer);
            }
        } else {
            this.serializeToPages(row2);
        }
    }

    public void serializeToPages(BinaryRow row2) throws IOException {
        int sizeInBytes = row2.getSizeInBytes();
        this.checkWriteAdvance();
        this.buildSideWriteBuffer.getCurrentSegment().putLong(this.buildSideWriteBuffer.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(0xFFFFFFFFFL, row2.getSizeInBytes()));
        this.buildSideWriteBuffer.skipBytesToWrite(8);
        if (row2.getAllSegments().length == 1) {
            this.buildSideWriteBuffer.write(row2.getMemorySegment(), row2.getBaseOffset(), sizeInBytes);
        } else {
            this.buildSideSerializer.serializeRowToPagesSlow(row2, this.buildSideWriteBuffer);
        }
    }

    void releaseBuckets() {
        if (this.buckets != null) {
            this.context.returnAll(this.buckets);
            this.buckets = null;
        }
    }

    public void append(long key, BinaryRow row2) throws IOException {
        this.insertIntoTable(key, LongHybridHashTable.hashLong(key, this.recursionLevel), row2);
    }

    void clearAllMemory(List<MemorySegment> target) {
        if (this.buildSideWriteBuffer != null) {
            if (this.buildSideWriteBuffer.getCurrentSegment() != null) {
                target.add(this.buildSideWriteBuffer.getCurrentSegment());
            }
            target.addAll(this.buildSideWriteBuffer.targetList);
            this.buildSideWriteBuffer.targetList.clear();
            this.buildSideWriteBuffer = null;
        }
        this.releaseBuckets();
        if (this.partitionBuffers != null) {
            Collections.addAll(target, this.partitionBuffers);
            this.partitionBuffers = null;
        }
        try {
            if (this.buildSideChannel != null) {
                this.buildSideChannel.close();
                this.buildSideChannel.deleteChannel();
            }
            if (this.probeSideBuffer != null) {
                this.probeSideBuffer.closeAndDelete();
                this.probeSideBuffer = null;
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error deleting the partition files. Some temporary files might not be removed.", ioex);
        }
    }

    private void checkWriteAdvance() throws IOException {
        if (LongHashPartition.shouldAdvance(this.buildSideWriteBuffer.getSegmentSize() - this.buildSideWriteBuffer.getCurrentPositionInSegment(), this.buildSideSerializer)) {
            this.buildSideWriteBuffer.advance();
        }
    }

    private void checkReadAdvance() throws IOException {
        if (LongHashPartition.shouldAdvance(this.getCurrentSegmentLimit() - this.getCurrentPositionInSegment(), this.buildSideSerializer)) {
            this.advance();
        }
    }

    private static boolean shouldAdvance(int available, BinaryRowSerializer serializer) {
        return available < 8 + serializer.getFixedLengthPartSize();
    }

    static void deserializeFromPages(BinaryRow reuse, ChannelReaderInputView inView, BinaryRowSerializer buildSideSerializer) throws IOException {
        if (LongHashPartition.shouldAdvance(inView.getCurrentSegmentLimit() - inView.getCurrentPositionInSegment(), buildSideSerializer)) {
            inView.advance();
        }
        MemorySegment segment = reuse.getMemorySegment();
        int length = LongHashPartition.toLength(inView.getCurrentSegment().getLong(inView.getCurrentPositionInSegment()));
        inView.skipBytesToRead(8);
        if (segment == null || segment.size() < length) {
            segment = MemorySegmentFactory.wrap(new byte[length]);
        }
        inView.readFully(segment.getHeapMemory(), 0, length);
        reuse.pointTo(segment, 0, length);
    }

    void iteratorToDenseBucket(MemorySegment[] denseBuckets, long addressOffset, long globalMinKey) {
        int bucketOffset = 0;
        MemorySegment segment = this.buckets[bucketOffset];
        int segOffset = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            long address = segment.getLong(segOffset + 8);
            if (address != 0xFFFFFFFFFL) {
                long key = segment.getLong(segOffset);
                long denseBucket = key - globalMinKey;
                long denseBucketOffset = denseBucket << 3;
                int denseSegIndex = (int)(denseBucketOffset >>> this.segmentSizeBits);
                int denseSegOffset = (int)(denseBucketOffset & (long)this.segmentSizeMask);
                denseBuckets[denseSegIndex].putLong(denseSegOffset, address + addressOffset);
            }
            if (i == this.numBuckets - 1) continue;
            if (segOffset + 16 < this.segmentSize) {
                segOffset += 16;
                continue;
            }
            segment = this.buckets[++bucketOffset];
            segOffset = 0;
        }
    }

    void updateDenseAddressOffset(long addressOffset) {
        if (addressOffset != 0L) {
            this.setReadPosition(0L);
            try {
                while (true) {
                    this.checkReadAdvance();
                    long addrAndLen = this.getCurrentSegment().getLong(this.getCurrentPositionInSegment());
                    long address = LongHashPartition.toAddress(addrAndLen);
                    int len = LongHashPartition.toLength(addrAndLen);
                    if (address != 0xFFFFFFFFFL) {
                        this.getCurrentSegment().putLong(this.getCurrentPositionInSegment(), LongHashPartition.toAddrAndLen(address + addressOffset, len));
                    }
                    this.skipBytesToRead(8 + len);
                }
            }
            catch (EOFException e2) {
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    final class PartitionIterator
    implements RowIterator<BinaryRow> {
        private long currentPointer;
        private BinaryRow reuse;

        private PartitionIterator() {
            this.reuse = LongHashPartition.this.buildSideSerializer.createInstance();
            LongHashPartition.this.setReadPosition(0L);
        }

        @Override
        public boolean advanceNext() {
            try {
                LongHashPartition.this.checkReadAdvance();
                int pos = LongHashPartition.this.getCurrentPositionInSegment();
                this.currentPointer = ((long)LongHashPartition.this.currentBufferNum << LongHashPartition.this.segmentSizeBits) + (long)pos;
                long addrAndLen = LongHashPartition.this.getCurrentSegment().getLong(pos);
                LongHashPartition.this.skipBytesToRead(8);
                LongHashPartition.this.buildSideSerializer.pointTo(LongHashPartition.toLength(addrAndLen), this.reuse, LongHashPartition.this);
                return true;
            }
            catch (EOFException e2) {
                return false;
            }
            catch (IOException e3) {
                throw new RuntimeException(e3);
            }
        }

        final long getPointer() {
            return this.currentPointer;
        }

        @Override
        public BinaryRow getRow() {
            return this.reuse;
        }
    }

    public class MatchIterator
    implements RowIterator<BinaryRow> {
        private long address;

        public void set(long address) {
            this.address = address;
        }

        @Override
        public boolean advanceNext() {
            if (this.address != 0xFFFFFFFFFL) {
                LongHashPartition.this.setReadPosition(this.address);
                long addrAndLen = LongHashPartition.this.getCurrentSegment().getLong(LongHashPartition.this.getCurrentPositionInSegment());
                this.address = LongHashPartition.toAddress(addrAndLen);
                int size = LongHashPartition.toLength(addrAndLen);
                try {
                    LongHashPartition.this.skipBytesToRead(8);
                    LongHashPartition.this.buildSideSerializer.pointTo(size, LongHashPartition.this.buildReuseRow, LongHashPartition.this);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                return true;
            }
            return false;
        }

        @Override
        public BinaryRow getRow() {
            return LongHashPartition.this.buildReuseRow;
        }
    }

    private class BuildSideBuffer
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> targetList;
        private int currentBlockNumber;
        private BlockChannelWriter<MemorySegment> writer;

        private BuildSideBuffer(MemorySegment segment) {
            super(segment, segment.size(), 0);
            this.targetList = new ArrayList();
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
            MemorySegment next;
            if (this.writer == null) {
                this.targetList.add(current);
                next = LongHashPartition.this.context.nextSegment();
            } else {
                this.writer.writeBlock((Object)current);
                try {
                    next = (MemorySegment)this.writer.getReturnQueue().take();
                }
                catch (InterruptedException iex) {
                    throw new IOException("Hash Join Partition was interrupted while grabbing a new write-behind buffer.");
                }
            }
            ++this.currentBlockNumber;
            return next;
        }

        long getCurrentPointer() {
            return ((long)this.currentBlockNumber << LongHashPartition.this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
        }

        int getBlockCount() {
            return this.currentBlockNumber + 1;
        }

        int getNumOccupiedMemorySegments() {
            return this.targetList.size() + 1;
        }

        int spill(BlockChannelWriter<MemorySegment> writer) throws IOException {
            this.writer = writer;
            int numSegments = this.targetList.size();
            for (MemorySegment segment : this.targetList) {
                this.writer.writeBlock((Object)segment);
            }
            this.targetList.clear();
            return numSegments;
        }

        MemorySegment[] close() throws IOException {
            MemorySegment current = this.getCurrentSegment();
            if (current == null) {
                throw new IllegalStateException("Illegal State in LongHashTable: No current buffer when finalizing build side.");
            }
            this.clear();
            if (this.writer == null) {
                this.targetList.add(current);
                MemorySegment[] buffers = this.targetList.toArray(new MemorySegment[this.targetList.size()]);
                this.targetList.clear();
                return buffers;
            }
            this.writer.writeBlock((Object)current);
            return null;
        }
    }
}

