/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.JoinStateHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CountKeySizeStateHandler
implements JoinStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CountKeySizeStateHandler.class);
    private final KeyedValueState<BaseRow, Long> keyedValueState;
    private final KeySelector<BaseRow, BaseRow> keySelector;
    private transient BaseRow joinKey;
    private Map<BaseRow, Long> memState;

    public CountKeySizeStateHandler(KeyedValueState<BaseRow, Long> keyedValueState, KeySelector<BaseRow, BaseRow> keySelector) {
        this.keySelector = keySelector;
        this.keyedValueState = keyedValueState;
        this.memState = new HashMap<BaseRow, Long>();
    }

    @Override
    public void extractCurrentJoinKey(BaseRow row2) throws Exception {
        this.joinKey = this.keySelector.getKey(row2);
    }

    @Override
    public BaseRow getCurrentJoinKey() {
        return this.joinKey;
    }

    @Override
    public void extractCurrentPrimaryKey(BaseRow row2) {
    }

    @Override
    public BaseRow getCurrentPrimaryKey() {
        return null;
    }

    @Override
    public long add(BaseRow row2, long expireTime) {
        Long oldValue = (Long)this.keyedValueState.get((Object)this.joinKey);
        if (oldValue == null) {
            oldValue = 0L;
        }
        this.keyedValueState.put((Object)this.joinKey, (Object)(oldValue + 1L));
        return 1L;
    }

    @Override
    public long retract(BaseRow row2) {
        Long oldValue = (Long)this.keyedValueState.get((Object)this.joinKey);
        if (oldValue == null) {
            oldValue = 0L;
        }
        if (oldValue <= 1L) {
            this.keyedValueState.remove((Object)this.joinKey);
        } else {
            this.keyedValueState.put((Object)this.joinKey, (Object)(oldValue - 1L));
        }
        return 0L;
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecords(BaseRow key) {
        return new Tuple3Iterator(this.keyedValueState, key);
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecordsFromCache(BaseRow key) {
        return new Tuple3MemIterator(this.memState, key);
    }

    @Override
    public boolean contains(BaseRow key, BaseRow row2) {
        return this.keyedValueState.contains((Object)key);
    }

    @Override
    public void update(BaseRow key, BaseRow row2, long count, long expireTime) {
        Long newValue;
        Long oldValue = (Long)this.keyedValueState.get((Object)key);
        if (oldValue == null) {
            oldValue = 0L;
        }
        if ((newValue = Long.valueOf(oldValue + count)) <= 0L) {
            this.keyedValueState.remove((Object)key);
        } else {
            this.keyedValueState.put((Object)key, (Object)newValue);
        }
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedValueState.remove((Object)joinKey);
    }

    @Override
    public void batchGet(Collection<? extends BaseRow> keys) {
        this.memState = this.keyedValueState.getAll(keys);
    }

    @Override
    public long[] batchUpdate(BaseRow key, List<Tuple2<BaseRow, Long>> rows, long expireTime) {
        long[] updateStatus = new long[rows.size()];
        int idx = 0;
        Long cnt = (Long)this.keyedValueState.get((Object)key);
        if (cnt == null) {
            LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            cnt = 0L;
        }
        for (Tuple2<BaseRow, Long> tuple2 : rows) {
            cnt = cnt + (Long)tuple2.f1;
            ++idx;
        }
        this.keyedValueState.put((Object)key, (Object)cnt);
        return updateStatus;
    }

    @Override
    public void putAll(Map<BaseRow, BaseRow> putMap) {
        throw new RuntimeException("CountKeySizeState don't support putAll!");
    }

    @Override
    public void removeAll(Set<BaseRow> keys) {
        this.keyedValueState.removeAll(keys);
    }

    @Override
    public void setCurrentJoinKey(BaseRow row2) {
        this.joinKey = row2;
    }

    private class Tuple3MemIterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final Map<BaseRow, Long> keyedValueState;
        private final Tuple3<BaseRow, Long, Long> reuse;
        private final BaseRow key;
        private Long curentValue;
        private int count;

        Tuple3MemIterator(Map<BaseRow, Long> keyedValueState, BaseRow key) {
            Preconditions.checkNotNull(keyedValueState);
            this.keyedValueState = keyedValueState;
            this.key = key;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.count == 0 && this.keyedValueState.get(this.key) != null;
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            if (this.count == 0) {
                this.curentValue = this.keyedValueState.get(this.key);
                if (this.curentValue != null) {
                    this.reuse.f0 = this.key;
                    this.reuse.f1 = this.curentValue;
                    this.reuse.f2 = Long.MAX_VALUE;
                    ++this.count;
                    return this.reuse;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.keyedValueState.remove(this.key);
        }
    }

    private class Tuple3Iterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final KeyedValueState<BaseRow, Long> keyedValueState;
        private final Tuple3<BaseRow, Long, Long> reuse;
        private final BaseRow key;
        private Long curentValue;
        private int count;

        Tuple3Iterator(KeyedValueState<BaseRow, Long> keyedValueState, BaseRow key) {
            Preconditions.checkNotNull(keyedValueState);
            this.keyedValueState = keyedValueState;
            this.key = key;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.count == 0 && this.keyedValueState.get((Object)this.key) != null;
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            if (this.count == 0) {
                this.curentValue = (Long)this.keyedValueState.get((Object)this.key);
                if (this.curentValue != null) {
                    this.reuse.f0 = this.key;
                    this.reuse.f1 = this.curentValue;
                    this.reuse.f2 = Long.MAX_VALUE;
                    ++this.count;
                    return this.reuse;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.keyedValueState.remove((Object)this.key);
        }
    }
}

