/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join.stream.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.join.stream.state.JoinStateHandler;
import org.apache.flink.util.Preconditions;

@Internal
public class JoinKeyContainPrimaryKeyStateHandler
implements JoinStateHandler {
    private final KeyedValueState<BaseRow, BaseRow> keyedValueState;
    private final KeySelector<BaseRow, BaseRow> keySelector;
    private transient BaseRow joinKey;
    private Map<BaseRow, BaseRow> memState;

    public JoinKeyContainPrimaryKeyStateHandler(KeyedValueState<BaseRow, BaseRow> keyedValueState, KeySelector<BaseRow, BaseRow> keySelector) {
        this.keySelector = keySelector;
        this.keyedValueState = keyedValueState;
        this.memState = new HashMap<BaseRow, BaseRow>();
    }

    @Override
    public void extractCurrentJoinKey(BaseRow row2) throws Exception {
        this.joinKey = this.keySelector.getKey(row2);
    }

    @Override
    public BaseRow getCurrentJoinKey() {
        return this.joinKey;
    }

    @Override
    public void extractCurrentPrimaryKey(BaseRow row2) {
    }

    @Override
    public BaseRow getCurrentPrimaryKey() {
        return null;
    }

    @Override
    public long add(BaseRow row2, long expireTime) {
        this.keyedValueState.put((Object)this.joinKey, (Object)row2);
        return 1L;
    }

    @Override
    public long retract(BaseRow row2) {
        this.keyedValueState.remove((Object)this.joinKey);
        return 0L;
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecords(BaseRow key) {
        return new Tuple3Iterator(this.keyedValueState, key);
    }

    @Override
    public Iterator<Tuple3<BaseRow, Long, Long>> getRecordsFromCache(BaseRow key) {
        return new Tuple3MemIterator(this.memState, key);
    }

    @Override
    public boolean contains(BaseRow key, BaseRow row2) {
        return this.keyedValueState.contains((Object)key);
    }

    @Override
    public void update(BaseRow key, BaseRow row2, long count, long expireTime) {
        this.keyedValueState.put((Object)key, (Object)row2);
    }

    @Override
    public void remove(BaseRow joinKey) {
        this.keyedValueState.remove((Object)joinKey);
    }

    @Override
    public void batchGet(Collection<? extends BaseRow> keys) {
        this.memState = this.keyedValueState.getAll(keys);
    }

    @Override
    public long[] batchUpdate(BaseRow key, List<Tuple2<BaseRow, Long>> rows, long expireTime) {
        long[] updateStatus = new long[rows.size()];
        int idx = 0;
        Tuple2<BaseRow, Long> lastTuple = null;
        Iterator<Tuple2<BaseRow, Long>> iterator = rows.iterator();
        while (iterator.hasNext()) {
            Tuple2<BaseRow, Long> tuple2;
            lastTuple = tuple2 = iterator.next();
            ++idx;
        }
        if (lastTuple != null) {
            if ((Long)lastTuple.f1 < 0L) {
                updateStatus[rows.size() - 1] = -1L;
            } else if ((Long)lastTuple.f1 > 0L) {
                updateStatus[rows.size() - 1] = 1L;
            }
        }
        return updateStatus;
    }

    @Override
    public void putAll(Map<BaseRow, BaseRow> putMap) {
        this.keyedValueState.putAll(putMap);
    }

    @Override
    public void removeAll(Set<BaseRow> keys) {
        this.keyedValueState.removeAll(keys);
    }

    @Override
    public void setCurrentJoinKey(BaseRow row2) {
        this.joinKey = row2;
    }

    private class Tuple3MemIterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final Map<BaseRow, BaseRow> keyedValueState;
        private final Tuple3<BaseRow, Long, Long> reuse;
        private final BaseRow key;
        private BaseRow curentValue;
        private int count;

        Tuple3MemIterator(Map<BaseRow, BaseRow> keyedValueState, BaseRow key) {
            Preconditions.checkNotNull(keyedValueState);
            this.keyedValueState = keyedValueState;
            this.key = key;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.count == 0 && this.keyedValueState.get(this.key) != null;
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            if (this.count == 0) {
                this.curentValue = this.keyedValueState.get(this.key);
                if (this.curentValue != null) {
                    this.reuse.f0 = this.curentValue;
                    this.reuse.f1 = 1L;
                    this.reuse.f2 = Long.MAX_VALUE;
                    ++this.count;
                    return this.reuse;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.keyedValueState.remove(this.key);
        }
    }

    private class Tuple3Iterator
    implements Iterator<Tuple3<BaseRow, Long, Long>> {
        private final KeyedValueState<BaseRow, BaseRow> keyedValueState;
        private final Tuple3<BaseRow, Long, Long> reuse;
        private final BaseRow key;
        private BaseRow curentValue;
        private int count;

        Tuple3Iterator(KeyedValueState<BaseRow, BaseRow> keyedValueState, BaseRow key) {
            Preconditions.checkNotNull(keyedValueState);
            this.keyedValueState = keyedValueState;
            this.key = key;
            this.reuse = new Tuple3();
        }

        @Override
        public boolean hasNext() {
            return this.count == 0 && this.keyedValueState.get((Object)this.key) != null;
        }

        @Override
        public Tuple3<BaseRow, Long, Long> next() {
            if (this.count == 0) {
                this.curentValue = (BaseRow)this.keyedValueState.get((Object)this.key);
                if (this.curentValue != null) {
                    this.reuse.f0 = this.curentValue;
                    this.reuse.f1 = 1L;
                    this.reuse.f2 = Long.MAX_VALUE;
                    ++this.count;
                    return this.reuse;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.keyedValueState.remove((Object)this.key);
        }
    }
}

