/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import org.apache.flink.api.common.distributions.RangeBoundaries;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.TwoInputSelection;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.AbstractStreamOperatorWithMetrics;
import org.apache.flink.table.runtime.range.CommonRangeBoundaries;
import org.apache.flink.table.runtime.range.KeyExtractor;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;

public class AssignRangeIndexOperator
extends AbstractStreamOperatorWithMetrics<Tuple2<Integer, BaseRow>>
implements TwoInputStreamOperator<Object[][], BaseRow, Tuple2<Integer, BaseRow>> {
    private final KeyExtractor keyExtractor;
    private transient RangeBoundaries rangeBoundaries;
    private transient Collector<Tuple2<Integer, BaseRow>> collector;

    public AssignRangeIndexOperator(KeyExtractor keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new StreamRecordCollector<Tuple2<Integer, BaseRow>>(this.output);
    }

    public TwoInputSelection firstInputSelection() {
        return TwoInputSelection.FIRST;
    }

    public TwoInputSelection processElement1(StreamRecord<Object[][]> streamRecord) throws Exception {
        this.rangeBoundaries = new CommonRangeBoundaries(this.keyExtractor, (Object[][])streamRecord.getValue());
        return TwoInputSelection.ANY;
    }

    public TwoInputSelection processElement2(StreamRecord<BaseRow> streamRecord) throws Exception {
        if (this.rangeBoundaries == null) {
            throw new RuntimeException("There should be one data from the first input.");
        }
        Tuple2 tupleWithPartitionId = new Tuple2();
        tupleWithPartitionId.f0 = this.rangeBoundaries.getRangeIndex(streamRecord.getValue());
        tupleWithPartitionId.f1 = streamRecord.getValue();
        this.collector.collect(tupleWithPartitionId);
        return TwoInputSelection.ANY;
    }

    public void endInput1() throws Exception {
    }

    public void endInput2() throws Exception {
    }
}

