/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.distributions.RangeBoundaries;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.range.KeyExtractor;

@Internal
public class CommonRangeBoundaries
implements RangeBoundaries<BaseRow> {
    private final KeyExtractor keyExtractor;
    private final Object[][] boundaries;
    private final TypeComparator[] flatComparators;
    private final Object[] keys;

    public CommonRangeBoundaries(KeyExtractor keyExtractor, Object[][] boundaries) {
        this.keyExtractor = keyExtractor;
        this.flatComparators = keyExtractor.getFlatComparators();
        this.keys = new Object[this.flatComparators.length];
        this.boundaries = boundaries;
    }

    @Override
    public int getRangeIndex(BaseRow record) {
        return this.binarySearch(record);
    }

    private int binarySearch(BaseRow record) {
        int low = 0;
        int high = this.boundaries.length - 1;
        this.keyExtractor.extractKeys(record, this.keys, 0);
        while (low <= high) {
            int mid = low + high >>> 1;
            int result = this.compareKeys(this.flatComparators, this.keys, this.boundaries[mid]);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private int compareKeys(TypeComparator[] flatComparators, Object[] keys, Object[] boundary) {
        if (flatComparators.length != keys.length || flatComparators.length != boundary.length) {
            throw new RuntimeException("Can not compare keys with boundary due to mismatched length.");
        }
        for (int i = 0; i < flatComparators.length; ++i) {
            int result = flatComparators[i].compare(keys[i], boundary[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

