/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.codegen.CodeGenUtils;
import org.apache.flink.table.codegen.GeneratedProjection;
import org.apache.flink.table.codegen.GeneratedSorter;
import org.apache.flink.table.codegen.Projection;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.AbstractStreamOperatorWithMetrics;
import org.apache.flink.table.runtime.range.KeyExtractor;
import org.apache.flink.table.runtime.range.ReservoirSamplerWithoutReplacement;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;

@Internal
public class SampleAndHistogramOperator
extends AbstractStreamOperatorWithMetrics<Object[][]>
implements OneInputStreamOperator<IntermediateSampleData<BaseRow>, Object[][]> {
    private final ReservoirSamplerWithoutReplacement sampler;
    private GeneratedSorter genSorter;
    private GeneratedProjection projection;
    private final int rangesNum;
    private final KeyExtractor keyExtractor;
    private transient Collector<Object[][]> collector;
    private transient RecordComparator comparator;

    public SampleAndHistogramOperator(int numSample, GeneratedProjection projection, GeneratedSorter genSorter, KeyExtractor keyExtractor, int rangesNum) {
        this.sampler = new ReservoirSamplerWithoutReplacement(numSample, 0L);
        this.genSorter = genSorter;
        this.rangesNum = rangesNum;
        this.projection = projection;
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void open() throws Exception {
        super.open();
        Class buildProjectionClass = CodeGenUtils.compile(this.getUserCodeClassloader(), this.projection.name(), this.projection.code());
        Class comparatorClass = CodeGenUtils.compile(this.getUserCodeClassloader(), this.genSorter.comparator().name(), this.genSorter.comparator().code());
        this.sampler.setProjection((Projection)buildProjectionClass.newInstance());
        this.collector = new StreamRecordCollector<Object[][]>(this.output);
        this.comparator = (RecordComparator)comparatorClass.newInstance();
        this.comparator.init(this.genSorter.serializers(), this.genSorter.comparators());
        this.genSorter = null;
        this.projection = null;
    }

    public void processElement(StreamRecord<IntermediateSampleData<BaseRow>> streamRecord) throws Exception {
        this.sampler.collectSampleData((IntermediateSampleData<BaseRow>)((IntermediateSampleData)streamRecord.getValue()));
    }

    public void endInput() throws Exception {
        Iterator<IntermediateSampleData<BaseRow>> sampled = this.sampler.sample();
        ArrayList<Object> sampledData = new ArrayList<Object>();
        while (sampled.hasNext()) {
            sampledData.add(sampled.next().getElement());
        }
        Collections.sort(sampledData, new Comparator<BaseRow>(){

            @Override
            public int compare(BaseRow first, BaseRow second) {
                return SampleAndHistogramOperator.this.comparator.compare(first, second);
            }
        });
        int boundarySize = this.rangesNum - 1;
        Object[][] boundaries = new Object[boundarySize][];
        if (sampledData.size() > 0) {
            double avgRange = (double)sampledData.size() / (double)this.rangesNum;
            int numKey = this.keyExtractor.getFlatComparators().length;
            for (int i = 1; i < this.rangesNum; ++i) {
                BaseRow record = (BaseRow)sampledData.get((int)((double)i * avgRange));
                Object[] keys = new Object[numKey];
                this.keyExtractor.extractKeys(record, keys, 0);
                boundaries[i - 1] = keys;
            }
        }
        this.collector.collect(boundaries);
    }
}

