/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.rank;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.codegen.GeneratedRecordEqualiser;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.plan.util.ConstantRankRange;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.plan.util.VariableRankRange;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.rank.SortedMap;
import org.apache.flink.table.runtime.sort.RecordEqualiser;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.Collector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f!B\u0001\u0003\u0003\u0003y!\u0001F!cgR\u0014\u0018m\u0019;SC:\\g)\u001e8di&|gN\u0003\u0002\u0004\t\u0005!!/\u00198l\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0005#Q1b#D\u0001\u0013\u0015\t\u0019B!A\u0005bO\u001e\u0014XmZ1uK&\u0011QC\u0005\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003)!\u0017\r^1g_Jl\u0017\r^\u0005\u00037a\u0011qAQ1tKJ{w\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u00052\u0011aA1qS&\u00111\u0005\t\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003%\u0011\u0018M\\6SC:<W\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!Q\u000f^5m\u0015\tYc!\u0001\u0003qY\u0006t\u0017BA\u0017)\u0005%\u0011\u0016M\\6SC:<W\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00031Ig\u000e];u%><H+\u001f9f!\t\tD'D\u00013\u0015\t\u0019d!A\u0005usB,W\u000f^5mg&\u0011QG\r\u0002\u0010\u0005\u0006\u001cXMU8x)f\u0004X-\u00138g_\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\u0006j]B,H/\u0011:jif\u0004\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u00121!\u00138u\u0011!y\u0004A!A!\u0002\u0013A\u0014aC8viB,H/\u0011:jifD\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u0013O\u0016tWM]1uKJ+GO]1di&|g\u000e\u0005\u0002:\u0007&\u0011AI\u000f\u0002\b\u0005>|G.Z1o\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0019a\u0014N\\5u}Q9\u0001JS&M\u001b:{\u0005CA%\u0001\u001b\u0005\u0011\u0001\"B\u000fF\u0001\u0004q\u0002\"B\u0013F\u0001\u00041\u0003\"B\u0018F\u0001\u0004\u0001\u0004\"B\u001cF\u0001\u0004A\u0004\"B F\u0001\u0004A\u0004\"B!F\u0001\u0004\u0011\u0005\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0005S\u0003EI7oQ8ogR\fg\u000e\u001e*b].,e\u000eZ\u000b\u0002\u0005\"IA\u000b\u0001a\u0001\u0002\u0004%\t\"V\u0001\u0016SN\u001cuN\\:uC:$(+\u00198l\u000b:$w\fJ3r)\t1\u0016\f\u0005\u0002:/&\u0011\u0001L\u000f\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013\u0007\u0003\u0004]\u0001\u0001\u0006KAQ\u0001\u0013SN\u001cuN\\:uC:$(+\u00198l\u000b:$\u0007\u0005C\u0004_\u0001\u0001\u0007I\u0011C0\u0002\u000fI\fgn[#oIV\t\u0001\r\u0005\u0002:C&\u0011!M\u000f\u0002\u0005\u0019>tw\rC\u0004e\u0001\u0001\u0007I\u0011C3\u0002\u0017I\fgn[#oI~#S-\u001d\u000b\u0003-\u001aDqAW2\u0002\u0002\u0003\u0007\u0001\r\u0003\u0004i\u0001\u0001\u0006K\u0001Y\u0001\te\u0006t7.\u00128eA!9!\u000e\u0001a\u0001\n#y\u0016!\u0003:b].\u001cF/\u0019:u\u0011\u001da\u0007\u00011A\u0005\u00125\fQB]1oWN#\u0018M\u001d;`I\u0015\fHC\u0001,o\u0011\u001dQ6.!AA\u0002\u0001Da\u0001\u001d\u0001!B\u0013\u0001\u0017A\u0003:b].\u001cF/\u0019:uA!I!\u000f\u0001a\u0001\u0002\u0004%Ia]\u0001\re\u0006t7.\u00128e\u0013:$W\r_\u000b\u0002q!IQ\u000f\u0001a\u0001\u0002\u0004%IA^\u0001\u0011e\u0006t7.\u00128e\u0013:$W\r_0%KF$\"AV<\t\u000fi#\u0018\u0011!a\u0001q!1\u0011\u0010\u0001Q!\na\nQB]1oW\u0016sG-\u00138eKb\u0004\u0003\"C>\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u00031\u0011\u0018M\\6F]\u0012\u001cF/\u0019;f+\u0005i\bC\u0002@\u0002\nY\ti!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u000b-,\u00170\u001a3\u000b\t\u0005\u0015\u0011qA\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!I1!a\u0003\u0000\u0005=YU-_3e-\u0006dW/Z*uCR,\u0007\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0018\u0005!!.\u0019<b\u0013\r\u0011\u0017\u0011\u0003\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\"\u0001\tsC:\\WI\u001c3Ti\u0006$Xm\u0018\u0013fcR\u0019a+!\t\t\u0011i\u000bY\"!AA\u0002uDq!!\n\u0001A\u0003&Q0A\u0007sC:\\WI\u001c3Ti\u0006$X\r\t\u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0013\tY#\u0001\bj]Z\fG.\u001b3D_VtG/\u001a:\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0002\"A\u0004nKR\u0014\u0018nY:\n\t\u0005]\u0012\u0011\u0007\u0002\b\u0007>,h\u000e^3s\u0011-\tY\u0004\u0001a\u0001\u0002\u0004%I!!\u0010\u0002%%tg/\u00197jI\u000e{WO\u001c;fe~#S-\u001d\u000b\u0004-\u0006}\u0002\"\u0003.\u0002:\u0005\u0005\t\u0019AA\u0017\u0011!\t\u0019\u0005\u0001Q!\n\u00055\u0012aD5om\u0006d\u0017\u000eZ\"pk:$XM\u001d\u0011\t\u0017\u0005\u001d\u0003\u00011AA\u0002\u0013%\u0011\u0011J\u0001\n_V$\b/\u001e;S_^,\"!a\u0013\u0011\u0007]\ti%C\u0002\u0002Pa\u0011\u0011BS8j]\u0016$'k\\<\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011QK\u0001\u000e_V$\b/\u001e;S_^|F%Z9\u0015\u0007Y\u000b9\u0006C\u0005[\u0003#\n\t\u00111\u0001\u0002L!A\u00111\f\u0001!B\u0013\tY%\u0001\u0006pkR\u0004X\u000f\u001e*po\u0002B\u0001\"a\u0018\u0001\u0005\u0004%\tBU\u0001\u0012SN\u0014vn\u001e(v[\n,'/\u00119qK:$\u0007bBA2\u0001\u0001\u0006IAQ\u0001\u0013SN\u0014vn\u001e(v[\n,'/\u00119qK:$\u0007\u0005C\u0006\u0002h\u0001\u0001\r\u00111A\u0005\u0012\u0005%\u0014!C3rk\u0006d\u0017n]3s+\t\tY\u0007\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bB\u0001\u0005g>\u0014H/\u0003\u0003\u0002v\u0005=$a\u0004*fG>\u0014H-R9vC2L7/\u001a:\t\u0017\u0005e\u0004\u00011AA\u0002\u0013E\u00111P\u0001\u000eKF,\u0018\r\\5tKJ|F%Z9\u0015\u0007Y\u000bi\bC\u0005[\u0003o\n\t\u00111\u0001\u0002l!A\u0011\u0011\u0011\u0001!B\u0013\tY'\u0001\u0006fcV\fG.[:fe\u0002B\u0001\"!\"\u0001\u0001\u0004%\tbX\u0001\tQ&$8i\\;oi\"I\u0011\u0011\u0012\u0001A\u0002\u0013E\u00111R\u0001\rQ&$8i\\;oi~#S-\u001d\u000b\u0004-\u00065\u0005\u0002\u0003.\u0002\b\u0006\u0005\t\u0019\u00011\t\u000f\u0005E\u0005\u0001)Q\u0005A\u0006I\u0001.\u001b;D_VtG\u000f\t\u0005\t\u0003+\u0003\u0001\u0019!C\t?\u0006a!/Z9vKN$8i\\;oi\"I\u0011\u0011\u0014\u0001A\u0002\u0013E\u00111T\u0001\u0011e\u0016\fX/Z:u\u0007>,h\u000e^0%KF$2AVAO\u0011!Q\u0016qSA\u0001\u0002\u0004\u0001\u0007bBAQ\u0001\u0001\u0006K\u0001Y\u0001\u000ee\u0016\fX/Z:u\u0007>,h\u000e\u001e\u0011\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006!q\u000e]3o)\r1\u0016\u0011\u0016\u0005\t\u0003W\u000b\u0019\u000b1\u0001\u0002.\u0006\u00191\r\u001e=\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cS1!a-\u0005\u0003%1WO\\2uS>t7/\u0003\u0003\u00028\u0006E&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019\tY\f\u0001C\t?\u0006\tr-\u001a;EK\u001a\fW\u000f\u001c;U_B\u001c\u0016N_3\t\u000f\u0005}\u0006\u0001\"\u0005\u0002B\u0006Y\u0011N\\5u%\u0006t7.\u00128e)\r\u0001\u00171\u0019\u0005\b\u0003\u000b\fi\f1\u0001\u0017\u0003\r\u0011xn\u001e\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003%\u0011xn\u001e(v[\n,'/\u0006\u0003\u0002N\u0006uG\u0003CAh\u0003+\fy/a=\u0011\u000be\n\t\u000e\u000f\u001d\n\u0007\u0005M'H\u0001\u0004UkBdWM\r\u0005\t\u0003/\f9\r1\u0001\u0002Z\u000691o\u001c:u\u0017\u0016L\b\u0003BAn\u0003;d\u0001\u0001\u0002\u0005\u0002`\u0006\u001d'\u0019AAq\u0005\u0005Y\u0015\u0003BAr\u0003S\u00042!OAs\u0013\r\t9O\u000f\u0002\b\u001d>$\b.\u001b8h!\rI\u00141^\u0005\u0004\u0003[T$aA!os\"9\u0011\u0011_Ad\u0001\u00041\u0012A\u0002:po.+\u0017\u0010\u0003\u0005\u0002v\u0006\u001d\u0007\u0019AA|\u0003%\u0019xN\u001d;fI6\u000b\u0007\u000fE\u0003J\u0003s\fI.C\u0002\u0002|\n\u0011\u0011bU8si\u0016$W*\u00199\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002\u0005I2\r[3dWN{'\u000f^&fs&s')\u001e4gKJ\u0014\u0016M\\4f+\u0011\u0011\u0019A!\u0003\u0015\u000f\t\u0013)Aa\u0003\u0003\u0010!A\u0011q[A\u007f\u0001\u0004\u00119\u0001\u0005\u0003\u0002\\\n%A\u0001CAp\u0003{\u0014\r!!9\t\u0011\u0005U\u0018Q a\u0001\u0005\u001b\u0001R!SA}\u0005\u000fA\u0001B!\u0005\u0002~\u0002\u0007!1C\u0001\u0012g>\u0014HoS3z\u0007>l\u0007/\u0019:bi>\u0014\bC\u0002B\u000b\u00053\u00119!\u0004\u0002\u0003\u0018)\u0019\u0011&!\u0006\n\t\tm!q\u0003\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bb\u0002B\u0010\u0001\u0011E!\u0011E\u0001\u000fe\u0016<\u0017n\u001d;fe6+GO]5d)\r1&1\u0005\u0005\b\u0005K\u0011i\u00021\u0001a\u0003!AW-\u00199TSj,\u0007b\u0002B\u0015\u0001\u0011E!1F\u0001\bG>dG.Z2u)\u00151&Q\u0006B\u001e\u0011!\u0011yCa\nA\u0002\tE\u0012aA8viB)!1\u0007B\u001c-5\u0011!Q\u0007\u0006\u0003S!IAA!\u000f\u00036\tI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0005{\u00119\u00031\u0001\u0017\u0003!Ig\u000e];u%><\bb\u0002B!\u0001\u0011E!1I\u0001\u0007I\u0016dW\r^3\u0015\u000bY\u0013)Ea\u0012\t\u0011\t=\"q\ba\u0001\u0005cAqA!\u0010\u0003@\u0001\u0007a\u0003C\u0004\u0003B\u0001!\tBa\u0013\u0015\u000fY\u0013iEa\u0014\u0003R!A!q\u0006B%\u0001\u0004\u0011\t\u0004C\u0004\u0003>\t%\u0003\u0019\u0001\f\t\r\r\u0011I\u00051\u0001a\u0011\u001d\u0011I\u0003\u0001C\t\u0005+\"rA\u0016B,\u00053\u0012Y\u0006\u0003\u0005\u00030\tM\u0003\u0019\u0001B\u0019\u0011\u001d\u0011iDa\u0015A\u0002YAaa\u0001B*\u0001\u0004\u0001\u0007b\u0002B0\u0001\u0011E!\u0011M\u0001\be\u0016$(/Y2u)\u001d1&1\rB3\u0005OB\u0001Ba\f\u0003^\u0001\u0007!\u0011\u0007\u0005\b\u0005{\u0011i\u00061\u0001\u0017\u0011\u0019\u0019!Q\fa\u0001A\"9!1\u000e\u0001\u0005\u0012\t5\u0014aC5t\u0013:\u0014\u0016M\\6F]\u0012$2A\u0011B8\u0011\u0019\u0019!\u0011\u000ea\u0001A\"9!1\u000f\u0001\u0005\u0012\tU\u0014!D5t\u0013:\u0014\u0016M\\6SC:<W\rF\u0002C\u0005oBaa\u0001B9\u0001\u0004\u0001\u0007B\u0002B>\u0001\u0011E!+A\u0005iCN|eMZ:fi\"9!q\u0010\u0001\u0005\u0012\t\u0005\u0015aD2sK\u0006$XmT;uaV$(k\\<\u0015\u000fY\u0011\u0019I!\"\u0003\b\"9!Q\bB?\u0001\u00041\u0002BB\u0002\u0003~\u0001\u0007\u0001\r\u0003\u0005\u0003\n\nu\u0004\u0019\u0001BF\u0003\u0019AW-\u00193feB\u0019\u0011H!$\n\u0007\t=%H\u0001\u0003CsR,\u0007B\u0002BJ\u0001\u0019Eq,A\thKRl\u0015\r_*peRl\u0015\r]*ju\u0016DqAa&\u0001\t\u0013\u0011I*A\bde\u0016\fG/Z#rk\u0006d\u0017n]3s)\u0011\u0011YJa*\u0011\t\tu%1U\u0007\u0003\u0005?S1A!)\u0007\u0003\u001d\u0019w\u000eZ3hK:LAA!*\u0003 \nAr)\u001a8fe\u0006$X\r\u001a*fG>\u0014H-R9vC2L7/\u001a:\t\r=\u0012)\n1\u00011\u0001")
public abstract class AbstractRankFunction
extends ProcessFunctionWithCleanupState<BaseRow, BaseRow> {
    private final RankRange rankRange;
    private final BaseRowTypeInfo inputRowType;
    private final boolean generateRetraction;
    private boolean isConstantRankEnd;
    private long rankEnd;
    private long rankStart;
    private int rankEndIndex;
    private KeyedValueState<BaseRow, Long> rankEndState;
    private Counter invalidCounter;
    private JoinedRow outputRow;
    private final boolean isRowNumberAppend;
    private RecordEqualiser equaliser;
    private long hitCount;
    private long requestCount;

    public boolean isConstantRankEnd() {
        return this.isConstantRankEnd;
    }

    public void isConstantRankEnd_$eq(boolean x$1) {
        this.isConstantRankEnd = x$1;
    }

    public long rankEnd() {
        return this.rankEnd;
    }

    public void rankEnd_$eq(long x$1) {
        this.rankEnd = x$1;
    }

    public long rankStart() {
        return this.rankStart;
    }

    public void rankStart_$eq(long x$1) {
        this.rankStart = x$1;
    }

    private int rankEndIndex() {
        return this.rankEndIndex;
    }

    private void rankEndIndex_$eq(int x$1) {
        this.rankEndIndex = x$1;
    }

    private KeyedValueState<BaseRow, Long> rankEndState() {
        return this.rankEndState;
    }

    private void rankEndState_$eq(KeyedValueState<BaseRow, Long> x$1) {
        this.rankEndState = x$1;
    }

    private Counter invalidCounter() {
        return this.invalidCounter;
    }

    private void invalidCounter_$eq(Counter x$1) {
        this.invalidCounter = x$1;
    }

    private JoinedRow outputRow() {
        return this.outputRow;
    }

    private void outputRow_$eq(JoinedRow x$1) {
        this.outputRow = x$1;
    }

    public boolean isRowNumberAppend() {
        return this.isRowNumberAppend;
    }

    public RecordEqualiser equaliser() {
        return this.equaliser;
    }

    public void equaliser_$eq(RecordEqualiser x$1) {
        this.equaliser = x$1;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public void hitCount_$eq(long x$1) {
        this.hitCount = x$1;
    }

    public long requestCount() {
        return this.requestCount;
    }

    public void requestCount_$eq(long x$1) {
        this.requestCount = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        RankRange rankRange;
        block4: {
            block3: {
                block2: {
                    super.open(ctx);
                    this.initCleanupTimeState("RankFunctionCleanupTime");
                    this.outputRow_$eq(new JoinedRow());
                    rankRange = this.rankRange;
                    if (!(rankRange instanceof ConstantRankRange)) break block2;
                    ConstantRankRange constantRankRange = (ConstantRankRange)rankRange;
                    this.isConstantRankEnd_$eq(true);
                    this.rankEnd_$eq(constantRankRange.rankEnd());
                    this.rankStart_$eq(constantRankRange.rankStart());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(rankRange instanceof VariableRankRange)) break block4;
                VariableRankRange variableRankRange = (VariableRankRange)rankRange;
                this.isConstantRankEnd_$eq(false);
                this.rankEndIndex_$eq(variableRankRange.rankEndIndex());
                ValueStateDescriptor<Long> rankStateDesc = new ValueStateDescriptor<Long>("rankEnd", Types$.MODULE$.LONG());
                this.rankEndState_$eq(ctx.getKeyedValueState(rankStateDesc));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            GeneratedRecordEqualiser generatedEqualiser = this.createEqualiser(this.inputRowType);
            this.equaliser_$eq((RecordEqualiser)generatedEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
            this.invalidCounter_$eq(ctx.getRuntimeContext().getMetricGroup().counter("topn.invalidTopSize"));
            return;
        }
        throw new MatchError((Object)rankRange);
    }

    public long getDefaultTopSize() {
        return this.isConstantRankEnd() ? this.rankEnd() : 100L;
    }

    public long initRankEnd(BaseRow row2) {
        long l;
        if (this.isConstantRankEnd()) {
            l = this.rankEnd();
        } else {
            BaseRow currentKey = this.executionContext.currentKey();
            Long rankEndValue = (Long)this.rankEndState().get((Object)currentKey);
            long curRankEnd = row2.getLong(this.rankEndIndex());
            if (rankEndValue == null) {
                this.rankEnd_$eq(curRankEnd);
                this.rankEndState().put((Object)currentKey, (Object)Predef$.MODULE$.long2Long(this.rankEnd()));
                l = this.rankEnd();
            } else {
                this.rankEnd_$eq(Predef$.MODULE$.Long2long(rankEndValue));
                if (this.rankEnd() != curRankEnd) {
                    this.invalidCounter().inc();
                }
                l = this.rankEnd();
            }
        }
        return l;
    }

    public <K> Tuple2<Object, Object> rowNumber(K sortKey, BaseRow rowKey, SortedMap<K> sortedMap) {
        Iterator<Map.Entry<K, Collection<BaseRow>>> iterator = sortedMap.entrySet().iterator();
        int curRank = 1;
        while (iterator.hasNext()) {
            Map.Entry<K, Collection<BaseRow>> entry = iterator.next();
            K curKey = entry.getKey();
            Collection<BaseRow> rowKeys = entry.getValue();
            if (curKey.equals(sortKey)) {
                Iterator<BaseRow> rowKeysIter = rowKeys.iterator();
                int innerRank = 1;
                while (rowKeysIter.hasNext()) {
                    if (rowKey.equals(rowKeysIter.next())) {
                        return new Tuple2.mcII.sp(curRank, innerRank);
                    }
                    ++innerRank;
                    ++curRank;
                }
                continue;
            }
            curRank += rowKeys.size();
        }
        throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find the sortKey: ", ", rowkey: ", " in SortedMap. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortKey, rowKey}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This should never happen"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public <K> boolean checkSortKeyInBufferRange(K sortKey, SortedMap<K> sortedMap, Comparator<K> sortKeyComparator) {
        K worstKey;
        int compare;
        Map.Entry<K, Collection<BaseRow>> worstEntry = sortedMap.lastEntry();
        return worstEntry == null ? true : ((compare = sortKeyComparator.compare(sortKey, worstKey = worstEntry.getKey())) < 0 ? true : (long)sortedMap.currentTopNum() < this.getMaxSortMapSize());
    }

    public void registerMetric(long heapSize) {
        this.executionContext.getRuntimeContext().getMetricGroup().gauge("topn.cache.hitRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractRankFunction $outer;

            public double getValue() {
                return this.$outer.requestCount() == 0L ? 1.0 : (double)this.$outer.hitCount() / (double)this.$outer.requestCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.executionContext.getRuntimeContext().getMetricGroup().gauge("topn.cache.size", new Gauge<Object>(this, heapSize){
            private final long heapSize$1;

            public long getValue() {
                return this.heapSize$1;
            }
            {
                this.heapSize$1 = heapSize$1;
            }
        });
    }

    public void collect(Collector<BaseRow> out, BaseRow inputRow) {
        BaseRowUtil.setAccumulate(inputRow);
        out.collect(inputRow);
    }

    public void delete(Collector<BaseRow> out, BaseRow inputRow) {
        BaseRowUtil.setRetract(inputRow);
        out.collect(inputRow);
    }

    public void delete(Collector<BaseRow> out, BaseRow inputRow, long rank) {
        if (this.isInRankRange(rank)) {
            out.collect(this.createOutputRow(inputRow, rank, (byte)1));
        }
    }

    public void collect(Collector<BaseRow> out, BaseRow inputRow, long rank) {
        if (this.isInRankRange(rank)) {
            out.collect(this.createOutputRow(inputRow, rank, (byte)0));
        }
    }

    public void retract(Collector<BaseRow> out, BaseRow inputRow, long rank) {
        if (this.generateRetraction && this.isInRankRange(rank)) {
            out.collect(this.createOutputRow(inputRow, rank, (byte)1));
        }
    }

    public boolean isInRankEnd(long rank) {
        return rank <= this.rankEnd();
    }

    public boolean isInRankRange(long rank) {
        return rank <= this.rankEnd() && rank >= this.rankStart();
    }

    public boolean hasOffset() {
        return this.rankStart() > 1L;
    }

    public BaseRow createOutputRow(BaseRow inputRow, long rank, byte header) {
        BaseRow baseRow;
        if (this.isRowNumberAppend()) {
            GenericRow rankRow = new GenericRow(1);
            rankRow.update(0, BoxesRunTime.boxToLong((long)rank));
            this.outputRow().replace(inputRow, rankRow);
            this.outputRow().setHeader(header);
            baseRow = this.outputRow();
        } else {
            inputRow.setHeader(header);
            baseRow = inputRow;
        }
        return baseRow;
    }

    public abstract long getMaxSortMapSize();

    private GeneratedRecordEqualiser createEqualiser(BaseRowTypeInfo inputRowType) {
        InternalType[] inputTypes = (InternalType[])Predef$.MODULE$.refArrayOps((Object[])inputRowType.getFieldTypes()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalType apply(TypeInformation<?> typeInfo) {
                return TypeConverters$.MODULE$.createInternalTypeFromTypeInfo(typeInfo);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InternalType.class)));
        EqualiserCodeGenerator generator = new EqualiserCodeGenerator((Seq<InternalType>)Predef$.MODULE$.wrapRefArray((Object[])inputTypes));
        return generator.generateRecordEqualiser("RankValueEqualiser");
    }

    public AbstractRankFunction(TableConfig tableConfig, RankRange rankRange, BaseRowTypeInfo inputRowType, int inputArity, int outputArity, boolean generateRetraction) {
        this.rankRange = rankRange;
        this.inputRowType = inputRowType;
        this.generateRetraction = generateRetraction;
        super(tableConfig);
        this.rankEnd = -1L;
        this.rankStart = -1L;
        this.isRowNumberAppend = inputArity + 1 == outputArity;
        this.hitCount = 0L;
        this.requestCount = 0L;
    }
}

