/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.rank;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedSorter;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.runtime.aggregate.CollectionBaseRowComparator;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.runtime.rank.AbstractRankFunction;
import org.apache.flink.table.runtime.rank.AppendRankFunction$ArrayListSupplier$;
import org.apache.flink.table.runtime.rank.SortedMap;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.util.LRUMap;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u0001\u0003\u0001=\u0011!#\u00119qK:$'+\u00198l\rVt7\r^5p]*\u00111\u0001B\u0001\u0005e\u0006t7N\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\u0002\u0005\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t!\u0012IY:ue\u0006\u001cGOU1oW\u001a+hn\u0019;j_:\u00042!\u0006\r\u001b\u001b\u00051\"BA\f\u0007\u0003\u001d\u0019w\u000eZ3hK:L!!\u0007\f\u0003\u0011\r{W\u000e]5mKJ\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0003\u0002\tM|'\u000f^\u0005\u0003?q\u0011\u0001CU3d_J$7i\\7qCJ\fGo\u001c:\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011\u0001B;uS2L!!\n\u0012\u0003\u000f1{wmZ5oO\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002*Y5\t!F\u0003\u0002,\r\u0005IA/\u001f9fkRLGn]\u0005\u0003[)\u0012qBQ1tKJ{w\u000fV=qK&sgm\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005Q\u0005Y1o\u001c:u\u0017\u0016LH+\u001f9f\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014aB4T_J$XM\u001d\t\u0003+MJ!\u0001\u000e\f\u0003\u001f\u001d+g.\u001a:bi\u0016$7k\u001c:uKJD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0010g>\u0014HoS3z'\u0016dWm\u0019;peB!\u0001hP!B\u001b\u0005I$B\u0001\u001e<\u0003%1WO\\2uS>t7O\u0003\u0002={\u0005!!.\u0019<b\u0015\tq\u0004\"A\u0002ba&L!\u0001Q\u001d\u0003\u0017-+\u0017pU3mK\u000e$xN\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u001a\t!\u0002Z1uC\u001a|'/\\1u\u0013\t15IA\u0004CCN,'k\\<\t\u0011!\u0003!\u0011!Q\u0001\n%\u000b1b\\;uaV$\u0018I]5usB\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n\u0019\u0011J\u001c;\t\u0011A\u0003!\u0011!Q\u0001\nE\u000b\u0001B]1oW.Kg\u000e\u001a\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000b1a]9m\u0015\t1&\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005a\u001b&aB*rY.Kg\u000e\u001a\u0005\t5\u0002\u0011\t\u0011)A\u00057\u0006I!/\u00198l%\u0006tw-\u001a\t\u00039\u0002l\u0011!\u0018\u0006\u0003GyS!a\u0018\u0004\u0002\tAd\u0017M\\\u0005\u0003Cv\u0013\u0011BU1oWJ\u000bgnZ3\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011\f\u0011bY1dQ\u0016\u001c\u0016N_3\u0011\u0005)+\u0017B\u00014L\u0005\u0011auN\\4\t\u0011!\u0004!\u0011!Q\u0001\n%\f!cZ3oKJ\fG/\u001a*fiJ\f7\r^5p]B\u0011!J[\u0005\u0003W.\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0003-!\u0018M\u00197f\u0007>tg-[4\u0011\u0005=\fX\"\u00019\u000b\u0005y2\u0011B\u0001:q\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000bQ\u0004A\u0011A;\u0002\rqJg.\u001b;?)11x\u000f_={wrlhp`A\u0001!\t\t\u0002\u0001C\u0003(g\u0002\u0007\u0001\u0006C\u00030g\u0002\u0007\u0001\u0006C\u00032g\u0002\u0007!\u0007C\u00037g\u0002\u0007q\u0007C\u0003Ig\u0002\u0007\u0011\nC\u0003Qg\u0002\u0007\u0011\u000bC\u0003[g\u0002\u00071\fC\u0003dg\u0002\u0007A\rC\u0003ig\u0002\u0007\u0011\u000eC\u0003ng\u0002\u0007a\u000eC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b\u0005Y\u0011N\u001c9viJ{woU3s+\t\tI\u0001\u0005\u0003*\u0003\u0017\t\u0015bAA\u0007U\t)\u0012IY:ue\u0006\u001cGOU8x'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002CA\t\u0001\u0001\u0006I!!\u0003\u0002\u0019%t\u0007/\u001e;S_^\u001cVM\u001d\u0011\t\u0017\u0005U\u0001\u00011AA\u0002\u0013%\u0011qC\u0001\nI\u0006$\u0018m\u0015;bi\u0016,\"!!\u0007\u0011\u0011\u0005m\u0011qE!B\u0003Wi!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0006W\u0016LX\r\u001a\u0006\u0005\u0003G\t)#A\u0003ti\u0006$XM\u0003\u0002\u0006\u0011%!\u0011\u0011FA\u000f\u00055YU-_3e\u001b\u0006\u00048\u000b^1uKB)\u0011QFA\u001a\u00036\u0011\u0011q\u0006\u0006\u0004G\u0005E\"\"\u0001\u001f\n\t\u0005U\u0012q\u0006\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0012!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005\r\u0003c\u0001&\u0002@%\u0019\u0011\u0011I&\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u000b\n9$!AA\u0002\u0005e\u0011a\u0001=%c!A\u0011\u0011\n\u0001!B\u0013\tI\"\u0001\u0006eCR\f7\u000b^1uK\u0002BC!a\u0012\u0002NA\u0019!*a\u0014\n\u0007\u0005E3JA\u0005ue\u0006t7/[3oi\"Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011CA,\u0003%\u0019xN\u001d;fI6\u000b\u0007/\u0006\u0002\u0002ZA!\u0011#a\u0017B\u0013\r\tiF\u0001\u0002\n'>\u0014H/\u001a3NCBD1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002d\u0005i1o\u001c:uK\u0012l\u0015\r]0%KF$B!!\u0010\u0002f!Q\u0011QIA0\u0003\u0003\u0005\r!!\u0017\t\u0011\u0005%\u0004\u0001)Q\u0005\u00033\n!b]8si\u0016$W*\u00199!Q\u0011\t9'!\u0014\t\u0017\u0005=\u0004\u00011AA\u0002\u0013%\u0011\u0011O\u0001\fWZ\u001cvN\u001d;fI6\u000b\u0007/\u0006\u0002\u0002tA9\u0011QFA;\u0003\u0006e\u0013\u0002BA<\u0003_\u00111!T1q\u0011-\tY\b\u0001a\u0001\u0002\u0004%I!! \u0002\u001f-48k\u001c:uK\u0012l\u0015\r]0%KF$B!!\u0010\u0002\u0000!Q\u0011QIA=\u0003\u0003\u0005\r!a\u001d\t\u0011\u0005\r\u0005\u0001)Q\u0005\u0003g\nAb\u001b<T_J$X\rZ'ba\u0002BC!!!\u0002N!Y\u0011\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011BAF\u0003E\u0019xN\u001d;LKf\u001cu.\u001c9be\u0006$xN]\u000b\u0003\u0003\u001b\u0003R!!\f\u0002\u0010\u0006KA!!%\u00020\tQ1i\\7qCJ\fGo\u001c:\t\u0017\u0005U\u0005\u00011AA\u0002\u0013%\u0011qS\u0001\u0016g>\u0014HoS3z\u0007>l\u0007/\u0019:bi>\u0014x\fJ3r)\u0011\ti$!'\t\u0015\u0005\u0015\u00131SA\u0001\u0002\u0004\ti\t\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0015BAG\u0003I\u0019xN\u001d;LKf\u001cu.\u001c9be\u0006$xN\u001d\u0011\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\u0006!q\u000e]3o)\u0011\ti$!*\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003S\u000b1a\u0019;y!\u0011\tY+a,\u000e\u0005\u00055&B\u0001\u001e\u0005\u0013\u0011\t\t,!,\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBA[\u0001\u0011\u0005\u0011qW\u0001\u000fS:LG\u000fS3baN#\u0018\r^3t)\t\ti\u0004C\u0004\u0002<\u0002!\t%!0\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiRA\u0011QHA`\u0003\u0007\f\u0019\u0010C\u0004\u0002B\u0006e\u0006\u0019A!\u0002\u0019%t\u0007/\u001e;CCN,'k\\<\t\u0011\u0005\u0015\u0017\u0011\u0018a\u0001\u0003\u000f\fqaY8oi\u0016DH\u000f\u0005\u0003\u0002J\u00065h\u0002BAf\u0003StA!!4\u0002h:!\u0011qZAs\u001d\u0011\t\t.a9\u000f\t\u0005M\u0017\u0011\u001d\b\u0005\u0003+\fyN\u0004\u0003\u0002X\u0006uWBAAm\u0015\r\tYND\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002;\t%!\u00111^AW\u0003=\u0001&o\\2fgN4UO\\2uS>t\u0017\u0002BAx\u0003c\u0014qaQ8oi\u0016DHO\u0003\u0003\u0002l\u00065\u0006\u0002CA{\u0003s\u0003\r!a>\u0002\u0007=,H\u000fE\u0003\u0002z\u0006u\u0018)\u0004\u0002\u0002|*\u00111\u0005C\u0005\u0005\u0003\u007f\fYPA\u0005D_2dWm\u0019;pe\"9!1\u0001\u0001\u0005\n\t\u0015\u0011a\u00079s_\u000e,7o]#mK6,g\u000e^,ji\"\u0014vn\u001e(v[\n,'\u000f\u0006\u0005\u0002>\t\u001d!1\u0002B\b\u0011\u001d\u0011IA!\u0001A\u0002\u0005\u000b\u0001\"\u001b8qkR\u0014vn\u001e\u0005\b\u0005\u001b\u0011\t\u00011\u0001B\u0003\u001d\u0019xN\u001d;LKfD\u0001\"!>\u0003\u0002\u0001\u0007\u0011q\u001f\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0003y\u0001(o\\2fgN,E.Z7f]R<\u0016\u000e\u001e5pkR\u0014vn\u001e(v[\n,'\u000f\u0006\u0004\u0002>\t]!\u0011\u0004\u0005\b\u0005\u0013\u0011\t\u00021\u0001B\u0011!\t)P!\u0005A\u0002\u0005]\bb\u0002B\u000f\u0001\u0011\u0005#qD\u0001\b_:$\u0016.\\3s)!\tiD!\t\u0003&\t5\u0002b\u0002B\u0012\u00057\u0001\r\u0001Z\u0001\ni&lWm\u001d;b[BD\u0001\"a*\u0003\u001c\u0001\u0007!q\u0005\t\u0005\u0003\u0013\u0014I#\u0003\u0003\u0003,\u0005E(AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003k\u0014Y\u00021\u0001\u0002x\"9!\u0011\u0007\u0001\u0005\u0002\tM\u0012\u0001G3nSR\u0014VmY8sIN<\u0016\u000e\u001e5S_^tU/\u001c2feRA\u0011Q\bB\u001b\u0005o\u0011I\u0004C\u0004\u0003\u000e\t=\u0002\u0019A!\t\u000f\t%!q\u0006a\u0001\u0003\"A\u0011Q\u001fB\u0018\u0001\u0004\t9\u0010C\u0004\u0003>\u0001!\tEa\u0010\u0002#\u001d,G/T1y'>\u0014H/T1q'&TX-F\u0001e\u000f\u001d\u0011\u0019\u0005\u0001E\u0005\u0005\u000b\n\u0011#\u0011:sCfd\u0015n\u001d;TkB\u0004H.[3s!\u0011\u00119E!\u0013\u000e\u0003\u00011qAa\u0013\u0001\u0011\u0013\u0011iEA\tBeJ\f\u0017\u0010T5tiN+\b\u000f\u001d7jKJ\u001cbA!\u0013\u0003P\tm\u0003\u0003\u0002B)\u0005/j!Aa\u0015\u000b\t\tU\u0013\u0011G\u0001\u0005Y\u0006tw-\u0003\u0003\u0003Z\tM#AB(cU\u0016\u001cG\u000f\u0005\u0004\u0003^\t\r$qM\u0007\u0003\u0005?RAA!\u0019\u00020\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003f\t}#\u0001C*vaBd\u0017.\u001a:\u0011\u000b\u00055\"\u0011N!\n\t\t-\u0014q\u0006\u0002\u000b\u0007>dG.Z2uS>t\u0007b\u0002;\u0003J\u0011\u0005!q\u000e\u000b\u0003\u0005\u000bB\u0001Ba\u001d\u0003J\u0011\u0005#QO\u0001\u0004O\u0016$HC\u0001B4\u0001")
public class AppendRankFunction
extends AbstractRankFunction
implements Compiler<RecordComparator>,
Logging {
    private final BaseRowTypeInfo inputRowType;
    private final BaseRowTypeInfo sortKeyType;
    private final GeneratedSorter gSorter;
    private final KeySelector<BaseRow, BaseRow> sortKeySelector;
    private final SqlKind rankKind;
    private final long cacheSize;
    private final AbstractRowSerializer<BaseRow> inputRowSer;
    private transient KeyedMapState<BaseRow, BaseRow, List<BaseRow>> dataState;
    private transient SortedMap<BaseRow> sortedMap;
    private transient Map<BaseRow, SortedMap<BaseRow>> kvSortedMap;
    private Comparator<BaseRow> sortKeyComparator;
    private volatile AppendRankFunction$ArrayListSupplier$ ArrayListSupplier$module;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppendRankFunction$ArrayListSupplier$ ArrayListSupplier$lzycompute() {
        AppendRankFunction appendRankFunction = this;
        synchronized (appendRankFunction) {
            if (this.ArrayListSupplier$module != null) return this.ArrayListSupplier$module;
            this.ArrayListSupplier$module = new AppendRankFunction$ArrayListSupplier$(this);
            return this.ArrayListSupplier$module;
        }
    }

    private Logger LOG$lzycompute() {
        AppendRankFunction appendRankFunction = this;
        synchronized (appendRankFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<RecordComparator> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private AbstractRowSerializer<BaseRow> inputRowSer() {
        return this.inputRowSer;
    }

    private KeyedMapState<BaseRow, BaseRow, List<BaseRow>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(KeyedMapState<BaseRow, BaseRow, List<BaseRow>> x$1) {
        this.dataState = x$1;
    }

    public SortedMap<BaseRow> sortedMap() {
        return this.sortedMap;
    }

    public void sortedMap_$eq(SortedMap<BaseRow> x$1) {
        this.sortedMap = x$1;
    }

    private Map<BaseRow, SortedMap<BaseRow>> kvSortedMap() {
        return this.kvSortedMap;
    }

    private void kvSortedMap_$eq(Map<BaseRow, SortedMap<BaseRow>> x$1) {
        this.kvSortedMap = x$1;
    }

    private Comparator<BaseRow> sortKeyComparator() {
        return this.sortKeyComparator;
    }

    private void sortKeyComparator_$eq(Comparator<BaseRow> x$1) {
        this.sortKeyComparator = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        super.open(ctx);
        int lruCacheSize = Math.max(1, (int)(this.cacheSize / this.getDefaultTopSize()));
        this.kvSortedMap_$eq(new LRUMap<BaseRow, SortedMap<BaseRow>>(lruCacheSize));
        this.LOG().info("Top{} operator is using LRU caches key-size: {}", (Object)BoxesRunTime.boxToLong((long)this.getDefaultTopSize()), (Object)BoxesRunTime.boxToInteger((int)lruCacheSize));
        ListTypeInfo<BaseRow> valueTypeInfo = new ListTypeInfo<BaseRow>(this.inputRowType);
        MapStateDescriptor<BaseRow, BaseRow> mapStateDescriptor = new MapStateDescriptor<BaseRow, BaseRow>("data-state-with-append", new BaseRowTypeInfo(this.sortKeyType.getFieldTypes()), (TypeInformation<BaseRow>)valueTypeInfo);
        this.dataState_$eq(ctx.getKeyedMapState(mapStateDescriptor));
        String name = this.gSorter.comparator().name();
        String code = this.gSorter.comparator().code();
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling Sorter: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, code})));
        Class<RecordComparator> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), name, code);
        this.gSorter.comparator().code_$eq(null);
        this.LOG().debug("Instantiating Sorter.");
        RecordComparator comparator = clazz.newInstance();
        comparator.init(this.gSorter.serializers(), this.gSorter.comparators());
        this.sortKeyComparator_$eq(new CollectionBaseRowComparator(comparator));
        this.registerMetric((long)this.kvSortedMap().size() * this.getDefaultTopSize());
    }

    public void initHeapStates() {
        this.requestCount_$eq(this.requestCount() + 1L);
        BaseRow currentKey = this.executionContext.currentKey();
        this.sortedMap_$eq(this.kvSortedMap().get(currentKey));
        if (this.sortedMap() == null) {
            this.sortedMap_$eq(new SortedMap<BaseRow>(this.sortKeyComparator(), this.ArrayListSupplier()));
            this.kvSortedMap().put(currentKey, this.sortedMap());
            Iterator iter = this.dataState().iterator((Object)currentKey);
            if (iter != null) {
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    BaseRow sortKey = (BaseRow)entry.getKey();
                    List values = (List)entry.getValue();
                    this.sortedMap().putAll(sortKey, values);
                }
            }
        } else {
            this.hitCount_$eq(this.hitCount() + 1L);
        }
    }

    @Override
    public void processElement(BaseRow inputBaseRow, ProcessFunction.Context context, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        long currentTime2 = context.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(context, currentTime2);
        this.initHeapStates();
        this.initRankEnd(inputBaseRow);
        BaseRow sortKey = this.sortKeySelector.getKey(inputBaseRow);
        if (this.checkSortKeyInBufferRange(sortKey, this.sortedMap(), this.sortKeyComparator())) {
            this.sortedMap().put(sortKey, this.inputRowSer().copy(inputBaseRow));
            Collection<BaseRow> inputs = this.sortedMap().get(sortKey);
            this.dataState().add((Object)currentKey, (Object)sortKey, (Object)((List)inputs));
            if (this.isRowNumberAppend() || this.hasOffset()) {
                this.processElementWithRowNumber(inputBaseRow, sortKey, out);
            } else {
                this.processElementWithoutRowNumber(inputBaseRow, out);
            }
        }
    }

    private void processElementWithRowNumber(BaseRow inputRow, BaseRow sortKey, Collector<BaseRow> out) {
        SqlKind sqlKind = this.rankKind;
        if (((Object)((Object)SqlKind.ROW_NUMBER)).equals((Object)sqlKind)) {
            this.emitRecordsWithRowNumber(sortKey, inputRow, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private void processElementWithoutRowNumber(BaseRow inputRow, Collector<BaseRow> out) {
        BaseRow currentKey = this.executionContext.currentKey();
        if ((long)this.sortedMap().currentTopNum() > this.rankEnd()) {
            Map.Entry<BaseRow, Collection<BaseRow>> lastEntry = this.sortedMap().lastEntry();
            BaseRow lastKey = lastEntry.getKey();
            List lastList = (List)lastEntry.getValue();
            BaseRow lastElement = (BaseRow)lastList.remove(lastList.size() - 1);
            if (lastList.isEmpty()) {
                this.sortedMap().removeAll(lastKey);
                this.dataState().remove((Object)currentKey, (Object)lastKey);
            } else {
                this.dataState().add((Object)currentKey, (Object)lastKey, (Object)lastList);
            }
            this.delete(out, lastElement);
        }
        this.collect(out, inputRow);
    }

    @Override
    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) {
        if (this.needToCleanupState(timestamp)) {
            this.kvSortedMap().remove(this.executionContext.currentKey());
            this.cleanupState((Seq<KeyedState<BaseRow, ?>>)Predef$.MODULE$.wrapRefArray((Object[])new KeyedState[]{this.dataState()}));
        }
    }

    public void emitRecordsWithRowNumber(BaseRow sortKey, BaseRow inputRow, Collector<BaseRow> out) {
        Iterator<Map.Entry<BaseRow, Collection<BaseRow>>> iterator = this.sortedMap().entrySet().iterator();
        int curRank = 0;
        boolean findSortKey = false;
        while (iterator.hasNext() && this.isInRankEnd(curRank)) {
            Map.Entry<BaseRow, Collection<BaseRow>> entry = iterator.next();
            Collection<BaseRow> records = entry.getValue();
            if (!findSortKey && entry.getKey().equals(sortKey)) {
                this.collect(out, inputRow, curRank += records.size());
                findSortKey = true;
                continue;
            }
            if (findSortKey) {
                Iterator<BaseRow> recordsIter = records.iterator();
                while (recordsIter.hasNext() && this.isInRankEnd(curRank)) {
                    BaseRow prevRow = recordsIter.next();
                    this.retract(out, prevRow, ++curRank - 1);
                    this.collect(out, prevRow, curRank);
                }
                continue;
            }
            curRank += records.size();
        }
        BaseRow currentKey = this.executionContext.currentKey();
        while (iterator.hasNext()) {
            Map.Entry<BaseRow, Collection<BaseRow>> entry = iterator.next();
            BaseRow sortKey2 = entry.getKey();
            this.dataState().remove((Object)currentKey, (Object)sortKey2);
            SortedMap<BaseRow> sortedMap = this.sortedMap();
            sortedMap.currentTopNum_$eq(sortedMap.currentTopNum() - entry.getValue().size());
            iterator.remove();
        }
    }

    @Override
    public long getMaxSortMapSize() {
        return this.getDefaultTopSize();
    }

    private AppendRankFunction$ArrayListSupplier$ ArrayListSupplier() {
        return this.ArrayListSupplier$module == null ? this.ArrayListSupplier$lzycompute() : this.ArrayListSupplier$module;
    }

    public AppendRankFunction(BaseRowTypeInfo inputRowType, BaseRowTypeInfo sortKeyType, GeneratedSorter gSorter, KeySelector<BaseRow, BaseRow> sortKeySelector, int outputArity, SqlKind rankKind, RankRange rankRange, long cacheSize, boolean generateRetraction, TableConfig tableConfig) {
        this.inputRowType = inputRowType;
        this.sortKeyType = sortKeyType;
        this.gSorter = gSorter;
        this.sortKeySelector = sortKeySelector;
        this.rankKind = rankKind;
        this.cacheSize = cacheSize;
        super(tableConfig, rankRange, inputRowType, inputRowType.getArity(), outputArity, generateRetraction);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.inputRowSer = inputRowType.createSerializer();
    }
}

