/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.rank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.SortedMapStateDescriptor;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedSortedMapState;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.Order;
import org.apache.flink.table.codegen.CodeGenUtils$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.FieldAccess;
import org.apache.flink.table.codegen.GeneratedFieldExtractor;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.runtime.functions.ExecutionContext;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.runtime.rank.AbstractRankFunction;
import org.apache.flink.table.runtime.rank.SortedMap;
import org.apache.flink.table.runtime.rank.UnarySortUpdateRankFunction$ArrayListSupplier$;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.typeutils.OrderedTypeUtils$;
import org.apache.flink.table.util.LRUMap;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.table.util.StateUtil;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\reg\u0001B\u0001\u0003\u0001=\u00111$\u00168bef\u001cvN\u001d;Va\u0012\fG/\u001a*b].4UO\\2uS>t'BA\u0002\u0005\u0003\u0011\u0011\u0018M\\6\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\r\u0001\u0012QC\n\u0005\u0001E)\u0012\u0005\u0005\u0002\u0013'5\t!!\u0003\u0002\u0015\u0005\t!\u0012IY:ue\u0006\u001cGOU1oW\u001a+hn\u0019;j_:\u00042AF\r\u001c\u001b\u00059\"B\u0001\r\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AG\f\u0003\u0011\r{W\u000e]5mKJ\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0003\u0002\tM|'\u000f^\u0005\u0003Au\u0011\u0001CU3d_J$7i\\7qCJ\fGo\u001c:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u00112\u0011\u0001B;uS2L!AJ\u0012\u0003\u000f1{wmZ5oO\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002+[5\t1F\u0003\u0002-\r\u0005IA/\u001f9fkRLGn]\u0005\u0003]-\u0012qBQ1tKJ{w\u000fV=qK&sgm\u001c\u0005\ta\u0001\u0011\t\u0011)A\u0005S\u0005Q!o\\<LKf$\u0016\u0010]3\t\u0011I\u0002!\u0011!Q\u0001\nM\n1b]8si.+\u0017\u0010V=qKB\u0011AgN\u0007\u0002k)\u0011aGB\u0001\u0006if\u0004Xm]\u0005\u0003qU\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005q!o\\<LKf\u001cV\r\\3di>\u0014\b\u0003\u0002\u001fD\u000b\u0016k\u0011!\u0010\u0006\u0003}}\n\u0011BZ;oGRLwN\\:\u000b\u0005\u0001\u000b\u0015\u0001\u00026bm\u0006T!A\u0011\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002E{\tY1*Z=TK2,7\r^8s!\t1\u0015*D\u0001H\u0015\tAe!\u0001\u0006eCR\fgm\u001c:nCRL!AS$\u0003\u000f\t\u000b7/\u001a*po\"AA\n\u0001B\u0001B\u0003%Q*A\nhK:\u001cvN\u001d;LKf,\u0005\u0010\u001e:bGR|'\u000f\u0005\u0002\u0017\u001d&\u0011qj\u0006\u0002\u0018\u000f\u0016tWM]1uK\u00124\u0015.\u001a7e\u000bb$(/Y2u_JD\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IAU\u0001\u0006_J$WM\u001d\t\u0003'^k\u0011\u0001\u0016\u0006\u0003+Z\u000b\u0001\u0002Z1uCZLWm\u001e\u0006\u0003\u0005\u001aI!\u0001\u0017+\u0003\u000b=\u0013H-\u001a:\t\u0011i\u0003!\u0011!Q\u0001\nm\u000b1b\\;uaV$\u0018I]5usB\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n\u0019\u0011J\u001c;\t\u0011\t\u0004!\u0011!Q\u0001\n\r\f\u0001B]1oW.Kg\u000e\u001a\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f1a]9m\u0015\tA'\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005),'aB*rY.Kg\u000e\u001a\u0005\tY\u0002\u0011\t\u0011)A\u0005[\u0006I!/\u00198l%\u0006tw-\u001a\t\u0003]Jl\u0011a\u001c\u0006\u0003IAT!!\u001d\u0004\u0002\tAd\u0017M\\\u0005\u0003g>\u0014\u0011BU1oWJ\u000bgnZ3\t\u0011U\u0004!\u0011!Q\u0001\nY\f\u0011bY1dQ\u0016\u001c\u0016N_3\u0011\u0005q;\u0018B\u0001=^\u0005\u0011auN\\4\t\u0011i\u0004!\u0011!Q\u0001\nm\f!cZ3oKJ\fG/\u001a*fiJ\f7\r^5p]B\u0011A\f`\u0005\u0003{v\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0000\u0001\t\u0005\t\u0015!\u0003\u0002\u0002\u0005YA/\u00192mK\u000e{gNZ5h!\u0011\t\u0019!!\u0002\u000e\u0003YK1!a\u0002W\u0005-!\u0016M\u00197f\u0007>tg-[4\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u00051A(\u001b8jiz\"\"$a\u0004\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\u0001BA\u0005\u0001\u0002\u0012A!\u00111CA\u000b\u0019\u0001!q!a\u0006\u0001\u0005\u0004\tIBA\u0001L#\u0011\tY\"!\t\u0011\u0007q\u000bi\"C\u0002\u0002 u\u0013qAT8uQ&tw\rE\u0002]\u0003GI1!!\n^\u0005\r\te.\u001f\u0005\u0007Q\u0005%\u0001\u0019A\u0015\t\rA\nI\u00011\u0001*\u0011\u0019\u0011\u0014\u0011\u0002a\u0001g!1!(!\u0003A\u0002mBa\u0001TA\u0005\u0001\u0004i\u0005BB)\u0002\n\u0001\u0007!\u000b\u0003\u0004[\u0003\u0013\u0001\ra\u0017\u0005\u0007E\u0006%\u0001\u0019A2\t\r1\fI\u00011\u0001n\u0011\u0019)\u0018\u0011\u0002a\u0001m\"1!0!\u0003A\u0002mDqa`A\u0005\u0001\u0004\t\t\u0001C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D\u0005Y\u0011N\u001c9viJ{woU3s+\t\t)\u0005\u0005\u0003+\u0003\u000f*\u0015bAA%W\t)\u0012IY:ue\u0006\u001cGOU8x'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002CA'\u0001\u0001\u0006I!!\u0012\u0002\u0019%t\u0007/\u001e;S_^\u001cVM\u001d\u0011\t\u0017\u0005E\u0003\u00011AA\u0002\u0013%\u00111K\u0001\nI\u0006$\u0018m\u0015;bi\u0016,\"!!\u0016\u0011\u0013\u0005]\u00131M#\u0002\u0012\u0005\u001dTBAA-\u0015\u0011\tY&!\u0018\u0002\u000b-,\u00170\u001a3\u000b\t\u0005}\u0013\u0011M\u0001\u0006gR\fG/\u001a\u0006\u0003\u000b!IA!!\u001a\u0002Z\t\u00192*Z=fIN{'\u000f^3e\u001b\u0006\u00048\u000b^1uKB)\u0011\u0011NA8\u000b6\u0011\u00111\u000e\u0006\u0004I\u00055$\"\u0001!\n\t\u0005E\u00141\u000e\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002v\u0001\u0001\r\u00111A\u0005\n\u0005]\u0014!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002z\u0005}\u0004c\u0001/\u0002|%\u0019\u0011QP/\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u0003\u000b\u0019(!AA\u0002\u0005U\u0013a\u0001=%c!A\u0011Q\u0011\u0001!B\u0013\t)&\u0001\u0006eCR\f7\u000b^1uK\u0002BC!a!\u0002\nB\u0019A,a#\n\u0007\u00055ULA\u0005ue\u0006t7/[3oi\"Y\u0011\u0011\u0013\u0001A\u0002\u0003\u0007I\u0011BAJ\u0003-\u0011xn^6fsN#\u0018\r^3\u0016\u0005\u0005U\u0005cBA,\u0003/+U)R\u0005\u0005\u00033\u000bIFA\u0007LKf,G-T1q'R\fG/\u001a\u0005\f\u0003;\u0003\u0001\u0019!a\u0001\n\u0013\ty*A\bs_^\\W-_*uCR,w\fJ3r)\u0011\tI(!)\t\u0015\u0005\u0005\u00151TA\u0001\u0002\u0004\t)\n\u0003\u0005\u0002&\u0002\u0001\u000b\u0015BAK\u00031\u0011xn^6fsN#\u0018\r^3!Q\u0011\t\u0019+!#\t\u0017\u0005-\u0006\u00011AA\u0002\u0013E\u0011QV\u0001\ng>\u0014H/\u001a3NCB,\"!a,\u0011\u000bI\t\t,!\u0005\n\u0007\u0005M&AA\u0005T_J$X\rZ'ba\"Y\u0011q\u0017\u0001A\u0002\u0003\u0007I\u0011CA]\u00035\u0019xN\u001d;fI6\u000b\u0007o\u0018\u0013fcR!\u0011\u0011PA^\u0011)\t\t)!.\u0002\u0002\u0003\u0007\u0011q\u0016\u0005\t\u0003\u007f\u0003\u0001\u0015)\u0003\u00020\u0006Q1o\u001c:uK\u0012l\u0015\r\u001d\u0011)\t\u0005u\u0016\u0011\u0012\u0005\f\u0003\u000b\u0004\u0001\u0019!a\u0001\n#\t9-A\u0006lmN{'\u000f^3e\u001b\u0006\u0004XCAAe!\u0019\u0011\u00131Z#\u00020&\u0019\u0011QZ\u0012\u0003\r1\u0013V+T1q\u0011-\t\t\u000e\u0001a\u0001\u0002\u0004%\t\"a5\u0002\u001f-48k\u001c:uK\u0012l\u0015\r]0%KF$B!!\u001f\u0002V\"Q\u0011\u0011QAh\u0003\u0003\u0005\r!!3\t\u0011\u0005e\u0007\u0001)Q\u0005\u0003\u0013\fAb\u001b<T_J$X\rZ'ba\u0002BC!a6\u0002\n\"Y\u0011q\u001c\u0001A\u0002\u0003\u0007I\u0011CAq\u0003%\u0011xn^&fs6\u000b\u0007/\u0006\u0002\u0002dB1\u0011\u0011NAs\u000b\u0016KA!a:\u0002l\t\u0019Q*\u00199\t\u0017\u0005-\b\u00011AA\u0002\u0013E\u0011Q^\u0001\u000ee><8*Z=NCB|F%Z9\u0015\t\u0005e\u0014q\u001e\u0005\u000b\u0003\u0003\u000bI/!AA\u0002\u0005\r\b\u0002CAz\u0001\u0001\u0006K!a9\u0002\u0015I|woS3z\u001b\u0006\u0004\b\u0005\u000b\u0003\u0002r\u0006%\u0005bCA}\u0001\u0001\u0007\t\u0019!C\t\u0003w\f1b\u001b<S_^\\U-_'baV\u0011\u0011Q \t\u0007E\u0005-W)a9\t\u0017\t\u0005\u0001\u00011AA\u0002\u0013E!1A\u0001\u0010WZ\u0014vn^&fs6\u000b\u0007o\u0018\u0013fcR!\u0011\u0011\u0010B\u0003\u0011)\t\t)a@\u0002\u0002\u0003\u0007\u0011Q \u0005\t\u0005\u0013\u0001\u0001\u0015)\u0003\u0002~\u0006a1N\u001e*po.+\u00170T1qA!\"!qAAE\u0011-\u0011y\u0001\u0001a\u0001\u0002\u0004%\tB!\u0005\u0002#M|'\u000f^&fs\u000e{W\u000e]1sCR|'/\u0006\u0002\u0003\u0014A1!Q\u0003B\u000f\u0003#i!Aa\u0006\u000b\u0007y\u0012IBC\u0002\u0003\u001c\u0005\u000baaY8n[>t\u0017\u0002\u0002B\u0010\u0005/\u0011!bQ8na\u0006\u0014\u0018\r^8s\u0011-\u0011\u0019\u0003\u0001a\u0001\u0002\u0004%\tB!\n\u0002+M|'\u000f^&fs\u000e{W\u000e]1sCR|'o\u0018\u0013fcR!\u0011\u0011\u0010B\u0014\u0011)\t\tI!\t\u0002\u0002\u0003\u0007!1\u0003\u0005\t\u0005W\u0001\u0001\u0015)\u0003\u0003\u0014\u0005\u00112o\u001c:u\u0017\u0016L8i\\7qCJ\fGo\u001c:!\u0011-\u0011y\u0003\u0001a\u0001\u0002\u0004%\tB!\r\u0002\u001fM|'\u000f^&fsN+G.Z2u_J,\"Aa\r\u0011\rY\u0011)$RA\t\u0013\r\u00119d\u0006\u0002\f\r&,G\u000eZ!dG\u0016\u001c8\u000fC\u0006\u0003<\u0001\u0001\r\u00111A\u0005\u0012\tu\u0012aE:peR\\U-_*fY\u0016\u001cGo\u001c:`I\u0015\fH\u0003BA=\u0005\u007fA!\"!!\u0003:\u0005\u0005\t\u0019\u0001B\u001a\u0011!\u0011\u0019\u0005\u0001Q!\n\tM\u0012\u0001E:peR\\U-_*fY\u0016\u001cGo\u001c:!\u0011\u001d\u00119\u0005\u0001C!\u0005\u0013\nAa\u001c9f]R!\u0011\u0011\u0010B&\u0011!\u0011iE!\u0012A\u0002\t=\u0013aA2uqB!!\u0011\u000bB+\u001b\t\u0011\u0019F\u0003\u0002?\t%!!q\u000bB*\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0004\u0003\\\u0001!\tA!\u0018\u0002\u001d%t\u0017\u000e\u001e%fCB\u001cF/\u0019;fgR\u0011\u0011\u0011\u0010\u0005\b\u0005C\u0002A\u0011\tB2\u00039\u0001(o\\2fgN,E.Z7f]R$\u0002\"!\u001f\u0003f\t%$\u0011\u0014\u0005\b\u0005O\u0012y\u00061\u0001F\u00031Ig\u000e];u\u0005\u0006\u001cXMU8x\u0011!\u0011YGa\u0018A\u0002\t5\u0014aB2p]R,\u0007\u0010\u001e\t\u0005\u0005_\u0012\u0019J\u0004\u0003\u0003r\t=e\u0002\u0002B:\u0005\u001bsAA!\u001e\u0003\f:!!q\u000fBE\u001d\u0011\u0011IHa\"\u000f\t\tm$Q\u0011\b\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)\u0019!\u0011\u0011\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003}\u0011IAA!%\u0003T\u0005y\u0001K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0003\u0016\n]%aB\"p]R,\u0007\u0010\u001e\u0006\u0005\u0005#\u0013\u0019\u0006\u0003\u0005\u0003\u001c\n}\u0003\u0019\u0001BO\u0003\ryW\u000f\u001e\t\u0006\u0005?\u0013\u0019+R\u0007\u0003\u0005CS!\u0001\n\u0005\n\t\t\u0015&\u0011\u0015\u0002\n\u0007>dG.Z2u_JDqA!+\u0001\t\u0003\u0011Y+\u0001\u0005e_&s7/\u001a:u)9\tIH!,\u00032\nU&\u0011\u0018B_\u0005\u0003DqAa,\u0003(\u0002\u0007Q)\u0001\u0007qCJ$\u0018\u000e^5p].+\u0017\u0010C\u0004\u00034\n\u001d\u0006\u0019A#\u0002\u0011%t\u0007/\u001e;S_^DqAa.\u0003(\u0002\u0007Q)\u0001\u0004s_^\\U-\u001f\u0005\t\u0005w\u00139\u000b1\u0001\u0002\u0012\u000591o\u001c:u\u0017\u0016L\bb\u0002B`\u0005O\u0003\ra_\u0001\u0007S:DU-\u00199\t\u0011\tm%q\u0015a\u0001\u0005;CqA!2\u0001\t\u0003\u00119-\u0001\rf[&$(+Z2pe\u0012\u001cx+\u001b;i%><h*^7cKJ$\u0002\"!\u001f\u0003J\n-'Q\u001a\u0005\b\u0005g\u0013\u0019\r1\u0001F\u0011!\u0011YLa1A\u0002\u0005E\u0001\u0002\u0003BN\u0005\u0007\u0004\rA!(\t\u000f\tE\u0007\u0001\"\u0001\u0003T\u0006AR-\\5u%\u0016\u001cwN\u001d3t/&$\bn\\;u%><h*^7\u0015\u0019\u0005e$Q\u001bBl\u00053\u0014YN!8\t\u000f\t=&q\u001aa\u0001\u000b\"9!1\u0017Bh\u0001\u0004)\u0005b\u0002B\\\u0005\u001f\u0004\r!\u0012\u0005\t\u0005w\u0013y\r1\u0001\u0002\u0012!A!1\u0014Bh\u0001\u0004\u0011i\nC\u0004\u0003b\u0002!\tAa9\u0002\u0011\u0011|W\u000b\u001d3bi\u0016$\u0002#!\u001f\u0003f\n\u001d(\u0011\u001eBv\u0005[\u0014\tP!>\t\u000f\t=&q\u001ca\u0001\u000b\"9!1\u0017Bp\u0001\u0004)\u0005b\u0002B\\\u0005?\u0004\r!\u0012\u0005\t\u0005w\u0013y\u000e1\u0001\u0002\u0012!A!q\u001eBp\u0001\u0004\t\t\"\u0001\u0006pY\u0012\u001cvN\u001d;LKfDqAa=\u0003`\u0002\u0007Q)\u0001\u0004pY\u0012\u0014vn\u001e\u0005\t\u00057\u0013y\u000e1\u0001\u0003\u001e\"9!\u0011 \u0001\u0005\u0002\tm\u0018AG;qI\u0006$XMU3d_J$7oV5uQJ{wOT;nE\u0016\u0014HCDA=\u0005{\u0014yp!\u0001\u0004\u0004\r\u001d11\u0002\u0005\b\u0005g\u00139\u00101\u0001F\u0011!\u0011YLa>A\u0002\u0005E\u0001\u0002\u0003Bx\u0005o\u0004\r!!\u0005\t\u000f\r\u0015!q\u001fa\u0001w\u0006iQ\u000f\u001d3bi\u00164uN]<be\u0012Dqa!\u0003\u0003x\u0002\u00071,\u0001\u0007pY\u0012LeN\\3s%\u0006t7\u000e\u0003\u0005\u0003\u001c\n]\b\u0019\u0001BO\u0011\u001d\u0019y\u0001\u0001C\u0001\u0007#\t!$\u001e9eCR,'+Z2pe\u0012\u001cx+\u001b;i_V$(k\\<Ok6$\"#!\u001f\u0004\u0014\rU1qCB\r\u00077\u0019yba\t\u0004&!9!qVB\u0007\u0001\u0004)\u0005b\u0002B\\\u0007\u001b\u0001\r!\u0012\u0005\t\u0005w\u001bi\u00011\u0001\u0002\u0012!9!1_B\u0007\u0001\u0004)\u0005bBB\u000f\u0007\u001b\u0001\raW\u0001\b_2$'+\u00198l\u0011\u001d\u0019\tc!\u0004A\u0002m\fAb\u001c7e!>\u001c\u0018J\u001c%fCBDqa!\u0002\u0004\u000e\u0001\u00071\u0010\u0003\u0005\u0003\u001c\u000e5\u0001\u0019\u0001BO\u0011\u001d\u0019I\u0003\u0001C\u0001\u0007W\t\u0011$[:Q_NLG/[8og>3W\u000b\u001d3bi\u0016Le\u000eS3baRA1QFB\u001a\u0007k\u00199\u0004E\u0003]\u0007_Y80C\u0002\u00042u\u0013a\u0001V;qY\u0016\u0014\u0004b\u0002B\\\u0007O\u0001\r!\u0012\u0005\t\u0005w\u001b9\u00031\u0001\u0002\u0012!9!qVB\u0014\u0001\u0004)\u0005bBB\u001e\u0001\u0011\u0005!QL\u0001\u001ee\u0016lwN^3PkR|eMU1oO\u0016,E.Z7t\rJ|W\u000eS3ba\"91q\b\u0001\u0005\u0002\r\u0005\u0013a\u00054jY2Le\u000eS3baVsG/\u001b7Gk2dG\u0003BA=\u0007\u0007BqAa,\u0004>\u0001\u0007Q\tC\u0004\u0004H\u0001!\ta!\u0013\u0002!\u001d,G/\u00113kC\u000e,g\u000e^#mK6\u001cH\u0003BB&\u0007\u001b\u0002r\u0001XB\u0018\u0003#\t\t\u0002C\u0004\u0004P\r\u0015\u0003\u0019A#\u0002\u0015\r,(O]3oi.+\u0017\u0010C\u0004\u0004T\u0001!\ta!\u0016\u00023\rDWmY6T_J$8*Z=J]\n+hMZ3s%\u0006tw-\u001a\u000b\u0006w\u000e]3\u0011\f\u0005\b\u0007\u001f\u001a\t\u00061\u0001F\u0011!\u0011Yl!\u0015A\u0002\u0005E\u0001bBB/\u0001\u0011\u00051qL\u0001\u001ee\u00164'/Z:i\u0011\u0016\f\u0007/\u00118e'R\fG/\u001a$peJ+Wn\u001c<bYRa\u0011\u0011PB1\u0007G\u001a)ga\u001a\u0004j!9!qVB.\u0001\u0004)\u0005b\u0002B\\\u00077\u0002\r!\u0012\u0005\t\u0005w\u001bY\u00061\u0001\u0002\u0012!9!qXB.\u0001\u0004Y\b\"CB6\u00077\u0002\n\u00111\u0001|\u0003E)\b\u000fZ1uKJ{wo[3z'R\fG/\u001a\u0005\b\u0007_\u0002A\u0011AB9\u0003q\u0011XM\u001a:fg\"DU-\u00199B]\u0012\u001cF/\u0019;f\r>\u0014\u0018J\\:feR$b\"!\u001f\u0004t\rU4qOB=\u0007w\u001ai\bC\u0004\u00030\u000e5\u0004\u0019A#\t\u000f\tM6Q\u000ea\u0001\u000b\"9!qWB7\u0001\u0004)\u0005\u0002\u0003B^\u0007[\u0002\r!!\u0005\t\u000f\t}6Q\u000ea\u0001w\"I11NB7!\u0003\u0005\ra_\u0004\b\u0007\u0003\u0003\u0001\u0012BBB\u0003E\t%O]1z\u0019&\u001cHoU;qa2LWM\u001d\t\u0005\u0007\u000b\u001b9)D\u0001\u0001\r\u001d\u0019I\t\u0001E\u0005\u0007\u0017\u0013\u0011#\u0011:sCfd\u0015n\u001d;TkB\u0004H.[3s'\u0019\u00199i!$\u0004\u001aB!1qRBK\u001b\t\u0019\tJ\u0003\u0003\u0004\u0014\u00065\u0014\u0001\u00027b]\u001eLAaa&\u0004\u0012\n1qJ\u00196fGR\u0004baa'\u0004\"\u000e\u0015VBABO\u0015\u0011\u0019y*a\u001b\u0002\u0011\u0019,hn\u0019;j_:LAaa)\u0004\u001e\nA1+\u001e9qY&,'\u000fE\u0003\u0002j\r\u001dV)\u0003\u0003\u0004*\u0006-$AC\"pY2,7\r^5p]\"A\u00111BBD\t\u0003\u0019i\u000b\u0006\u0002\u0004\u0004\"A1\u0011WBD\t\u0003\u001a\u0019,A\u0002hKR$\"a!*\t\u000f\r]\u0006\u0001\"\u0011\u0004:\u0006\tr-\u001a;NCb\u001cvN\u001d;NCB\u001c\u0016N_3\u0016\u0003YD\u0011b!0\u0001#\u0003%\taa0\u0002MI,gM]3tQ\"+\u0017\r]!oIN#\u0018\r^3G_JLen]3si\u0012\"WMZ1vYR$c'\u0006\u0002\u0004B*\u001a1pa1,\u0005\r\u0015\u0007\u0003BBd\u0007#l!a!3\u000b\t\r-7QZ\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa4^\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007'\u001cIMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011ba6\u0001#\u0003%\taa0\u0002OI,gM]3tQ\"+\u0017\r]!oIN#\u0018\r^3G_J\u0014V-\\8wC2$C-\u001a4bk2$H%\u000e")
public class UnarySortUpdateRankFunction<K>
extends AbstractRankFunction
implements Compiler<RecordComparator>,
Logging {
    private final BaseRowTypeInfo inputRowType;
    private final BaseRowTypeInfo rowKeyType;
    private final DataType sortKeyType;
    private final KeySelector<BaseRow, BaseRow> rowKeySelector;
    private final GeneratedFieldExtractor genSortKeyExtractor;
    private final Order order;
    private final SqlKind rankKind;
    private final long cacheSize;
    private final AbstractRowSerializer<BaseRow> inputRowSer;
    private transient KeyedSortedMapState<BaseRow, K, List<BaseRow>> dataState;
    private transient KeyedMapState<BaseRow, BaseRow, BaseRow> org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState;
    private transient SortedMap<K> sortedMap;
    private transient LRUMap<BaseRow, SortedMap<K>> kvSortedMap;
    private transient Map<BaseRow, BaseRow> rowKeyMap;
    private transient LRUMap<BaseRow, Map<BaseRow, BaseRow>> kvRowKeyMap;
    private Comparator<K> sortKeyComparator;
    private FieldAccess<BaseRow, K> sortKeySelector;
    private volatile UnarySortUpdateRankFunction$ArrayListSupplier$ ArrayListSupplier$module;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UnarySortUpdateRankFunction$ArrayListSupplier$ ArrayListSupplier$lzycompute() {
        UnarySortUpdateRankFunction unarySortUpdateRankFunction = this;
        synchronized (unarySortUpdateRankFunction) {
            if (this.ArrayListSupplier$module != null) return this.ArrayListSupplier$module;
            this.ArrayListSupplier$module = new UnarySortUpdateRankFunction$ArrayListSupplier$(this);
            return this.ArrayListSupplier$module;
        }
    }

    private Logger LOG$lzycompute() {
        UnarySortUpdateRankFunction unarySortUpdateRankFunction = this;
        synchronized (unarySortUpdateRankFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<RecordComparator> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private AbstractRowSerializer<BaseRow> inputRowSer() {
        return this.inputRowSer;
    }

    private KeyedSortedMapState<BaseRow, K, List<BaseRow>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(KeyedSortedMapState<BaseRow, K, List<BaseRow>> x$1) {
        this.dataState = x$1;
    }

    public KeyedMapState<BaseRow, BaseRow, BaseRow> org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState() {
        return this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState;
    }

    private void org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState_$eq(KeyedMapState<BaseRow, BaseRow, BaseRow> x$1) {
        this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState = x$1;
    }

    public SortedMap<K> sortedMap() {
        return this.sortedMap;
    }

    public void sortedMap_$eq(SortedMap<K> x$1) {
        this.sortedMap = x$1;
    }

    public LRUMap<BaseRow, SortedMap<K>> kvSortedMap() {
        return this.kvSortedMap;
    }

    public void kvSortedMap_$eq(LRUMap<BaseRow, SortedMap<K>> x$1) {
        this.kvSortedMap = x$1;
    }

    public Map<BaseRow, BaseRow> rowKeyMap() {
        return this.rowKeyMap;
    }

    public void rowKeyMap_$eq(Map<BaseRow, BaseRow> x$1) {
        this.rowKeyMap = x$1;
    }

    public LRUMap<BaseRow, Map<BaseRow, BaseRow>> kvRowKeyMap() {
        return this.kvRowKeyMap;
    }

    public void kvRowKeyMap_$eq(LRUMap<BaseRow, Map<BaseRow, BaseRow>> x$1) {
        this.kvRowKeyMap = x$1;
    }

    public Comparator<K> sortKeyComparator() {
        return this.sortKeyComparator;
    }

    public void sortKeyComparator_$eq(Comparator<K> x$1) {
        this.sortKeyComparator = x$1;
    }

    public FieldAccess<BaseRow, K> sortKeySelector() {
        return this.sortKeySelector;
    }

    public void sortKeySelector_$eq(FieldAccess<BaseRow, K> x$1) {
        this.sortKeySelector = x$1;
    }

    @Override
    public void open(ExecutionContext ctx) {
        super.open(ctx);
        int lruCacheSize = Math.max(1, (int)(this.cacheSize / this.getDefaultTopSize()));
        this.kvSortedMap_$eq(new LRUMap<BaseRow, SortedMap<K>>(lruCacheSize));
        this.kvRowKeyMap_$eq(new LRUMap<BaseRow, Map<BaseRow, BaseRow>>(lruCacheSize));
        this.LOG().info("Top{} operator is using LRU caches key-size: {}", (Object)BoxesRunTime.boxToLong((long)this.getDefaultTopSize()), (Object)BoxesRunTime.boxToInteger((int)lruCacheSize));
        this.sortKeyComparator_$eq(OrderedTypeUtils$.MODULE$.createComparatorFromDataType(this.sortKeyType, this.order));
        this.sortKeySelector_$eq((FieldAccess)CodeGenUtils$.MODULE$.compile(Thread.currentThread().getContextClassLoader(), this.genSortKeyExtractor.name(), this.genSortKeyExtractor.code()).newInstance());
        BaseRowTypeInfo rowKeyBaseRowType = new BaseRowTypeInfo(this.rowKeyType.getFieldTypes());
        ListTypeInfo<BaseRow> valueTypeInfo = new ListTypeInfo<BaseRow>(rowKeyBaseRowType);
        SortedMapStateDescriptor<K, BaseRow> sortedMapStateDesc = new SortedMapStateDescriptor<K, BaseRow>("data-state-with-unary-update", this.sortKeyComparator(), OrderedTypeUtils$.MODULE$.createOrderedTypeInfoFromDataType(this.sortKeyType, this.order), valueTypeInfo);
        this.dataState_$eq(ctx.getKeyedSortedMapState(sortedMapStateDesc));
        MapStateDescriptor<BaseRow, BaseRow> mapStateDesc = new MapStateDescriptor<BaseRow, BaseRow>("rowkey-state-with-unary-update", rowKeyBaseRowType, this.inputRowType);
        this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState_$eq(ctx.getKeyedMapState(mapStateDesc));
        this.registerMetric((long)this.kvSortedMap().size() * this.getDefaultTopSize());
    }

    public void initHeapStates() {
        this.requestCount_$eq(this.requestCount() + 1L);
        BaseRow partitionKey = this.executionContext.currentKey();
        this.sortedMap_$eq((SortedMap)this.kvSortedMap().get(partitionKey));
        this.rowKeyMap_$eq((Map)this.kvRowKeyMap().get(partitionKey));
        if (this.sortedMap() == null) {
            this.sortedMap_$eq(new SortedMap<K>(this.sortKeyComparator(), this.ArrayListSupplier()));
            this.rowKeyMap_$eq(new HashMap<BaseRow, BaseRow>());
            this.kvSortedMap().put(partitionKey, this.sortedMap());
            this.kvRowKeyMap().put(partitionKey, this.rowKeyMap());
            int cnt = 0;
            Iterator stateIter = this.dataState().iterator((Object)partitionKey);
            if (stateIter != null) {
                while ((long)cnt < this.rankEnd() && stateIter.hasNext()) {
                    Map.Entry stateEntry = (Map.Entry)stateIter.next();
                    Object sortKey = stateEntry.getKey();
                    List rowkeys = (List)stateEntry.getValue();
                    JavaConversions$.MODULE$.asScalaBuffer(rowkeys).foreach((Function1)new Serializable(this, partitionKey){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ UnarySortUpdateRankFunction $outer;
                        private final BaseRow partitionKey$1;

                        public final Object apply(BaseRow rowkey) {
                            BaseRow baseRow;
                            BaseRow row2 = (BaseRow)this.$outer.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().get((Object)this.partitionKey$1, (Object)rowkey);
                            if (row2 == null) {
                                this.$outer.LOG().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Unary topn] state inconsistent between data state and rowkey state! "})).s((Seq)Nil$.MODULE$)).append((Object)StateUtil.STATE_CLEARED_WARN_MSG).toString());
                                baseRow = BoxedUnit.UNIT;
                            } else {
                                baseRow = this.$outer.rowKeyMap().put(rowkey, row2);
                            }
                            return baseRow;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partitionKey$1 = partitionKey$1;
                        }
                    });
                    this.sortedMap().putAll(sortKey, rowkeys);
                    cnt += rowkeys.size();
                }
            }
        } else {
            this.hitCount_$eq(this.hitCount() + 1L);
        }
    }

    @Override
    public void processElement(BaseRow inputBaseRow, ProcessFunction.Context context, Collector<BaseRow> out) {
        long currentTime2 = context.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(context, currentTime2);
        this.initHeapStates();
        this.initRankEnd(inputBaseRow);
        SqlKind sqlKind = this.rankKind;
        if (((Object)((Object)SqlKind.ROW_NUMBER)).equals((Object)sqlKind)) {
            BoxedUnit boxedUnit;
            BaseRow currentKey = this.executionContext.currentKey();
            K sortKey = this.sortKeySelector().extract(inputBaseRow);
            BaseRow rowKey = this.rowKeySelector.getKey(inputBaseRow);
            BaseRow oldRow = this.rowKeyMap().get(rowKey);
            if (oldRow == null) {
                oldRow = (BaseRow)this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().get((Object)currentKey, (Object)rowKey);
            }
            if (oldRow == null) {
                boolean isInHeap = this.checkSortKeyInBufferRange(currentKey, sortKey);
                this.doInsert(currentKey, inputBaseRow, rowKey, sortKey, isInHeap, out);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                K oldSortKey = this.sortKeySelector().extract(oldRow);
                this.doUpdate(currentKey, inputBaseRow, rowKey, sortKey, oldSortKey, oldRow, out);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public void doInsert(BaseRow partitionKey, BaseRow inputRow, BaseRow rowKey, K sortKey, boolean inHeap, Collector<BaseRow> out) {
        this.refreshHeapAndStateForInsert(partitionKey, inputRow, rowKey, sortKey, inHeap, this.refreshHeapAndStateForInsert$default$6());
        if (inHeap) {
            if (this.isRowNumberAppend() || this.hasOffset()) {
                this.emitRecordsWithRowNumber(inputRow, sortKey, out);
            } else {
                this.emitRecordsWithoutRowNum(partitionKey, inputRow, rowKey, sortKey, out);
            }
            if ((long)this.sortedMap().currentTopNum() > this.rankEnd()) {
                this.removeOutOfRangeElemsFromHeap();
            }
        }
    }

    public void emitRecordsWithRowNumber(BaseRow inputRow, K sortKey, Collector<BaseRow> out) {
        Iterator<Map.Entry<K, Collection<BaseRow>>> iter = this.sortedMap().entrySet().iterator();
        int curRank = 0;
        boolean findSortKey = false;
        while (iter.hasNext() && (long)curRank < this.rankEnd()) {
            Map.Entry<K, Collection<BaseRow>> entry = iter.next();
            K curKey = entry.getKey();
            Collection<BaseRow> rowkeys = entry.getValue();
            if (!findSortKey && curKey.equals(sortKey)) {
                this.collect(out, inputRow, curRank += rowkeys.size());
                findSortKey = true;
                continue;
            }
            if (findSortKey) {
                Iterator<BaseRow> rowkeyIter = rowkeys.iterator();
                while (rowkeyIter.hasNext() && (long)curRank < this.rankEnd()) {
                    BaseRow rowkey = rowkeyIter.next();
                    BaseRow tempRow = this.rowKeyMap().get(rowkey);
                    this.retract(out, tempRow, ++curRank - 1);
                    this.collect(out, tempRow, curRank);
                }
                continue;
            }
            curRank += rowkeys.size();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void emitRecordsWithoutRowNum(BaseRow partitionKey, BaseRow inputRow, BaseRow rowKey, K sortKey, Collector<BaseRow> out) {
        Tuple2<Object, Object> tuple2 = this.rowNumber(sortKey, rowKey, this.sortedMap());
        if (tuple2 == null) throw new MatchError(tuple2);
        int rank = tuple2._1$mcI$sp();
        int n = rank;
        int rank2 = n;
        if (!this.isInRankEnd(rank2)) return;
        this.collect(out, inputRow);
        if ((long)this.sortedMap().currentTopNum() <= this.rankEnd()) {
            Tuple2<K, K> tuple22 = this.getAdjacentElems(partitionKey);
            if (tuple22 == null) throw new MatchError(tuple22);
            Object adjKeyInState = tuple22._2();
            Object object = adjKeyInState;
            Object adjKeyInState2 = object;
            if (adjKeyInState2 == null) return;
            if ((long)this.sortedMap().currentTopNum() < this.rankEnd()) {
                throw new TableException("This shouldn't happen. Please file an issue!");
            }
            List tempRowKeys = (List)this.dataState().get((Object)partitionKey, adjKeyInState2);
            if (tempRowKeys == null) {
                this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                return;
            } else {
                BaseRow tempRowkey = (BaseRow)JavaConversions$.MODULE$.asScalaBuffer(tempRowKeys).head();
                BaseRow tempRow = (BaseRow)this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().get((Object)partitionKey, (Object)tempRowkey);
                if (tempRow == null) {
                    this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                    return;
                } else {
                    this.delete(out, tempRow);
                }
            }
            return;
        } else {
            BaseRow tempRowkey = this.sortedMap().getElement((int)this.rankEnd() + 1);
            if (tempRowkey == null) {
                throw new TableException("This shouldn't happen. Please file an issue!");
            }
            BaseRow tempRow = this.rowKeyMap().get(tempRowkey);
            this.delete(out, tempRow);
        }
    }

    public void doUpdate(BaseRow partitionKey, BaseRow inputRow, BaseRow rowKey, K sortKey, K oldSortKey, BaseRow oldRow, Collector<BaseRow> out) {
        Tuple2<Object, Object> tuple2 = this.isPositionsOfUpdateInHeap(rowKey, sortKey, partitionKey);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            Tuple2.mcZZ.sp sp3;
            boolean oldPosInHeap = tuple2._1$mcZ$sp();
            boolean newPosInHeap = tuple2._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = sp3 = new Tuple2.mcZZ.sp(oldPosInHeap, newPosInHeap);
            boolean oldPosInHeap2 = sp4._1$mcZ$sp();
            boolean newPosInHeap2 = sp4._2$mcZ$sp();
            Tuple2.mcII.sp sp5 = sp2 = oldPosInHeap2 ? this.rowNumber(oldSortKey, rowKey, this.sortedMap()) : new Tuple2.mcII.sp(BoxesRunTime.unboxToInt(null), BoxesRunTime.unboxToInt(null));
            if (sp2 != null) {
                Tuple2.mcII.sp sp6;
                int oldRank = sp2._1$mcI$sp();
                int oldInnerRank = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(oldRank, oldInnerRank);
                int oldRank2 = sp7._1$mcI$sp();
                int oldInnerRank2 = sp7._2$mcI$sp();
                int compareNewAndOldSortKey = this.sortKeyComparator().compare(sortKey, oldSortKey);
                if (compareNewAndOldSortKey == 0) {
                    if (oldPosInHeap2) {
                        this.rowKeyMap().put(rowKey, this.inputRowSer().copy(inputRow));
                        if ((long)oldRank2 <= this.rankEnd()) {
                            if (this.isRowNumberAppend() || this.hasOffset()) {
                                this.retract(out, oldRow, oldRank2);
                                this.collect(out, inputRow, oldRank2);
                            } else {
                                this.collect(out, inputRow);
                            }
                        }
                    }
                    this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().add((Object)partitionKey, (Object)rowKey, (Object)inputRow);
                    return;
                }
                boolean updateForward = compareNewAndOldSortKey < 0;
                this.refreshHeapAndStateForRemoval(partitionKey, rowKey, oldSortKey, oldPosInHeap2, false);
                this.refreshHeapAndStateForInsert(partitionKey, inputRow, rowKey, sortKey, newPosInHeap2, true);
                if ((long)this.sortedMap().currentTopNum() < this.rankEnd()) {
                    this.fillInHeapUntilFull(partitionKey);
                }
                if (this.isRowNumberAppend() || this.hasOffset()) {
                    this.updateRecordsWithRowNumber(inputRow, sortKey, oldSortKey, updateForward, oldInnerRank2, out);
                } else {
                    this.updateRecordsWithoutRowNum(partitionKey, rowKey, sortKey, oldRow, oldRank2, oldPosInHeap2, updateForward, out);
                }
                if ((long)this.sortedMap().currentTopNum() > this.rankEnd()) {
                    this.removeOutOfRangeElemsFromHeap();
                }
                return;
            }
            throw new MatchError((Object)sp2);
        }
        throw new MatchError(tuple2);
    }

    public void updateRecordsWithRowNumber(BaseRow inputRow, K sortKey, K oldSortKey, boolean updateForward, int oldInnerRank, Collector<BaseRow> out) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = updateForward ? new Tuple2(sortKey, oldSortKey) : new Tuple2(oldSortKey, sortKey);
        if (tuple2 != null) {
            Tuple2 tuple23;
            Object minKey = tuple2._1();
            Object maxKey = tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2(minKey, maxKey);
            Object minKey2 = tuple24._1();
            Object maxKey2 = tuple24._2();
            Iterator<Map.Entry<K, Collection<BaseRow>>> iterator = this.sortedMap().entrySet().iterator();
            int curRank = 0;
            boolean quitFlag = false;
            while (iterator.hasNext() && (long)curRank < this.rankEnd() && !quitFlag) {
                Map.Entry<K, Collection<BaseRow>> entry = iterator.next();
                K curKey = entry.getKey();
                Collection<BaseRow> rowKeys = entry.getValue();
                int compareWithMin = this.sortKeyComparator().compare(curKey, minKey2);
                int compareWithMax = this.sortKeyComparator().compare(curKey, maxKey2);
                if (compareWithMin < 0) {
                    curRank += rowKeys.size();
                    continue;
                }
                if (compareWithMax > 0) {
                    quitFlag = true;
                    continue;
                }
                if (updateForward && compareWithMin == 0) {
                    if ((long)(curRank += rowKeys.size()) > this.rankEnd()) continue;
                    this.collect(out, inputRow, curRank);
                    continue;
                }
                Iterator<BaseRow> rowKeyIter = rowKeys.iterator();
                int curInnerRank = 0;
                while (rowKeyIter.hasNext() && (long)curRank < this.rankEnd() && !quitFlag) {
                    Object object;
                    ++curRank;
                    ++curInnerRank;
                    if (updateForward) {
                        if (compareWithMax == 0 && curInnerRank >= oldInnerRank) {
                            quitFlag = true;
                        } else {
                            BaseRow rowKey = rowKeyIter.next();
                            BaseRow row2 = this.rowKeyMap().get(rowKey);
                            this.retract(out, row2, curRank - 1);
                            this.collect(out, row2, curRank);
                        }
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    if (compareWithMax == 0 && curInnerRank == rowKeys.size()) {
                        this.collect(out, inputRow, curRank);
                        quitFlag = true;
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    if (compareWithMin == 0 && curInnerRank < oldInnerRank) {
                        object = rowKeyIter.next();
                        continue;
                    }
                    BaseRow rowKey = rowKeyIter.next();
                    BaseRow row3 = this.rowKeyMap().get(rowKey);
                    if ((long)curRank < this.rankEnd()) {
                        this.retract(out, row3, curRank + 1);
                    }
                    this.collect(out, row3, curRank);
                    object = BoxedUnit.UNIT;
                }
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateRecordsWithoutRowNum(BaseRow partitionKey, BaseRow rowKey, K sortKey, BaseRow oldRow, int oldRank, boolean oldPosInHeap, boolean updateForward, Collector<BaseRow> out) {
        boolean isOldRowInRankEnd;
        boolean bl;
        BaseRow row2 = this.rowKeyMap().get(rowKey);
        if (row2 == null) {
            bl = false;
        } else {
            int rank;
            int n;
            Tuple2<Object, Object> tuple2 = this.rowNumber(sortKey, rowKey, this.sortedMap());
            if (tuple2 == null) throw new MatchError(tuple2);
            int rank2 = n = (rank = tuple2._1$mcI$sp());
            bl = this.isInRankEnd(rank2);
        }
        boolean isNewRowInRankEnd = bl;
        boolean bl2 = isOldRowInRankEnd = !oldPosInHeap ? false : this.isInRankEnd(oldRank);
        if (updateForward) {
            if (!isNewRowInRankEnd) return;
            if (isOldRowInRankEnd) {
                this.collect(out, row2);
                return;
            } else {
                BaseRow rowAfterN;
                BaseRow baseRow;
                if ((long)this.sortedMap().currentTopNum() > this.rankEnd()) {
                    BaseRow tempRowkey = this.sortedMap().getElement((int)this.rankEnd() + 1);
                    baseRow = this.rowKeyMap().get(tempRowkey);
                } else {
                    Tuple2<K, K> tuple2 = this.getAdjacentElems(partitionKey);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    Object adjKeyInState = tuple2._2();
                    Object object = adjKeyInState;
                    Object adjKeyInState2 = object;
                    if (adjKeyInState2 == null) {
                        baseRow = null;
                    } else {
                        List tempRowKeys = (List)this.dataState().get((Object)partitionKey, adjKeyInState2);
                        if (tempRowKeys == null) {
                            this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                            baseRow = null;
                        } else {
                            BaseRow tempRowKey = (BaseRow)JavaConversions$.MODULE$.asScalaBuffer(tempRowKeys).head();
                            baseRow = rowAfterN = (BaseRow)this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().get((Object)partitionKey, (Object)tempRowKey);
                        }
                    }
                }
                if (rowAfterN != null) {
                    this.delete(out, rowAfterN);
                }
                this.collect(out, row2);
            }
            return;
        } else {
            if (!isOldRowInRankEnd) return;
            if (isNewRowInRankEnd) {
                this.collect(out, row2);
                return;
            } else {
                BaseRow tempRowkey = this.sortedMap().getElement((int)this.rankEnd());
                BaseRow tempRow = this.rowKeyMap().get(tempRowkey);
                this.delete(out, oldRow);
                this.collect(out, tempRow);
            }
        }
    }

    public Tuple2<Object, Object> isPositionsOfUpdateInHeap(BaseRow rowKey, K sortKey, BaseRow partitionKey) {
        Tuple2<K, K> tuple2 = this.getAdjacentElems(partitionKey);
        if (tuple2 != null) {
            boolean bl;
            Tuple2 tuple22;
            Object lastKeyInHeap = tuple2._1();
            Object adjKeyInState = tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2(lastKeyInHeap, adjKeyInState);
            Object lastKeyInHeap2 = tuple23._1();
            Object adjKeyInState2 = tuple23._2();
            BaseRow oldRow = this.rowKeyMap().get(rowKey);
            boolean oldPosInHeap = oldRow != null;
            int compare = this.sortKeyComparator().compare(sortKey, lastKeyInHeap2);
            if (compare <= 0) {
                bl = true;
            } else if (adjKeyInState2 == null) {
                bl = true;
            } else {
                if ((long)this.sortedMap().currentTopNum() < this.rankEnd()) {
                    throw new TableException("[unary topn] This shouldn't happen. Please file an issue");
                }
                bl = false;
            }
            boolean newPosInHeap = bl;
            return new Tuple2.mcZZ.sp(oldPosInHeap, newPosInHeap);
        }
        throw new MatchError(tuple2);
    }

    public void removeOutOfRangeElemsFromHeap() {
        Map.Entry<K, Collection<BaseRow>> lastEntry = this.sortedMap().lastEntry();
        while (lastEntry != null && (long)(this.sortedMap().currentTopNum() - lastEntry.getValue().size()) >= this.rankEnd()) {
            K sortKey = lastEntry.getKey();
            Collection<BaseRow> rowkeys = lastEntry.getValue();
            JavaConversions$.MODULE$.collectionAsScalaIterable(rowkeys).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnarySortUpdateRankFunction $outer;

                public final BaseRow apply(BaseRow rowkey) {
                    return this.$outer.rowKeyMap().remove(rowkey);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.sortedMap().removeAll(sortKey);
            lastEntry = this.sortedMap().lastEntry();
        }
    }

    public void fillInHeapUntilFull(BaseRow partitionKey) {
        Tuple2<K, K> tuple2 = this.getAdjacentElems(partitionKey);
        if (tuple2 != null) {
            Object lastKeyInHeap;
            Object object;
            Object lastKeyInHeap2 = object = (lastKeyInHeap = tuple2._1());
            Iterator iter = this.dataState().tailIterator((Object)partitionKey, lastKeyInHeap2);
            while ((long)this.sortedMap().currentTopNum() < this.rankEnd() && iter != null && iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getKey().equals(lastKeyInHeap2)) continue;
                Object sortKey = entry.getKey();
                List rowkeyList = (List)entry.getValue();
                JavaConversions$.MODULE$.asScalaBuffer(rowkeyList).foreach((Function1)new Serializable(this, partitionKey){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UnarySortUpdateRankFunction $outer;
                    private final BaseRow partitionKey$2;

                    public final BaseRow apply(BaseRow rowkey) {
                        BaseRow row2 = (BaseRow)this.$outer.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().get((Object)this.partitionKey$2, (Object)rowkey);
                        return this.$outer.rowKeyMap().put(rowkey, row2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partitionKey$2 = partitionKey$2;
                    }
                });
                this.sortedMap().putAll(sortKey, rowkeyList);
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<K, K> getAdjacentElems(BaseRow currentKey) {
        Object v0;
        Map.Entry<K, Collection<BaseRow>> lastEntry = this.sortedMap().lastEntry();
        K lastKeyInHeap = lastEntry.getKey();
        if (lastKeyInHeap == null) {
            v0 = null;
        } else {
            Iterator iter = this.dataState().tailIterator((Object)currentKey, lastKeyInHeap);
            if (iter != null && iter.hasNext()) {
                iter.next();
                v0 = iter.hasNext() ? ((Map.Entry)iter.next()).getKey() : null;
            } else {
                v0 = null;
            }
        }
        Object adjKeyInState = v0;
        return new Tuple2(lastKeyInHeap, adjKeyInState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkSortKeyInBufferRange(BaseRow currentKey, K sortKey) {
        Map.Entry<K, Collection<BaseRow>> worstEntry = this.sortedMap().lastEntry();
        if (worstEntry == null) {
            return true;
        }
        K worstKey = worstEntry.getKey();
        int compare = this.sortKeyComparator().compare(sortKey, worstKey);
        if (compare <= 0) {
            return true;
        }
        if ((long)this.sortedMap().currentTopNum() >= this.rankEnd()) return false;
        Tuple2<K, K> tuple2 = this.getAdjacentElems(currentKey);
        if (tuple2 == null) throw new MatchError(tuple2);
        Object adjKeyInState = tuple2._2();
        Object object = adjKeyInState;
        Object adjKeyInState2 = object;
        if (adjKeyInState2 != null) throw new TableException("This shouldn't happen! Please contact developer for details");
        return true;
    }

    public void refreshHeapAndStateForRemoval(BaseRow partitionKey, BaseRow rowKey, K sortKey, boolean inHeap, boolean updateRowkeyState) {
        List rowkeyList;
        List list;
        if (inHeap) {
            this.rowKeyMap().remove(rowKey);
            this.sortedMap().remove(sortKey, rowKey);
        }
        if (inHeap) {
            list = this.sortedMap().get(sortKey);
        } else {
            List tempRowkeyList = (List)this.dataState().get((Object)partitionKey, sortKey);
            if (tempRowkeyList == null) {
                this.LOG().warn(StateUtil.STATE_CLEARED_WARN_MSG);
                list = null;
            } else {
                tempRowkeyList.remove(rowKey);
                list = rowkeyList = tempRowkeyList;
            }
        }
        if (rowkeyList == null || rowkeyList.isEmpty()) {
            this.dataState().remove((Object)partitionKey, sortKey);
        } else {
            this.dataState().add((Object)partitionKey, sortKey, (Object)rowkeyList);
        }
        if (updateRowkeyState) {
            this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().remove((Object)partitionKey, (Object)rowKey);
        }
    }

    public boolean refreshHeapAndStateForRemoval$default$5() {
        return true;
    }

    public void refreshHeapAndStateForInsert(BaseRow partitionKey, BaseRow inputRow, BaseRow rowKey, K sortKey, boolean inHeap, boolean updateRowkeyState) {
        Collection<BaseRow> collection;
        Object object;
        if (inHeap) {
            this.sortedMap().put(sortKey, rowKey);
            object = this.rowKeyMap().put(rowKey, this.inputRowSer().copy(inputRow));
        } else {
            object = BoxedUnit.UNIT;
        }
        if (inHeap) {
            collection = this.sortedMap().get(sortKey);
        } else {
            ArrayList<BaseRow> keyList = (ArrayList<BaseRow>)this.dataState().get((Object)partitionKey, sortKey);
            if (keyList == null) {
                keyList = new ArrayList<BaseRow>();
            }
            keyList.add(rowKey);
            collection = keyList;
        }
        Collection<BaseRow> rowkeyList = collection;
        this.dataState().add((Object)partitionKey, sortKey, (Object)((List)rowkeyList));
        if (updateRowkeyState) {
            this.org$apache$flink$table$runtime$rank$UnarySortUpdateRankFunction$$rowkeyState().add((Object)partitionKey, (Object)rowKey, (Object)inputRow);
        }
    }

    public boolean refreshHeapAndStateForInsert$default$6() {
        return true;
    }

    private UnarySortUpdateRankFunction$ArrayListSupplier$ ArrayListSupplier() {
        return this.ArrayListSupplier$module == null ? this.ArrayListSupplier$lzycompute() : this.ArrayListSupplier$module;
    }

    @Override
    public long getMaxSortMapSize() {
        return 0L;
    }

    public UnarySortUpdateRankFunction(BaseRowTypeInfo inputRowType, BaseRowTypeInfo rowKeyType, DataType sortKeyType, KeySelector<BaseRow, BaseRow> rowKeySelector, GeneratedFieldExtractor genSortKeyExtractor, Order order, int outputArity, SqlKind rankKind, RankRange rankRange, long cacheSize, boolean generateRetraction, TableConfig tableConfig) {
        this.inputRowType = inputRowType;
        this.rowKeyType = rowKeyType;
        this.sortKeyType = sortKeyType;
        this.rowKeySelector = rowKeySelector;
        this.genSortKeyExtractor = genSortKeyExtractor;
        this.order = order;
        this.rankKind = rankKind;
        this.cacheSize = cacheSize;
        super(tableConfig, rankRange, inputRowType, inputRowType.getArity(), outputArity, generateRetraction);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        this.inputRowSer = inputRowType.createSerializer();
    }
}

