/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.rank;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.GeneratedSorter;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.plan.util.RankRange;
import org.apache.flink.table.runtime.functions.ProcessFunction;
import org.apache.flink.table.runtime.rank.AbstractUpdateRankFunction;
import org.apache.flink.table.runtime.rank.SortedMap;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.Collector;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001=\u0011!#\u00169eCR,'+\u00198l\rVt7\r^5p]*\u00111\u0001B\u0001\u0005e\u0006t7N\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u00035\u0005\u00137\u000f\u001e:bGR,\u0006\u000fZ1uKJ\u000bgn\u001b$v]\u000e$\u0018n\u001c8\t\u0011U\u0001!\u0011!Q\u0001\nY\tA\"\u001b8qkR\u0014vn\u001e+za\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0013QL\b/Z;uS2\u001c\u0018BA\u000e\u0019\u0005=\u0011\u0015m]3S_^$\u0016\u0010]3J]\u001a|\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0015I|woS3z)f\u0004X\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u00039\u0011xn^&fsN+G.Z2u_J\u0004B!\t\u0015+U5\t!E\u0003\u0002$I\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003K\u0019\nAA[1wC*\u0011q\u0005C\u0001\u0004CBL\u0017BA\u0015#\u0005-YU-_*fY\u0016\u001cGo\u001c:\u0011\u0005-rS\"\u0001\u0017\u000b\u000552\u0011A\u00033bi\u00064wN]7bi&\u0011q\u0006\f\u0002\b\u0005\u0006\u001cXMU8x\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014aB4T_J$XM\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tqaY8eK\u001e,g.\u0003\u00028i\tyq)\u001a8fe\u0006$X\rZ*peR,'\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003!\u0003=\u0019xN\u001d;LKf\u001cV\r\\3di>\u0014\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0017=,H\u000f];u\u0003JLG/\u001f\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0004\u0013:$\b\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u0011I\fgn[&j]\u0012\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u0007M\fHN\u0003\u0002J\u0015\u000591-\u00197dSR,\u0017BA&G\u0005\u001d\u0019\u0016\u000f\\&j]\u0012D\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IAT\u0001\ne\u0006t7NU1oO\u0016\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\tU$\u0018\u000e\u001c\u0006\u0003'\u001a\tA\u0001\u001d7b]&\u0011Q\u000b\u0015\u0002\n%\u0006t7NU1oO\u0016D\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001W\u0001\nG\u0006\u001c\u0007.Z*ju\u0016\u0004\"!P-\n\u0005is$\u0001\u0002'p]\u001eD\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!X\u0001\u0013O\u0016tWM]1uKJ+GO]1di&|g\u000e\u0005\u0002>=&\u0011qL\u0010\u0002\b\u0005>|G.Z1o\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0017a\u0003;bE2,7i\u001c8gS\u001e\u0004\"aY3\u000e\u0003\u0011T!a\n\u0004\n\u0005\u0019$'a\u0003+bE2,7i\u001c8gS\u001eDQ\u0001\u001b\u0001\u0005\u0002%\fa\u0001P5oSRtD\u0003\u00046lY6tw\u000e]9sgR,\bCA\t\u0001\u0011\u0015)r\r1\u0001\u0017\u0011\u0015ir\r1\u0001\u0017\u0011\u0015yr\r1\u0001!\u0011\u0015\tt\r1\u00013\u0011\u0015It\r1\u0001!\u0011\u0015Yt\r1\u0001=\u0011\u0015\u0019u\r1\u0001E\u0011\u0015iu\r1\u0001O\u0011\u00159v\r1\u0001Y\u0011\u0015av\r1\u0001^\u0011\u0015\tw\r1\u0001c\u0011\u001d9\bA1A\u0005\na\f1\"\u001b8qkR\u0014vn^*feV\t\u0011\u0010E\u0002\u0018u*J!a\u001f\r\u0003+\u0005\u00137\u000f\u001e:bGR\u0014vn^*fe&\fG.\u001b>fe\"1Q\u0010\u0001Q\u0001\ne\fA\"\u001b8qkR\u0014vn^*fe\u0002Baa \u0001\u0005B\u0005\u0005\u0011A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\t\u0003\u0007\tI!!\u0004\u0002@A\u0019Q(!\u0002\n\u0007\u0005\u001daH\u0001\u0003V]&$\bBBA\u0006}\u0002\u0007!&\u0001\u0007j]B,HOQ1tKJ{w\u000fC\u0004\u0002\u0010y\u0004\r!!\u0005\u0002\u000f\r|g\u000e^3yiB!\u00111CA\u001d\u001d\u0011\t)\"a\r\u000f\t\u0005]\u0011\u0011\u0007\b\u0005\u00033\tyC\u0004\u0003\u0002\u001c\u00055b\u0002BA\u000f\u0003WqA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0005B\u0005\u0005\u0003k\t9$A\bQe>\u001cWm]:Gk:\u001cG/[8o\u0015\t\u0019C!\u0003\u0003\u0002<\u0005u\"aB\"p]R,\u0007\u0010\u001e\u0006\u0005\u0003k\t9\u0004C\u0004\u0002By\u0004\r!a\u0011\u0002\u0007=,H\u000fE\u0003\u0002F\u0005%#&\u0004\u0002\u0002H)\u0011\u0011\u000bC\u0005\u0005\u0003\u0017\n9EA\u0005D_2dWm\u0019;pe\"9\u0011q\n\u0001\u0005\n\u0005E\u0013a\u00079s_\u000e,7o]#mK6,g\u000e^,ji\"\u0014vn\u001e(v[\n,'\u000f\u0006\u0004\u0002\u0004\u0005M\u0013q\u000b\u0005\b\u0003+\ni\u00051\u0001+\u0003!Ig\u000e];u%><\b\u0002CA!\u0003\u001b\u0002\r!a\u0011\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\u0005q\u0002O]8dKN\u001cX\t\\3nK:$x+\u001b;i_V$(k\\<Ok6\u0014WM\u001d\u000b\u0007\u0003\u0007\ty&!\u0019\t\u000f\u0005U\u0013\u0011\fa\u0001U!A\u0011\u0011IA-\u0001\u0004\t\u0019\u0005C\u0004\u0002f\u0001!\t!a\u001a\u00021\u0015l\u0017\u000e\u001e*fG>\u0014Hm],ji\"\u0014vn\u001e(v[\n,'\u000f\u0006\b\u0002\u0004\u0005%\u0014QNA8\u0003c\n)(!!\t\u000f\u0005-\u00141\ra\u0001U\u000591o\u001c:u\u0017\u0016L\bbBA+\u0003G\u0002\rA\u000b\u0005\t\u0003\u0003\n\u0019\u00071\u0001\u0002D!I\u00111OA2!\u0003\u0005\rAK\u0001\u000b_2$7k\u001c:u\u0017\u0016L\bBCA<\u0003G\u0002\n\u00111\u0001\u0002z\u00051q\u000e\u001c3S_^\u0004B!a\u001f\u0002~5\t\u0001!C\u0002\u0002\u0000I\u0011qAU1oWJ{w\u000fC\u0005\u0002\u0004\u0006\r\u0004\u0013!a\u0001y\u00059q\u000e\u001c3SC:\\\u0007bBAD\u0001\u0011\u0005\u0013\u0011R\u0001\u0012O\u0016$X*\u0019=T_J$X*\u00199TSj,W#\u0001-\t\u0013\u00055\u0005!%A\u0005\u0002\u0005=\u0015AI3nSR\u0014VmY8sIN<\u0016\u000e\u001e5S_^tU/\u001c2fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u0012*\u001a!&a%,\u0005\u0005U\u0005\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a(?\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\u000bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a*\u0001#\u0003%\t!!+\u0002E\u0015l\u0017\u000e\u001e*fG>\u0014Hm],ji\"\u0014vn\u001e(v[\n,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tYK\u000b\u0003\u0002z\u0005M\u0005\"CAX\u0001E\u0005I\u0011AAY\u0003\t*W.\u001b;SK\u000e|'\u000fZ:XSRD'k\\<Ok6\u0014WM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u0017\u0016\u0004y\u0005M\u0005")
public class UpdateRankFunction
extends AbstractUpdateRankFunction {
    private final KeySelector<BaseRow, BaseRow> rowKeySelector;
    private final KeySelector<BaseRow, BaseRow> sortKeySelector;
    private final SqlKind rankKind;
    private final AbstractRowSerializer<BaseRow> inputRowSer;

    private AbstractRowSerializer<BaseRow> inputRowSer() {
        return this.inputRowSer;
    }

    @Override
    public void processElement(BaseRow inputBaseRow, ProcessFunction.Context context, Collector<BaseRow> out) {
        long currentTime2 = context.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(context, currentTime2);
        this.initHeapStates();
        this.initRankEnd(inputBaseRow);
        if (this.isRowNumberAppend() || this.hasOffset()) {
            this.processElementWithRowNumber(inputBaseRow, out);
        } else {
            this.processElementWithoutRowNumber(inputBaseRow, out);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processElementWithRowNumber(BaseRow inputRow, Collector<BaseRow> out) {
        BaseRow sortKey = this.sortKeySelector.getKey(inputRow);
        BaseRow rowKey = this.rowKeySelector.getKey(inputRow);
        if (this.rowKeyMap().containsKey(rowKey)) {
            int oldRank;
            int n;
            AbstractUpdateRankFunction.RankRow oldRow = this.rowKeyMap().get(rowKey);
            BaseRow oldSortKey = this.sortKeySelector.getKey(oldRow.row());
            if (oldSortKey.equals(sortKey)) {
                Tuple2.mcII.sp sp2;
                SqlKind sqlKind = this.rankKind;
                if (!((Object)((Object)SqlKind.ROW_NUMBER)).equals((Object)sqlKind)) throw Predef$.MODULE$.$qmark$qmark$qmark();
                Tuple2<Object, Object> tuple2 = this.rowNumber(sortKey, rowKey, this.sortedMap());
                if (tuple2 == null) throw new MatchError(tuple2);
                int rank = tuple2._1$mcI$sp();
                int innerRank = tuple2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(rank, innerRank);
                int rank2 = sp3._1$mcI$sp();
                int innerRank2 = sp3._2$mcI$sp();
                this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), innerRank2, true));
                this.retract(out, oldRow.row(), rank2);
                this.collect(out, inputRow, rank2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            Tuple2<Object, Object> tuple2 = this.rowNumber(oldSortKey, rowKey, this.sortedMap());
            if (tuple2 == null) throw new MatchError(tuple2);
            int oldRank2 = n = (oldRank = tuple2._1$mcI$sp());
            this.sortedMap().remove(oldSortKey, rowKey);
            int size = this.sortedMap().put(sortKey, rowKey);
            this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), size, true));
            this.updateInnerRank(oldSortKey);
            SqlKind sqlKind = this.rankKind;
            if (!((Object)((Object)SqlKind.ROW_NUMBER)).equals((Object)sqlKind)) throw Predef$.MODULE$.$qmark$qmark$qmark();
            this.emitRecordsWithRowNumber(sortKey, inputRow, out, oldSortKey, oldRow, oldRank2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            if (!this.checkSortKeyInBufferRange(sortKey, this.sortedMap(), this.sortKeyComparator())) return;
            int size = this.sortedMap().put(sortKey, rowKey);
            this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), size, true));
            SqlKind sqlKind = this.rankKind;
            if (!((Object)((Object)SqlKind.ROW_NUMBER)).equals((Object)sqlKind)) throw Predef$.MODULE$.$qmark$qmark$qmark();
            this.emitRecordsWithRowNumber(sortKey, inputRow, out, this.emitRecordsWithRowNumber$default$4(), this.emitRecordsWithRowNumber$default$5(), this.emitRecordsWithRowNumber$default$6());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void processElementWithoutRowNumber(BaseRow inputRow, Collector<BaseRow> out) {
        BaseRow sortKey = this.sortKeySelector.getKey(inputRow);
        BaseRow rowKey = this.rowKeySelector.getKey(inputRow);
        if (this.rowKeyMap().containsKey(rowKey)) {
            AbstractUpdateRankFunction.RankRow rankRow;
            AbstractUpdateRankFunction.RankRow oldRow = this.rowKeyMap().get(rowKey);
            BaseRow oldSortKey = this.sortKeySelector.getKey(oldRow.row());
            if (oldSortKey.equals(sortKey)) {
                rankRow = this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), oldRow.innerRank(), true));
            } else {
                this.sortedMap().remove(oldSortKey, rowKey);
                int size = this.sortedMap().put(sortKey, rowKey);
                this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), size, true));
                this.updateInnerRank(oldSortKey);
                rankRow = BoxedUnit.UNIT;
            }
            this.retract(out, oldRow.row(), oldRow.innerRank());
            this.collect(out, inputRow);
        } else if (this.checkSortKeyInBufferRange(sortKey, this.sortedMap(), this.sortKeyComparator())) {
            BaseRow lastRowKey;
            int size = this.sortedMap().put(sortKey, rowKey);
            this.rowKeyMap().put(rowKey, this.RankRow().apply(this.inputRowSer().copy(inputRow), size, true));
            this.collect(out, inputRow);
            if ((long)this.sortedMap().getCurrentTopNum() > this.rankEnd() && (lastRowKey = this.sortedMap().removeLast()) != null) {
                AbstractUpdateRankFunction.RankRow lastRow = this.rowKeyMap().remove(lastRowKey);
                this.dataState().remove((Object)this.executionContext.currentKey(), (Object)lastRowKey);
                this.delete(out, lastRow.row());
            }
        }
    }

    public void emitRecordsWithRowNumber(BaseRow sortKey, BaseRow inputRow, Collector<BaseRow> out, BaseRow oldSortKey, AbstractUpdateRankFunction.RankRow oldRow, int oldRank) {
        int oldInnerRank = oldRow == null ? -1 : oldRow.innerRank();
        Iterator<Map.Entry<BaseRow, Collection<BaseRow>>> iterator = this.sortedMap().entrySet().iterator();
        int curRank = 0;
        boolean findSortKey = false;
        while (iterator.hasNext() && this.isInRankEnd(curRank + 1)) {
            Map.Entry<BaseRow, Collection<BaseRow>> entry = iterator.next();
            BaseRow curKey = entry.getKey();
            Collection<BaseRow> rowKeys = entry.getValue();
            if (!findSortKey && curKey.equals(sortKey)) {
                curRank += rowKeys.size();
                if (oldRow != null) {
                    this.retract(out, oldRow.row(), oldRank);
                }
                this.collect(out, inputRow, curRank);
                findSortKey = true;
                continue;
            }
            if (findSortKey) {
                if (oldSortKey == null) {
                    Iterator<BaseRow> rowKeyIter = rowKeys.iterator();
                    while (rowKeyIter.hasNext() && this.isInRankEnd(curRank + 1)) {
                        BaseRow rowKey = rowKeyIter.next();
                        AbstractUpdateRankFunction.RankRow prevRow = this.rowKeyMap().get(rowKey);
                        this.retract(out, prevRow.row(), ++curRank - 1);
                        this.collect(out, prevRow.row(), curRank);
                    }
                    continue;
                }
                int compare = this.sortKeyComparator().compare(curKey, oldSortKey);
                if (compare <= 0) {
                    Iterator<BaseRow> rowKeyIter = rowKeys.iterator();
                    int curInnerRank = 0;
                    while (rowKeyIter.hasNext() && this.isInRankEnd(curRank + 1)) {
                        ++curRank;
                        if (compare == 0 && ++curInnerRank >= oldInnerRank) {
                            return;
                        }
                        BaseRow rowKey = rowKeyIter.next();
                        AbstractUpdateRankFunction.RankRow prevRow = this.rowKeyMap().get(rowKey);
                        this.retract(out, prevRow.row(), curRank - 1);
                        this.collect(out, prevRow.row(), curRank);
                    }
                    continue;
                }
                return;
            }
            curRank += rowKeys.size();
        }
        while (iterator.hasNext()) {
            Map.Entry<BaseRow, Collection<BaseRow>> entry = iterator.next();
            Collection<BaseRow> rowkeys = entry.getValue();
            for (BaseRow rowkey : rowkeys) {
                this.rowKeyMap().remove(rowkey);
                this.dataState().remove((Object)this.executionContext.currentKey(), (Object)rowkey);
            }
            SortedMap<BaseRow> sortedMap = this.sortedMap();
            sortedMap.currentTopNum_$eq(sortedMap.currentTopNum() - entry.getValue().size());
            iterator.remove();
        }
    }

    public BaseRow emitRecordsWithRowNumber$default$4() {
        return null;
    }

    public AbstractUpdateRankFunction.RankRow emitRecordsWithRowNumber$default$5() {
        return null;
    }

    public int emitRecordsWithRowNumber$default$6() {
        return -1;
    }

    @Override
    public long getMaxSortMapSize() {
        return this.getDefaultTopSize();
    }

    public UpdateRankFunction(BaseRowTypeInfo inputRowType, BaseRowTypeInfo rowKeyType, KeySelector<BaseRow, BaseRow> rowKeySelector, GeneratedSorter gSorter, KeySelector<BaseRow, BaseRow> sortKeySelector, int outputArity, SqlKind rankKind, RankRange rankRange, long cacheSize, boolean generateRetraction, TableConfig tableConfig) {
        this.rowKeySelector = rowKeySelector;
        this.sortKeySelector = sortKeySelector;
        this.rankKind = rankKind;
        super(inputRowType, rowKeyType, gSorter, sortKeySelector, outputArity, rankRange, cacheSize, generateRetraction, tableConfig);
        this.inputRowSer = inputRowType.createSerializer();
    }
}

