/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.ChannelReaderInputViewIterator;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.sort.AbstractBinaryExternalMerger;
import org.apache.flink.table.runtime.sort.RecordComparator;
import org.apache.flink.table.runtime.sort.SpillChannelManager;
import org.apache.flink.table.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryExternalMerger
extends AbstractBinaryExternalMerger<BinaryRow> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryExternalMerger.class);
    private final BinaryRowSerializer serializer;
    private final RecordComparator comparator;

    public BinaryExternalMerger(IOManager ioManager, int pageSize, int maxFanIn, SpillChannelManager channelManager, BinaryRowSerializer serializer, RecordComparator comparator, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(ioManager, pageSize, maxFanIn, channelManager, compressionEnable, compressionCodecFactory, compressionBlockSize);
        this.serializer = serializer;
        this.comparator = comparator;
    }

    @Override
    protected MutableObjectIterator<BinaryRow> channelReaderInputViewIterator(AbstractChannelReaderInputView inView) {
        return new ChannelReaderInputViewIterator(inView, null, this.serializer.duplicate());
    }

    @Override
    protected Comparator<BinaryRow> mergeComparator() {
        return (o1, o2) -> this.comparator.compare((BaseRow)o1, (BaseRow)o2);
    }

    @Override
    protected List<BinaryRow> mergeReusedEntries(int size) {
        ArrayList<BinaryRow> reused = new ArrayList<BinaryRow>(size);
        for (int i = 0; i < size; ++i) {
            reused.add(this.serializer.createInstance());
        }
        return reused;
    }

    @Override
    protected void writeMergingOutput(MutableObjectIterator<BinaryRow> mergeIterator, AbstractPagedOutputView output2) throws IOException {
        BinaryRow rec = this.serializer.createInstance();
        while ((rec = mergeIterator.next(rec)) != null) {
            this.serializer.serialize(rec, (DataOutputView)output2);
        }
    }
}

