/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sort;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.keyed.KeyedListState;
import org.apache.flink.runtime.state.keyed.KeyedListStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedValueState;
import org.apache.flink.runtime.state.keyed.KeyedValueStateDescriptor;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.sort.SortBaseOperator;
import org.apache.flink.table.typeutils.AbstractRowSerializer;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001=\u0011qc\u00148msJ{w\u000fV5nKN{'\u000f^(qKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001B:peRT!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tT_J$()Y:f\u001fB,'/\u0019;pe\"AQ\u0003\u0001BC\u0002\u0013%a#\u0001\u0007j]B,HOU8x)f\u0004X-F\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQb!A\u0005usB,W\u000f^5mg&\u0011A$\u0007\u0002\u0010\u0005\u0006\u001cXMU8x)f\u0004X-\u00138g_\"Aa\u0004\u0001B\u0001B\u0003%q#A\u0007j]B,HOU8x)f\u0004X\r\t\u0005\tA\u0001\u0011)\u0019!C\u0005C\u0005Q!o\\<uS6,\u0017\n\u001a=\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011!I\u0003A!A!\u0002\u0013\u0011\u0013a\u0003:poRLW.Z%eq\u0002BQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDcA\u0017/_A\u0011\u0011\u0003\u0001\u0005\u0006+)\u0002\ra\u0006\u0005\u0006A)\u0002\rA\t\u0005\nc\u0001\u0001\r\u00111A\u0005\nI\nQ\u0002^5nK2K7\u000f^*uCR,W#A\u001a\u0011\tQRD\bR\u0007\u0002k)\u0011agN\u0001\u0006W\u0016LX\r\u001a\u0006\u0003qe\nQa\u001d;bi\u0016T!!\u0002\u0005\n\u0005m*$AD&fs\u0016$G*[:u'R\fG/\u001a\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000bA\u0001\\1oO*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005\u0011auN\\4\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d3\u0011A\u00033bi\u00064wN]7bi&\u0011\u0011J\u0012\u0002\b\u0005\u0006\u001cXMU8x\u0011%Y\u0005\u00011AA\u0002\u0013%A*A\tuS6,G*[:u'R\fG/Z0%KF$\"!\u0014)\u0011\u0005\rr\u0015BA(%\u0005\u0011)f.\u001b;\t\u000fES\u0015\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\t\rM\u0003\u0001\u0015)\u00034\u00039!\u0018.\\3MSN$8\u000b^1uK\u0002B#AU+\u0011\u0005\r2\u0016BA,%\u0005%!(/\u00198tS\u0016tG\u000fC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\u0006)B.Y:u)JLwmZ3sS:<Gk]*uCR,W#A.\u0011\tQbf\fP\u0005\u0003;V\u0012qbS3zK\u00124\u0016\r\\;f'R\fG/\u001a\t\u0003?\u0002l\u0011aN\u0005\u0003C^\u0012QBV8jI:\u000bW.Z:qC\u000e,\u0007\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003e\u0003ea\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016|F%Z9\u0015\u00055+\u0007bB)c\u0003\u0003\u0005\ra\u0017\u0005\u0007O\u0002\u0001\u000b\u0015B.\u0002-1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK\u0002B#AZ+\t\u000b)\u0004A\u0011I6\u0002\t=\u0004XM\u001c\u000b\u0002\u001b\")Q\u000e\u0001C!]\u0006q\u0001O]8dKN\u001cX\t\\3nK:$HCA'p\u0011\u0015\u0001H\u000e1\u0001r\u0003\tIg\u000eE\u0002sq\u0012k\u0011a\u001d\u0006\u0003iV\fAb\u001d;sK\u0006l'/Z2pe\u0012T!!\u0002<\u000b\u0005]D\u0011!C:ue\u0016\fW.\u001b8h\u0013\tI8O\u0001\u0007TiJ,\u0017-\u001c*fG>\u0014H\rC\u0003|\u0001\u0011\u0005C0A\u0006p]\u00163XM\u001c;US6,GCA'~\u0011\u0015q(\u00101\u0001\u0000\u0003\u0015!\u0018.\\3s!\u0019\t\t!a\u0003E=6\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!A\u0005pa\u0016\u0014\u0018\r^8sg*\u0019\u0011\u0011\u0002<\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u000e\u0005\r!!D%oi\u0016\u0014h.\u00197US6,'\u000f\u0003\u0004\u0002\u0012\u0001!\te[\u0001\tK:$\u0017J\u001c9vi\u0002")
public class OnlyRowTimeSortOperator
extends SortBaseOperator {
    private final BaseRowTypeInfo inputRowType;
    private final int rowtimeIdx;
    private transient KeyedListState<Long, BaseRow> timeListState;
    private transient KeyedValueState<VoidNamespace, Long> lastTriggeringTsState;

    private BaseRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private KeyedListState<Long, BaseRow> timeListState() {
        return this.timeListState;
    }

    private void timeListState_$eq(KeyedListState<Long, BaseRow> x$1) {
        this.timeListState = x$1;
    }

    private KeyedValueState<VoidNamespace, Long> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(KeyedValueState<VoidNamespace, Long> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    @Override
    public void open() {
        super.open();
        AbstractRowSerializer<BaseRow> recordSerializer = this.inputRowType().createSerializer();
        KeyedListStateDescriptor timeListStateDescriptor = new KeyedListStateDescriptor("timeListState", (TypeSerializer)LongSerializer.INSTANCE, recordSerializer);
        this.timeListState_$eq((KeyedListState<Long, BaseRow>)((KeyedListState)this.getKeyedState((KeyedStateDescriptor)timeListStateDescriptor)));
        KeyedValueStateDescriptor lastTriggeringTsDescriptor = new KeyedValueStateDescriptor("lastTriggeringTsState", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE);
        this.lastTriggeringTsState_$eq((KeyedValueState<VoidNamespace, Long>)((KeyedValueState)this.getKeyedState((KeyedStateDescriptor)lastTriggeringTsDescriptor)));
    }

    public void processElement(StreamRecord<BaseRow> in) {
        BaseRow input = (BaseRow)in.getValue();
        long rowTime = input.getLong(this.rowtimeIdx());
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState().get((Object)VoidNamespace.INSTANCE);
        if (lastTriggeringTs == null || rowTime > Predef$.MODULE$.Long2long(lastTriggeringTs)) {
            this.timeListState().add((Object)Predef$.MODULE$.long2Long(rowTime), (Object)input);
            this.timerService().registerEventTimeTimer(rowTime);
        }
    }

    @Override
    public void onEventTime(InternalTimer<BaseRow, VoidNamespace> timer) {
        long timestamp = timer.getTimestamp();
        Iterator itr = ((List)this.timeListState().get((Object)Predef$.MODULE$.long2Long(timestamp))).iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                this.collector().collect(itr.next());
            }
            this.timeListState().remove((Object)Predef$.MODULE$.long2Long(timestamp));
            this.lastTriggeringTsState().put((Object)VoidNamespace.INSTANCE, (Object)Predef$.MODULE$.long2Long(timestamp));
        }
    }

    public void endInput() {
    }

    public OnlyRowTimeSortOperator(BaseRowTypeInfo inputRowType, int rowtimeIdx) {
        this.inputRowType = inputRowType;
        this.rowtimeIdx = rowtimeIdx;
    }
}

