/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.table.runtime.util.AbstractChannelWriterOutputView;

public final class CompressedHeaderlessChannelWriterOutputView
extends AbstractChannelWriterOutputView
implements BufferRecycler {
    private final MemorySegment buffer;
    private final LinkedBlockingQueue<MemorySegment> compressedBuffers = new LinkedBlockingQueue();
    private final AbstractBlockCompressor compressor;
    private final BufferFileWriter writer;
    private final int compressionBlockSize;
    private int blockCount;
    private long numBytes;
    private long numCompressedBytes;

    public CompressedHeaderlessChannelWriterOutputView(BufferFileWriter writer, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) throws IOException {
        super((FileIOChannel)writer, compressionBlockSize, 0);
        this.compressionBlockSize = compressionBlockSize;
        this.buffer = MemorySegmentFactory.wrap(new byte[compressionBlockSize]);
        this.compressor = compressionCodecFactory.getCompressor();
        for (int i = 0; i < 2; ++i) {
            this.compressedBuffers.add(MemorySegmentFactory.wrap(new byte[this.compressor.getMaxCompressedSize(compressionBlockSize)]));
        }
        this.writer = writer;
        try {
            this.advance();
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    @Override
    public int close() throws IOException {
        if (!this.writer.isClosed()) {
            int currentPositionInSegment = this.getCurrentPositionInSegment();
            this.writeCompressed(this.buffer, currentPositionInSegment);
            this.clear();
            this.writer.close();
        }
        return -1;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
        if (current != null) {
            this.writeCompressed(current, this.compressionBlockSize);
        }
        return this.buffer;
    }

    private void writeCompressed(MemorySegment current, int size) throws IOException {
        MemorySegment compressedBuffer;
        try {
            compressedBuffer = this.compressedBuffers.take();
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
        int compressedLen = this.compressor.compress(current.getArray(), 0, size, compressedBuffer.getArray(), 0);
        NetworkBuffer networkBuffer = new NetworkBuffer(compressedBuffer, (BufferRecycler)this);
        networkBuffer.setSize(compressedLen);
        this.writer.writeBlock((Object)networkBuffer);
        ++this.blockCount;
        this.numBytes += (long)size;
        this.numCompressedBytes += (long)compressedLen;
    }

    @Override
    public long getNumBytes() {
        return this.numBytes;
    }

    @Override
    public long getNumCompressedBytes() {
        return this.numCompressedBytes;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    public void recycle(MemorySegment memorySegment) {
        this.compressedBuffers.add(memorySegment);
    }
}

