/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.util.MutableObjectIterator;

public class PagedChannelReaderInputViewIterator<E>
implements MutableObjectIterator<E> {
    private final ChannelReaderInputView inView;
    private final TypeSerializer<E> accessors;
    private final List<MemorySegment> freeMemTarget;

    public PagedChannelReaderInputViewIterator(ChannelReaderInputView inView, TypeSerializer<E> accessors) {
        this(inView, new ArrayList<MemorySegment>(), accessors);
    }

    public PagedChannelReaderInputViewIterator(ChannelReaderInputView inView, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors) {
        this.inView = inView;
        this.freeMemTarget = freeMemTarget;
        this.accessors = accessors;
    }

    @Override
    public E next(E reuse) throws IOException {
        try {
            return this.accessors.deserializeFromPages(reuse, (AbstractPagedInputView)this.inView);
        }
        catch (EOFException eofex) {
            List freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }

    @Override
    public E next() throws IOException {
        try {
            return this.accessors.deserializeFromPages((AbstractPagedInputView)this.inView);
        }
        catch (EOFException eofex) {
            List freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }
}

