/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window;

import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.dropwizard.metrics.DropwizardMeterWrapper;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.keyed.KeyedState;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedStateDescriptor;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedValueStateDescriptor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.codegen.GeneratedRecordEqualiser;
import org.apache.flink.table.codegen.GeneratedSubKeyedAggsHandleFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.functions.ExecutionContextImpl;
import org.apache.flink.table.runtime.functions.SubKeyedAggsHandleFunction;
import org.apache.flink.table.runtime.sort.RecordEqualiser;
import org.apache.flink.table.runtime.window.assigners.MergingWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.PanedWindowAssigner;
import org.apache.flink.table.runtime.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.window.internal.GeneralWindowProcessFunction;
import org.apache.flink.table.runtime.window.internal.InternalWindowProcessFunction;
import org.apache.flink.table.runtime.window.internal.MergingWindowProcessFunction;
import org.apache.flink.table.runtime.window.internal.PanedWindowProcessFunction;
import org.apache.flink.table.runtime.window.triggers.Trigger;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.util.Preconditions;

public class WindowOperator<K, W extends Window>
extends AbstractStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow>,
Triggerable<K, W> {
    private static final long serialVersionUID = 1L;
    private static final String LATE_ELEMENTS_DROPPED_METRIC_NAME = "numLateRecordsDropped";
    private static final String LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "lateRecordsDroppedRate";
    private static final String WATERMARK_LATENCY_METRIC_NAME = "watermarkLatency";
    private final WindowAssigner<W> windowAssigner;
    private final Trigger<W> trigger;
    private final TypeSerializer<W> windowSerializer;
    private TypeSerializer<K> keySerializer;
    private final boolean sendRetraction;
    private final InternalType[] inputFieldTypes;
    private final InternalType[] accumulatorTypes;
    private final InternalType[] aggResultTypes;
    private final InternalType[] windowPropertyTypes;
    private final int rowtimeIndex;
    private final long allowedLateness;
    private SubKeyedAggsHandleFunction<W> windowAggregator;
    private GeneratedSubKeyedAggsHandleFunction<W> generatedWindowAggregator;
    private RecordEqualiser equaliser;
    private GeneratedRecordEqualiser generatedEqualiser;
    private transient InternalWindowProcessFunction<K, W> windowFunction;
    private transient TimestampedCollector<BaseRow> collector;
    private transient boolean functionsClosed = false;
    private transient Counter numLateRecordsDropped;
    private transient Meter lateRecordsDroppedRate;
    private transient Gauge<Long> watermarkLatency;
    private transient InternalTimerService<W> internalTimerService;
    private transient SubKeyedValueState<K, W, BaseRow> windowState;
    private transient SubKeyedValueState<K, W, BaseRow> previousState;
    private transient TriggerContext triggerContext;
    private transient JoinedRow reuseOutput;

    WindowOperator(SubKeyedAggsHandleFunction<W> windowAggregator, RecordEqualiser equaliser, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, InternalType[] inputFieldTypes, InternalType[] accumulatorTypes, InternalType[] aggResultTypes, InternalType[] windowPropertyTypes, int rowtimeIndex, boolean sendRetraction, long allowedLateness) {
        Preconditions.checkArgument(allowedLateness >= 0L);
        this.windowAggregator = Preconditions.checkNotNull(windowAggregator);
        this.equaliser = Preconditions.checkNotNull(equaliser);
        this.windowAssigner = Preconditions.checkNotNull(windowAssigner);
        this.trigger = Preconditions.checkNotNull(trigger);
        this.windowSerializer = Preconditions.checkNotNull(windowSerializer);
        this.inputFieldTypes = Preconditions.checkNotNull(inputFieldTypes);
        this.accumulatorTypes = Preconditions.checkNotNull(accumulatorTypes);
        this.aggResultTypes = Preconditions.checkNotNull(aggResultTypes);
        this.windowPropertyTypes = Preconditions.checkNotNull(windowPropertyTypes);
        this.allowedLateness = allowedLateness;
        this.sendRetraction = sendRetraction;
        Preconditions.checkArgument(!windowAssigner.isEventTime() || rowtimeIndex >= 0);
        this.rowtimeIndex = rowtimeIndex;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    WindowOperator(GeneratedSubKeyedAggsHandleFunction<W> generatedWindowAggregator, GeneratedRecordEqualiser generatedEqualiser, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, InternalType[] inputFieldTypes, InternalType[] accumulatorTypes, InternalType[] aggResultTypes, InternalType[] windowPropertyTypes, int rowtimeIndex, boolean sendRetraction, long allowedLateness) {
        Preconditions.checkArgument(allowedLateness >= 0L);
        this.generatedWindowAggregator = Preconditions.checkNotNull(generatedWindowAggregator);
        this.generatedEqualiser = Preconditions.checkNotNull(generatedEqualiser);
        this.windowAssigner = Preconditions.checkNotNull(windowAssigner);
        this.trigger = Preconditions.checkNotNull(trigger);
        this.windowSerializer = Preconditions.checkNotNull(windowSerializer);
        this.inputFieldTypes = Preconditions.checkNotNull(inputFieldTypes);
        this.accumulatorTypes = Preconditions.checkNotNull(accumulatorTypes);
        this.aggResultTypes = Preconditions.checkNotNull(aggResultTypes);
        this.windowPropertyTypes = Preconditions.checkNotNull(windowPropertyTypes);
        this.allowedLateness = allowedLateness;
        this.sendRetraction = sendRetraction;
        Preconditions.checkArgument(!windowAssigner.isEventTime() || rowtimeIndex >= 0);
        this.rowtimeIndex = rowtimeIndex;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() throws Exception {
        super.open();
        this.keySerializer = this.getKeySerializer();
        this.collector = new TimestampedCollector(this.output);
        this.collector.eraseTimestamp();
        this.internalTimerService = this.getInternalTimerService("window-timers", this.windowSerializer, this);
        this.triggerContext = new TriggerContext();
        this.triggerContext.open();
        RowType accTypeInfo = new RowType((DataType[])this.accumulatorTypes);
        SubKeyedValueStateDescriptor windowStateDescriptor = new SubKeyedValueStateDescriptor("window-aggs", this.keySerializer, this.windowSerializer, DataTypes.createInternalSerializer(accTypeInfo));
        this.windowState = (SubKeyedValueState)this.getSubKeyedState((SubKeyedStateDescriptor)windowStateDescriptor);
        if (this.sendRetraction) {
            DataType[] valueTypes = (InternalType[])ArrayUtils.addAll((Object[])this.aggResultTypes, (Object[])this.windowPropertyTypes);
            RowType prevAggResultType = new RowType(valueTypes);
            SubKeyedValueStateDescriptor previousStateDescriptor = new SubKeyedValueStateDescriptor("previous-aggs", this.keySerializer, this.windowSerializer, DataTypes.createInternalSerializer(prevAggResultType));
            this.previousState = (SubKeyedValueState)this.getSubKeyedState((SubKeyedStateDescriptor)previousStateDescriptor);
        }
        if (this.generatedWindowAggregator != null) {
            this.windowAggregator = (SubKeyedAggsHandleFunction)this.generatedWindowAggregator.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        }
        if (this.generatedEqualiser != null) {
            this.equaliser = (RecordEqualiser)this.generatedEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        }
        WindowContext windowContext = new WindowContext();
        this.windowAggregator.open(new ExecutionContextImpl(this, (RuntimeContext)this.getRuntimeContext(), this.windowSerializer));
        this.windowFunction = this.windowAssigner instanceof MergingWindowAssigner ? new MergingWindowProcessFunction<K, W>((MergingWindowAssigner)this.windowAssigner, this.windowAggregator, this.keySerializer, this.windowSerializer, this.allowedLateness) : (this.windowAssigner instanceof PanedWindowAssigner ? new PanedWindowProcessFunction((PanedWindowAssigner)this.windowAssigner, this.windowAggregator, this.allowedLateness) : new GeneralWindowProcessFunction(this.windowAssigner, this.windowAggregator, this.allowedLateness));
        this.windowFunction.open(windowContext);
        this.reuseOutput = new JoinedRow();
        this.numLateRecordsDropped = this.metrics.counter(LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.lateRecordsDroppedRate = this.metrics.meter(LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new DropwizardMeterWrapper(new com.codahale.metrics.Meter()));
        this.watermarkLatency = this.metrics.gauge(WATERMARK_LATENCY_METRIC_NAME, () -> {
            long watermark = this.internalTimerService.currentWatermark();
            if (watermark < 0L) {
                return 0L;
            }
            return this.internalTimerService.currentProcessingTime() - watermark;
        });
    }

    public void close() throws Exception {
        super.close();
        this.collector = null;
        this.triggerContext = null;
        this.functionsClosed = true;
        this.windowAggregator.close();
    }

    public void dispose() throws Exception {
        super.dispose();
        this.collector = null;
        this.triggerContext = null;
        if (!this.functionsClosed) {
            this.functionsClosed = true;
            this.windowAggregator.close();
        }
    }

    public void processElement(StreamRecord<BaseRow> record) throws Exception {
        GenericRow inputRow = BaseRowUtil.toGenericRow((BaseRow)record.getValue(), this.inputFieldTypes);
        long timestamp = this.windowAssigner.isEventTime() ? inputRow.getLong(this.rowtimeIndex) : this.internalTimerService.currentProcessingTime();
        Collection<W> affectedWindows = this.windowFunction.assignStateNamespace(inputRow, timestamp);
        boolean isElementDropped = true;
        for (Window window : affectedWindows) {
            isElementDropped = false;
            BaseRow acc = (BaseRow)this.windowState.get(this.currentKey(), (Object)window);
            if (acc == null) {
                acc = this.windowAggregator.createAccumulators();
            }
            this.windowAggregator.setAccumulators(window, acc);
            if (BaseRowUtil.isAccumulateMsg(inputRow)) {
                this.windowAggregator.accumulate(inputRow);
            } else {
                this.windowAggregator.retract(inputRow);
            }
            acc = this.windowAggregator.getAccumulators();
            this.windowState.put(this.currentKey(), (Object)window, (Object)acc);
        }
        Collection<W> actualWindows = this.windowFunction.assignActualWindows(inputRow, timestamp);
        for (Window window : actualWindows) {
            isElementDropped = false;
            this.triggerContext.window = window;
            boolean triggerResult = this.triggerContext.onElement(inputRow, timestamp);
            if (triggerResult) {
                this.emitWindowResult(window);
            }
            this.registerCleanupTimer(window);
        }
        if (isElementDropped) {
            this.numLateRecordsDropped.inc();
            this.lateRecordsDroppedRate.markEvent();
        }
    }

    public void onEventTime(InternalTimer<K, W> timer) throws Exception {
        this.setCurrentKey(timer.getKey());
        this.triggerContext.window = (Window)timer.getNamespace();
        if (this.triggerContext.onEventTime(timer.getTimestamp())) {
            this.emitWindowResult(this.triggerContext.window);
        }
        if (this.windowAssigner.isEventTime()) {
            this.windowFunction.cleanWindowIfNeeded(this.triggerContext.window, timer.getTimestamp());
        }
    }

    public void onProcessingTime(InternalTimer<K, W> timer) throws Exception {
        this.setCurrentKey(timer.getKey());
        this.triggerContext.window = (Window)timer.getNamespace();
        if (this.triggerContext.onProcessingTime(timer.getTimestamp())) {
            this.emitWindowResult(this.triggerContext.window);
        }
        if (!this.windowAssigner.isEventTime()) {
            this.windowFunction.cleanWindowIfNeeded(this.triggerContext.window, timer.getTimestamp());
        }
    }

    private void emitWindowResult(W window) throws Exception {
        BaseRow aggResult = this.windowFunction.getWindowAggregationResult(window);
        if (this.sendRetraction) {
            BaseRow previousAggResult = (BaseRow)this.previousState.get(this.currentKey(), window);
            if (previousAggResult != null) {
                if (!this.equaliser.equalsWithoutHeader(aggResult, previousAggResult)) {
                    this.reuseOutput.replace((BaseRow)this.getCurrentKey(), previousAggResult);
                    BaseRowUtil.setRetract(this.reuseOutput);
                    this.collector.collect((Object)this.reuseOutput);
                    this.reuseOutput.replace((BaseRow)this.getCurrentKey(), aggResult);
                    BaseRowUtil.setAccumulate(this.reuseOutput);
                    this.collector.collect((Object)this.reuseOutput);
                    this.previousState.put(this.currentKey(), window, (Object)aggResult);
                }
            } else {
                this.reuseOutput.replace((BaseRow)this.getCurrentKey(), aggResult);
                BaseRowUtil.setAccumulate(this.reuseOutput);
                this.collector.collect((Object)this.reuseOutput);
                this.previousState.put(this.currentKey(), window, (Object)aggResult);
            }
        } else {
            this.reuseOutput.replace((BaseRow)this.getCurrentKey(), aggResult);
            this.collector.collect((Object)this.reuseOutput);
        }
    }

    public void endInput() throws Exception {
    }

    private void registerCleanupTimer(W window) {
        long cleanupTime = this.cleanupTime(window);
        if (cleanupTime == Long.MAX_VALUE) {
            return;
        }
        if (this.windowAssigner.isEventTime()) {
            this.triggerContext.registerEventTimeTimer(cleanupTime);
        } else {
            this.triggerContext.registerProcessingTimeTimer(cleanupTime);
        }
    }

    private long cleanupTime(W window) {
        if (this.windowAssigner.isEventTime()) {
            long cleanupTime = Math.max(0L, ((Window)window).maxTimestamp() + this.allowedLateness);
            return cleanupTime >= ((Window)window).maxTimestamp() ? cleanupTime : Long.MAX_VALUE;
        }
        return Math.max(0L, ((Window)window).maxTimestamp());
    }

    private K currentKey() {
        return (K)this.getCurrentKey();
    }

    protected Counter getNumLateRecordsDropped() {
        return this.numLateRecordsDropped;
    }

    protected Gauge<Long> getWatermarkLatency() {
        return this.watermarkLatency;
    }

    public boolean requireState() {
        return true;
    }

    private class WindowScopeValueState<T>
    implements ValueState<T> {
        private final SubKeyedValueState<K, W, T> keyedState;

        private WindowScopeValueState(SubKeyedValueState<K, W, T> keyedState) {
            this.keyedState = keyedState;
        }

        @Override
        public T value() {
            return (T)this.keyedState.get(WindowOperator.this.currentKey(), ((WindowOperator)WindowOperator.this).triggerContext.window);
        }

        @Override
        public void update(T value) {
            this.keyedState.put(WindowOperator.this.currentKey(), ((WindowOperator)WindowOperator.this).triggerContext.window, value);
        }

        @Override
        public void clear() {
            this.keyedState.remove(WindowOperator.this.currentKey(), ((WindowOperator)WindowOperator.this).triggerContext.window);
        }
    }

    private class TriggerContext
    implements Trigger.OnMergeContext {
        protected W window;
        protected Collection<W> mergedWindows;

        private TriggerContext() {
        }

        public void open() throws Exception {
            WindowOperator.this.trigger.open(this);
        }

        public boolean onElement(BaseRow row2, long timestamp) throws Exception {
            return WindowOperator.this.trigger.onElement(row2, timestamp, this.window);
        }

        public boolean onProcessingTime(long time) throws Exception {
            return WindowOperator.this.trigger.onProcessingTime(time, this.window);
        }

        public boolean onEventTime(long time) throws Exception {
            return WindowOperator.this.trigger.onEventTime(time, this.window);
        }

        public void onMerge() throws Exception {
            WindowOperator.this.trigger.onMerge(this.window, this);
        }

        @Override
        public <T> ValueState<T> getValueState(ValueStateDescriptor<T> stateDescriptor) throws Exception {
            stateDescriptor.initializeSerializerUnlessSet(new ExecutionConfig());
            SubKeyedValueStateDescriptor descriptor = new SubKeyedValueStateDescriptor(stateDescriptor.getName(), WindowOperator.this.keySerializer, WindowOperator.this.windowSerializer, stateDescriptor.getSerializer());
            SubKeyedValueState valueState = (SubKeyedValueState)WindowOperator.this.getSubKeyedState((SubKeyedStateDescriptor)descriptor);
            return new WindowScopeValueState(valueState);
        }

        @Override
        public <T> T mergeValueState(ValueState<T> state, Merger<T> merger) {
            SubKeyedValueState keyedState = ((WindowScopeValueState)state).keyedState;
            if (this.mergedWindows != null && this.mergedWindows.size() > 0) {
                Object targetValue = keyedState.get(WindowOperator.this.currentKey(), this.window);
                for (Window mergedWindow : this.mergedWindows) {
                    Object value = keyedState.get(WindowOperator.this.currentKey(), (Object)mergedWindow);
                    targetValue = merger.merge(targetValue, value);
                }
                keyedState.put(WindowOperator.this.currentKey(), this.window, targetValue);
                return (T)targetValue;
            }
            return null;
        }

        @Override
        public long getCurrentProcessingTime() {
            return WindowOperator.this.internalTimerService.currentProcessingTime();
        }

        @Override
        public long getCurrentWatermark() {
            return WindowOperator.this.internalTimerService.currentWatermark();
        }

        @Override
        public MetricGroup getMetricGroup() {
            return WindowOperator.this.getMetricGroup();
        }

        @Override
        public void registerProcessingTimeTimer(long time) {
            WindowOperator.this.internalTimerService.registerProcessingTimeTimer(this.window, time);
        }

        @Override
        public void registerEventTimeTimer(long time) {
            WindowOperator.this.internalTimerService.registerEventTimeTimer(this.window, time);
        }

        @Override
        public void deleteProcessingTimeTimer(long time) {
            WindowOperator.this.internalTimerService.deleteProcessingTimeTimer(this.window, time);
        }

        @Override
        public void deleteEventTimeTimer(long time) {
            WindowOperator.this.internalTimerService.deleteEventTimeTimer(this.window, time);
        }

        public void clear() throws Exception {
            WindowOperator.this.trigger.clear(this.window);
        }
    }

    private class WindowContext
    implements InternalWindowProcessFunction.Context<K, W> {
        private WindowContext() {
        }

        @Override
        public <S extends State> S getKeyedState(StateDescriptor<S, ?> stateDescriptor) throws Exception {
            return (S)WindowOperator.this.getPartitionedState(stateDescriptor);
        }

        @Override
        public <V, S extends SubKeyedState<K, W, V>> S getSubKeyedState(SubKeyedStateDescriptor<K, W, V, S> descriptor) throws Exception {
            return (S)WindowOperator.this.getSubKeyedState(descriptor);
        }

        @Override
        public <V, S extends KeyedState<K, V>> S getKeyedState(KeyedStateDescriptor<K, V, S> descriptor) throws Exception {
            return (S)WindowOperator.this.getKeyedState(descriptor);
        }

        @Override
        public K currentKey() {
            return WindowOperator.this.currentKey();
        }

        @Override
        public long currentProcessingTime() {
            return WindowOperator.this.internalTimerService.currentProcessingTime();
        }

        @Override
        public long currentWatermark() {
            return WindowOperator.this.internalTimerService.currentWatermark();
        }

        @Override
        public BaseRow getWindowAccumulators(W window) throws Exception {
            return (BaseRow)WindowOperator.this.windowState.get(this.currentKey(), window);
        }

        @Override
        public void setWindowAccumulators(W window, BaseRow acc) throws Exception {
            WindowOperator.this.windowState.put(this.currentKey(), window, (Object)acc);
        }

        @Override
        public void clearWindowState(W window) throws Exception {
            WindowOperator.this.windowState.remove(this.currentKey(), window);
            WindowOperator.this.windowAggregator.cleanup(window);
        }

        @Override
        public void clearPreviousState(W window) throws Exception {
            if (WindowOperator.this.previousState != null) {
                WindowOperator.this.previousState.remove(this.currentKey(), window);
            }
        }

        @Override
        public void clearTrigger(W window) throws Exception {
            ((WindowOperator)WindowOperator.this).triggerContext.window = window;
            WindowOperator.this.triggerContext.clear();
        }

        @Override
        public void deleteCleanupTimer(W window) throws Exception {
            long cleanupTime = WindowOperator.this.cleanupTime(window);
            if (cleanupTime == Long.MAX_VALUE) {
                return;
            }
            if (WindowOperator.this.windowAssigner.isEventTime()) {
                WindowOperator.this.triggerContext.deleteEventTimeTimer(cleanupTime);
            } else {
                WindowOperator.this.triggerContext.deleteProcessingTimeTimer(cleanupTime);
            }
        }

        @Override
        public void onMerge(W newWindow, Collection<W> mergedWindows) throws Exception {
            ((WindowOperator)WindowOperator.this).triggerContext.window = newWindow;
            ((WindowOperator)WindowOperator.this).triggerContext.mergedWindows = mergedWindows;
            WindowOperator.this.triggerContext.onMerge();
        }
    }
}

