/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.aligned;

import java.time.Duration;
import org.apache.flink.table.api.window.TimeWindow;
import org.apache.flink.table.runtime.window.aligned.AlignedWindowTrigger;

public class InternalAlignedWindowTriggers {
    public static AlignedWindowTrigger tumbling(Duration size, Duration offset) {
        return new TumblingTimeWindowTrigger(size.toMillis(), offset.toMillis());
    }

    public static AlignedWindowTrigger sliding(Duration size, Duration slide, Duration offset) {
        return new SlidingTimeWindowTrigger(size.toMillis(), slide.toMillis(), offset.toMillis());
    }

    private static final class SlidingTimeWindowTrigger
    implements AlignedWindowTrigger {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long slide;
        private final long offset;

        private SlidingTimeWindowTrigger(long size, long slide, long offset) {
            if (size % slide != 0L) {
                throw new IllegalArgumentException("SlidingAlignedEventTimeTrigger parameters must satisfy size % slide = 0");
            }
            this.size = size;
            this.slide = slide;
            this.offset = offset;
        }

        @Override
        public long nextTriggerTime(long clockTime) {
            long start = TimeWindow.getWindowStartWithOffset(clockTime, this.offset, this.slide);
            long max = start + this.slide - 1L;
            return max > clockTime ? max : max + this.slide;
        }

        @Override
        public TimeWindow nextTriggerWindow(long clockTime) {
            long maxTimestamp = this.nextTriggerTime(clockTime);
            long windowEnd = maxTimestamp + 1L;
            return new TimeWindow(windowEnd - this.size, windowEnd);
        }
    }

    private static final class TumblingTimeWindowTrigger
    implements AlignedWindowTrigger {
        private static final long serialVersionUID = 1L;
        private final long size;
        private final long offset;

        private TumblingTimeWindowTrigger(long size, long offset) {
            this.size = size;
            this.offset = offset;
        }

        @Override
        public long nextTriggerTime(long clockTime) {
            long start = TimeWindow.getWindowStartWithOffset(clockTime, this.offset, this.size);
            long max = start + this.size - 1L;
            return max > clockTime ? max : max + this.size;
        }

        @Override
        public TimeWindow nextTriggerWindow(long clockTime) {
            long maxTimestamp = this.nextTriggerTime(clockTime);
            long windowEnd = maxTimestamp + 1L;
            return new TimeWindow(windowEnd - this.size, windowEnd);
        }
    }
}

