/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.runtime.window.assigners.MergingWindowAssigner;
import org.apache.flink.table.util.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergingWindowSet<K, W extends Window> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingWindowSet.class);
    private static final int MAPPING_CACHE_SIZE = 10000;
    private final KeyedMapState<K, W, W> mapping;
    private final LRUMap<Object, TreeSet<W>> cachedSortedWindows;
    private TreeSet<W> sortedWindows;
    private K currentKey;
    private final MergingWindowAssigner<W> windowAssigner;

    public MergingWindowSet(MergingWindowAssigner<W> windowAssigner, KeyedMapState<K, W, W> mapping) {
        this.windowAssigner = windowAssigner;
        this.mapping = mapping;
        this.cachedSortedWindows = new LRUMap(10000);
    }

    public void initializeCache(K key) throws Exception {
        this.currentKey = key;
        this.sortedWindows = (TreeSet)this.cachedSortedWindows.get(key);
        if (this.sortedWindows == null) {
            this.sortedWindows = new TreeSet();
            Iterator keyValues = this.mapping.iterator(key);
            if (keyValues != null) {
                while (keyValues.hasNext()) {
                    Map.Entry keyValue = (Map.Entry)keyValues.next();
                    this.sortedWindows.add(keyValue.getKey());
                }
            }
            this.cachedSortedWindows.put(key, this.sortedWindows);
        }
    }

    public W getStateWindow(K key, W window) throws Exception {
        return (W)((Window)this.mapping.get(key, window));
    }

    public void retireWindow(K key, W window) throws Exception {
        assert (key == this.currentKey);
        this.mapping.remove(key, window);
        boolean removed = this.sortedWindows.remove(window);
        if (!removed) {
            throw new IllegalStateException("Window " + window + " is not in in-flight window set.");
        }
    }

    public W addWindow(K key, W newWindow, MergeFunction<W> mergeFunction) throws Exception {
        assert (key == this.currentKey);
        MergeResultCollector collector = new MergeResultCollector();
        this.windowAssigner.mergeWindows(newWindow, this.sortedWindows, collector);
        Object resultWindow = newWindow;
        boolean isNewWindowMerged = false;
        for (Map.Entry c : collector.mergeResults.entrySet()) {
            Window mergeResult = (Window)c.getKey();
            Collection mergedWindows = c.getValue();
            if (mergedWindows.remove(newWindow)) {
                isNewWindowMerged = true;
                resultWindow = mergeResult;
            }
            if (mergedWindows.isEmpty()) continue;
            Window mergedStateNamespace = (Window)this.mapping.get(key, mergedWindows.iterator().next());
            ArrayList<Window> mergedStateWindows = new ArrayList<Window>();
            for (Window mergedWindow : mergedWindows) {
                Window res = (Window)this.mapping.get(key, (Object)mergedWindow);
                if (res == null) continue;
                this.mapping.remove(key, (Object)mergedWindow);
                this.sortedWindows.remove(mergedWindow);
                if (res.equals(mergedStateNamespace)) continue;
                mergedStateWindows.add(res);
            }
            this.mapping.add(key, (Object)mergeResult, (Object)mergedStateNamespace);
            this.sortedWindows.add(mergeResult);
            if (mergedWindows.contains(mergeResult) && mergedWindows.size() == 1) continue;
            mergeFunction.merge(mergeResult, mergedWindows, mergedStateNamespace, mergedStateWindows);
        }
        if (collector.mergeResults.isEmpty() || ((Window)resultWindow).equals(newWindow) && !isNewWindowMerged) {
            this.mapping.add(key, resultWindow, resultWindow);
            this.sortedWindows.add(resultWindow);
        }
        return resultWindow;
    }

    public String toString() {
        return "MergingWindowSet{windows=" + this.mapping + '}';
    }

    public static interface MergeFunction<W> {
        public void merge(W var1, Collection<W> var2, W var3, Collection<W> var4) throws Exception;
    }

    private class MergeResultCollector
    implements MergingWindowAssigner.MergeCallback<W> {
        final Map<W, Collection<W>> mergeResults = new HashMap();

        private MergeResultCollector() {
        }

        @Override
        public void merge(W mergeResult, Collection<W> toBeMerged) {
            LOG.debug("Merging {} into {}", toBeMerged, mergeResult);
            this.mergeResults.put(mergeResult, toBeMerged);
        }
    }
}

