/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.triggers;

import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.runtime.window.triggers.Trigger;

public class Element {
    private static final SumMerger SUM_MERGER = new SumMerger();

    public static <W extends Window> EveryElement<W> every() {
        return new EveryElement();
    }

    public static <W extends Window> CountElement<W> count(long countElems) {
        return new CountElement(countElems);
    }

    private static final class SumMerger
    implements Merger<Long> {
        private static final long serialVersionUID = 438613147421589350L;

        private SumMerger() {
        }

        @Override
        public Long merge(Long value1, Long value2) {
            if (value1 == null || value2 == null) {
                return value1 == null ? value2 : value1;
            }
            return value1 + value2;
        }
    }

    public static final class CountElement<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -3823782971498746808L;
        private final long countElems;
        private transient ValueState<Long> count;

        CountElement(long countElems) {
            this.countElems = countElems;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            String descriptorName = "trigger-count-" + this.countElems;
            ValueStateDescriptor<Long> countDescriptor = new ValueStateDescriptor<Long>(descriptorName, Types.LONG);
            this.count = ctx.getValueState(countDescriptor);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            Long currentCount = this.count.value();
            long newCount = 1L;
            if (currentCount != null) {
                newCount += currentCount.longValue();
            }
            if (newCount >= this.countElems) {
                this.count.clear();
                return true;
            }
            this.count.update(newCount);
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
            this.count.clear();
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            mergeContext.mergeValueState(this.count, SUM_MERGER);
        }

        public String toString() {
            return "Element.count(" + this.countElems + ")";
        }
    }

    public static final class EveryElement<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = 3942805366646141029L;

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            return true;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public void clear(W window) throws Exception {
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
        }

        public String toString() {
            return "Element.every()";
        }
    }
}

