/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.triggers;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.window.Window;
import org.apache.flink.table.runtime.window.triggers.Element;
import org.apache.flink.table.runtime.window.triggers.Trigger;
import org.apache.flink.util.Preconditions;

public class EventTime {
    private static final String TO_STRING = "EventTime.afterEndOfWindow()";

    public static <W extends Window> AfterEndOfWindow<W> afterEndOfWindow() {
        return new AfterEndOfWindow();
    }

    public static final class AfterEndOfWindowNoLate<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -4334481808648361926L;
        private final Trigger<W> earlyTrigger;
        private Trigger.TriggerContext ctx;

        public Trigger<W> withLateFirings(Trigger<W> lateFirings) {
            Preconditions.checkNotNull(lateFirings);
            if (lateFirings instanceof Element.EveryElement) {
                return this;
            }
            return new AfterEndOfWindowEarlyAndLate<W>(this.earlyTrigger, lateFirings);
        }

        private AfterEndOfWindowNoLate(Trigger<W> earlyTrigger) {
            Preconditions.checkNotNull(earlyTrigger);
            this.earlyTrigger = earlyTrigger;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            this.earlyTrigger.open(ctx);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            if (((Window)window).maxTimestamp() <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
            return this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return time == ((Window)window).maxTimestamp() || this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return this.earlyTrigger.canMerge();
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
            this.earlyTrigger.onMerge(window, mergeContext);
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteEventTimeTimer(((Window)window).maxTimestamp());
            this.earlyTrigger.clear(window);
        }

        public String toString() {
            return "EventTime.afterEndOfWindow().withEarlyFirings(" + this.earlyTrigger + ")";
        }
    }

    public static final class AfterEndOfWindowEarlyAndLate<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -800582945577030338L;
        private final Trigger<W> earlyTrigger;
        private final Trigger<W> lateTrigger;
        private Trigger.TriggerContext ctx;
        private ValueState<Boolean> hasFiredOnTimeState;

        AfterEndOfWindowEarlyAndLate(Trigger<W> earlyTrigger, Trigger<W> lateTrigger) {
            this.earlyTrigger = earlyTrigger;
            this.lateTrigger = lateTrigger;
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
            if (this.earlyTrigger != null) {
                this.earlyTrigger.open(ctx);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.open(ctx);
            }
            ValueStateDescriptor<Boolean> descriptor = new ValueStateDescriptor<Boolean>("eventTime-afterEOW", Types.BOOLEAN);
            this.hasFiredOnTimeState = ctx.getValueState(descriptor);
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            Boolean hasFired = this.hasFiredOnTimeState.value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onElement(element, timestamp, window);
            }
            if (((Window)window).maxTimestamp() <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
            return this.earlyTrigger != null && this.earlyTrigger.onElement(element, timestamp, window);
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            Boolean hasFired = this.hasFiredOnTimeState.value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onProcessingTime(time, window);
            }
            return this.earlyTrigger != null && this.earlyTrigger.onProcessingTime(time, window);
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            Boolean hasFired = this.hasFiredOnTimeState.value();
            if (hasFired != null && hasFired.booleanValue()) {
                return this.lateTrigger != null && this.lateTrigger.onEventTime(time, window);
            }
            if (time == ((Window)window).maxTimestamp()) {
                this.hasFiredOnTimeState.update(true);
                return true;
            }
            return this.earlyTrigger != null && this.earlyTrigger.onEventTime(time, window);
        }

        @Override
        public boolean canMerge() {
            return !(this.earlyTrigger != null && !this.earlyTrigger.canMerge() || this.lateTrigger != null && !this.lateTrigger.canMerge());
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            if (this.earlyTrigger != null) {
                this.earlyTrigger.onMerge(window, mergeContext);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.onMerge(window, mergeContext);
            }
            this.hasFiredOnTimeState.update(false);
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
        }

        @Override
        public void clear(W window) throws Exception {
            if (this.earlyTrigger != null) {
                this.earlyTrigger.clear(window);
            }
            if (this.lateTrigger != null) {
                this.lateTrigger.clear(window);
            }
            this.ctx.deleteEventTimeTimer(((Window)window).maxTimestamp());
            this.hasFiredOnTimeState.clear();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(EventTime.TO_STRING);
            if (this.earlyTrigger != null) {
                builder.append(".withEarlyFirings(").append(this.earlyTrigger).append(")");
            }
            if (this.lateTrigger != null) {
                builder.append(".withLateFirings(").append(this.lateTrigger).append(")");
            }
            return builder.toString();
        }
    }

    public static final class AfterEndOfWindow<W extends Window>
    extends Trigger<W> {
        private static final long serialVersionUID = -6379468077823588591L;
        private Trigger.TriggerContext ctx;

        public AfterEndOfWindowNoLate<W> withEarlyFirings(Trigger<W> earlyFirings) {
            Preconditions.checkNotNull(earlyFirings);
            return new AfterEndOfWindowNoLate(earlyFirings);
        }

        public Trigger<W> withLateFirings(Trigger<W> lateFirings) {
            Preconditions.checkNotNull(lateFirings);
            if (lateFirings instanceof Element.EveryElement) {
                return this;
            }
            return new AfterEndOfWindowEarlyAndLate<W>(null, lateFirings);
        }

        @Override
        public void open(Trigger.TriggerContext ctx) throws Exception {
            this.ctx = ctx;
        }

        @Override
        public boolean onElement(Object element, long timestamp, W window) throws Exception {
            if (((Window)window).maxTimestamp() <= this.ctx.getCurrentWatermark()) {
                return true;
            }
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
            return false;
        }

        @Override
        public boolean onProcessingTime(long time, W window) throws Exception {
            return false;
        }

        @Override
        public boolean onEventTime(long time, W window) throws Exception {
            return time == ((Window)window).maxTimestamp();
        }

        @Override
        public void clear(W window) throws Exception {
            this.ctx.deleteEventTimeTimer(((Window)window).maxTimestamp());
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public void onMerge(W window, Trigger.OnMergeContext mergeContext) throws Exception {
            this.ctx.registerEventTimeTimer(((Window)window).maxTimestamp());
        }

        public String toString() {
            return EventTime.TO_STRING;
        }
    }
}

