/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.window.triggers;

import java.io.Serializable;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.table.api.window.Window;

public abstract class Trigger<W extends Window>
implements Serializable {
    private static final long serialVersionUID = -4104633972991191369L;

    public abstract void open(TriggerContext var1) throws Exception;

    public abstract boolean onElement(Object var1, long var2, W var4) throws Exception;

    public abstract boolean onProcessingTime(long var1, W var3) throws Exception;

    public abstract boolean onEventTime(long var1, W var3) throws Exception;

    public boolean canMerge() {
        return false;
    }

    public void onMerge(W window, OnMergeContext mergeContext) throws Exception {
        throw new UnsupportedOperationException("This trigger does not support merging.");
    }

    public abstract void clear(W var1) throws Exception;

    public static interface OnMergeContext
    extends TriggerContext {
        public <T> T mergeValueState(ValueState<T> var1, Merger<T> var2);
    }

    public static interface TriggerContext {
        public <T> ValueState<T> getValueState(ValueStateDescriptor<T> var1) throws Exception;

        public long getCurrentProcessingTime();

        public MetricGroup getMetricGroup();

        public long getCurrentWatermark();

        public void registerProcessingTimeTimer(long var1);

        public void registerEventTimeTimer(long var1);

        public void deleteProcessingTimeTimer(long var1);

        public void deleteEventTimeTimer(long var1);
    }
}

