/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import java.io.IOException;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.CodeGeneratorContext$;
import org.apache.flink.table.codegen.GeneratedProjection;
import org.apache.flink.table.codegen.ProjectionCodeGenerator$;
import org.apache.flink.table.sinks.filesystem.DynamicPartitionOutput;
import org.apache.flink.table.sinks.filesystem.FileSystemOptions$;
import org.apache.flink.table.sinks.filesystem.FileSystemOutputFormat;
import org.apache.flink.table.sinks.filesystem.OutputFormatFactory;
import org.apache.flink.table.sinks.filesystem.OutputJobDescription;
import org.apache.flink.table.sinks.filesystem.SingleDirectoryOutput;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.table.util.LowerCaseKeyMap;
import org.apache.flink.table.util.LowerCaseKeyMap$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;

public final class FileSystemOutputFormat$
implements Logging,
Serializable {
    public static final FileSystemOutputFormat$ MODULE$;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FileSystemOutputFormat$();
    }

    private Logger LOG$lzycompute() {
        FileSystemOutputFormat$ fileSystemOutputFormat$ = this;
        synchronized (fileSystemOutputFormat$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public OutputJobDescription getOutputJobDescription(OutputFormatFactory outputFormatFactory, FileSystemOutputFormat.OutputSpec outputSpec, Option<RowType> partitionColumns, Map<String, String> options) {
        LowerCaseKeyMap caseInsensitiveOptions = LowerCaseKeyMap$.MODULE$.apply(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String timeZoneStr = (String)caseInsensitiveOptions.getOrElse(FileSystemOptions$.MODULE$.TIME_ZONE().key(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return FileSystemOptions$.MODULE$.TIME_ZONE().defaultValue();
            }
        });
        RowType dataSchema = outputSpec.outputColumns();
        outputFormatFactory.configure(options);
        return new OutputJobDescription(UUID.randomUUID().toString(), outputFormatFactory, dataSchema, partitionColumns, TimeZone.getTimeZone(timeZoneStr));
    }

    public FileSystemOutputFormat getFileFormatOutput(OutputJobDescription description, String jobID, String path) {
        FileSystemOutputFormat fileSystemOutputFormat;
        if (description.partitionSchema().nonEmpty() && Predef$.MODULE$.refArrayOps((Object[])((RowType)description.partitionSchema().get()).getFieldNames()).nonEmpty()) {
            RowType dataSchema = description.dataSchema();
            RowType partitionSchema = (RowType)description.partitionSchema().get();
            GeneratedProjection generatedProjectValues = ProjectionCodeGenerator$.MODULE$.generateProjection(CodeGeneratorContext$.MODULE$.apply(new TableConfig(), CodeGeneratorContext$.MODULE$.apply$default$2()), "PartitionValuesProjection", dataSchema, partitionSchema, (int[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.getFieldNames()).map((Function1)new Serializable(dataSchema){
                public static final long serialVersionUID = 0L;
                private final RowType dataSchema$1;

                public final int apply(String x$1) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.dataSchema$1.getFieldNames()).indexOf((Object)x$1);
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            fileSystemOutputFormat = new DynamicPartitionOutput(path, description, generatedProjectValues);
        } else {
            fileSystemOutputFormat = new SingleDirectoryOutput(path, description);
        }
        SingleDirectoryOutput dataOutput = fileSystemOutputFormat;
        return dataOutput;
    }

    /*
     * WARNING - void declaration
     */
    public FileSystem initializeFileSystem(Path path, @Nullable Configuration extraUserConf) throws IOException {
        void var3_3;
        FileSystem fileSystem = path.getFileSystem();
        Predef$.MODULE$.require(fileSystem != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot initialize Hadoop FileSystem with default config.";
            }
        });
        if (!fileSystem.isDistributedFS()) {
            this.LOG().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The path: ", " is not backed by Hadoop, will output to local."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.toString()})));
        }
        return var3_3;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private FileSystemOutputFormat$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

