/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.OutputFormatSinkFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.sinks.filesystem.FileSystemOutputFormat;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001f\t1b)\u001b7f'f\u001cH/Z7TS:\\g)\u001e8di&|gN\u0003\u0002\u0004\t\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u0005\u00151\u0011!B:j].\u001c(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A\u00113\u0006E\u0002\u00125qi\u0011A\u0005\u0006\u0003'Q\tAa]5oW*\u0011QCF\u0001\nMVt7\r^5p]NT!a\u0006\r\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u001a\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00037I\u0011\u0001dT;uaV$hi\u001c:nCR\u001c\u0016N\\6Gk:\u001cG/[8o!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0006eCR\fgm\u001c:nCRL!!\t\u0010\u0003\u000f\t\u000b7/\u001a*poB\u00111%K\u0007\u0002I)\u0011QEJ\u0001\nif\u0004X-\u001e;jYNT!a\n\u0015\u0002\t)\fg/\u0019\u0006\u0003/!I!A\u000b\u0013\u0003+%s\u0007/\u001e;UsB,7i\u001c8gS\u001e,(/\u00192mKB\u0011AfL\u0007\u0002[)\u0011aFB\u0001\u0005kRLG.\u0003\u00021[\t9Aj\\4hS:<\u0007\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u001a\u0002\u0019\u0019|'/\\1u\u001fV$\b/\u001e;\u0016\u0003Q\u0002\"!\u000e\u001c\u000e\u0003\tI!a\u000e\u0002\u0003-\u0019KG.Z*zgR,WnT;uaV$hi\u001c:nCRD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u000eM>\u0014X.\u0019;PkR\u0004X\u000f\u001e\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\tid\b\u0005\u00026\u0001!)!G\u000fa\u0001i!)\u0001\t\u0001C!\u0003\u0006!q\u000e]3o)\t\u0011\u0005\n\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0003V]&$\b\"B%@\u0001\u0004Q\u0015A\u00039be\u0006lW\r^3sgB\u00111JT\u0007\u0002\u0019*\u0011Q\nC\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005=c%!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003R\u0001\u0011\u0005#+A\ttKR\u0014VO\u001c;j[\u0016\u001cuN\u001c;fqR$\"AQ*\t\u000bQ\u0003\u0006\u0019A+\u0002\u0005I\u001c\u0007C\u0001,[\u001b\u00059&BA\u000bY\u0015\tI\u0006&\u0001\u0004d_6lwN\\\u0005\u00037^\u0013aBU;oi&lWmQ8oi\u0016DH\u000fC\u0003^\u0001\u0011\u0005c,\u0001\u0007tKRLe\u000e];u)f\u0004X\rF\u0002C?NDQ\u0001\u0019/A\u0002\u0005\f\u0001\u0002^=qK&sgm\u001c\u0019\u0003E*\u00042a\u00194i\u001b\u0005!'BA3Y\u0003!!\u0018\u0010]3j]\u001a|\u0017BA4e\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007CA5k\u0019\u0001!\u0011b[0\u0002\u0002\u0003\u0005)\u0011\u00017\u0003\u0007}#\u0013'\u0005\u0002naB\u00111I\\\u0005\u0003_\u0012\u0013qAT8uQ&tw\r\u0005\u0002Dc&\u0011!\u000f\u0012\u0002\u0004\u0003:L\b\"\u0002;]\u0001\u0004)\u0018aD3yK\u000e,H/[8o\u0007>tg-[4\u0011\u0005Y<X\"\u0001-\n\u0005aD&aD#yK\u000e,H/[8o\u0007>tg-[4\t\u000bi\u0004A\u0011I>\u0002\r%tgo\\6f)\t\u0011E\u0010C\u0003~s\u0002\u0007A$A\u0003wC2,X\r")
public class FileSystemSinkFunction
extends OutputFormatSinkFunction<BaseRow>
implements Logging {
    private final FileSystemOutputFormat formatOutput;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        FileSystemSinkFunction fileSystemSinkFunction = this;
        synchronized (fileSystemSinkFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    public FileSystemOutputFormat formatOutput() {
        return this.formatOutput;
    }

    public void open(Configuration parameters) {
        super.open(parameters);
        this.formatOutput().setConfiguration(parameters);
    }

    public void setRuntimeContext(RuntimeContext rc) {
        super.setRuntimeContext(rc);
        this.formatOutput().setRuntimeContext(rc);
    }

    public void setInputType(TypeInformation<?> typeInfo, ExecutionConfig executionConfig) {
        this.formatOutput().setInputType(typeInfo);
        this.formatOutput().setExecutionConfig(executionConfig);
    }

    public void invoke(BaseRow value) {
        try {
            this.formatOutput().writeRecord(value);
            return;
        }
        catch (Throwable throwable) {
            this.formatOutput().abort();
            throw new FlinkException("Task failed while writing rows.", throwable);
        }
    }

    public FileSystemSinkFunction(FileSystemOutputFormat formatOutput) {
        this.formatOutput = formatOutput;
        super((OutputFormat)formatOutput);
        Logging$class.$init$(this);
    }
}

