/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.filesystem;

import java.util.BitSet;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.DateTimeFunctions$;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.hadoop.util.Shell;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PartitionPathUtils$ {
    public static final PartitionPathUtils$ MODULE$;
    private final String DEFAULT_PARTITION_NAME;
    private final BitSet charToEscape;

    static {
        new PartitionPathUtils$();
    }

    public String DEFAULT_PARTITION_NAME() {
        return this.DEFAULT_PARTITION_NAME;
    }

    public BitSet charToEscape() {
        return this.charToEscape;
    }

    public String org$apache$flink$table$sinks$filesystem$PartitionPathUtils$$getColumnAsString(BaseRow row2, int fieldIndex, DataType fieldType, TimeZone timeZone) {
        block17: {
            String string;
            block5: {
                InternalType internalType;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block4: {
                                                                if (row2.isNullAt(fieldIndex)) {
                                                                    return null;
                                                                }
                                                                internalType = fieldType.toInternalType();
                                                                ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
                                                                InternalType internalType2 = internalType;
                                                                if (byteArrayType != null ? !((Object)byteArrayType).equals(internalType2) : internalType2 != null) break block4;
                                                                string = new String(row2.getByteArray(fieldIndex), "UTF-8");
                                                                break block5;
                                                            }
                                                            StringType stringType = DataTypes.STRING;
                                                            InternalType internalType3 = internalType;
                                                            if (stringType != null ? !((Object)stringType).equals(internalType3) : internalType3 != null) break block6;
                                                            string = row2.getString(fieldIndex);
                                                            break block5;
                                                        }
                                                        ByteType byteType = DataTypes.BYTE;
                                                        InternalType internalType4 = internalType;
                                                        if (byteType != null ? !((Object)byteType).equals(internalType4) : internalType4 != null) break block7;
                                                        string = Byte.toString(row2.getByte(fieldIndex));
                                                        break block5;
                                                    }
                                                    ShortType shortType = DataTypes.SHORT;
                                                    InternalType internalType5 = internalType;
                                                    if (shortType != null ? !((Object)shortType).equals(internalType5) : internalType5 != null) break block8;
                                                    string = Short.toString(row2.getShort(fieldIndex));
                                                    break block5;
                                                }
                                                IntType intType = DataTypes.INT;
                                                InternalType internalType6 = internalType;
                                                if (intType != null ? !((Object)intType).equals(internalType6) : internalType6 != null) break block9;
                                                string = Integer.toString(row2.getInt(fieldIndex));
                                                break block5;
                                            }
                                            LongType longType = DataTypes.LONG;
                                            InternalType internalType7 = internalType;
                                            if (longType != null ? !((Object)longType).equals(internalType7) : internalType7 != null) break block10;
                                            string = Long.toString(row2.getLong(fieldIndex));
                                            break block5;
                                        }
                                        FloatType floatType = DataTypes.FLOAT;
                                        InternalType internalType8 = internalType;
                                        if (floatType != null ? !((Object)floatType).equals(internalType8) : internalType8 != null) break block11;
                                        string = Float.toString(row2.getFloat(fieldIndex));
                                        break block5;
                                    }
                                    DoubleType doubleType = DataTypes.DOUBLE;
                                    InternalType internalType9 = internalType;
                                    if (doubleType != null ? !((Object)doubleType).equals(internalType9) : internalType9 != null) break block12;
                                    string = Double.toString(row2.getDouble(fieldIndex));
                                    break block5;
                                }
                                BooleanType booleanType = DataTypes.BOOLEAN;
                                InternalType internalType10 = internalType;
                                if (booleanType != null ? !((Object)booleanType).equals(internalType10) : internalType10 != null) break block13;
                                string = Boolean.toString(row2.getBoolean(fieldIndex));
                                break block5;
                            }
                            if (!(internalType instanceof DecimalType)) break block14;
                            DecimalType decimalType = (DecimalType)internalType;
                            string = row2.getDecimal(fieldIndex, decimalType.precision(), decimalType.scale()).toString();
                            break block5;
                        }
                        TimestampType timestampType = DataTypes.TIMESTAMP;
                        InternalType internalType11 = internalType;
                        if (timestampType != null ? !((Object)timestampType).equals(internalType11) : internalType11 != null) break block15;
                        string = DateTimeFunctions$.MODULE$.timestampToStringPrecision(row2.getLong(fieldIndex), 3, timeZone);
                        break block5;
                    }
                    DateType dateType = DataTypes.DATE;
                    InternalType internalType12 = internalType;
                    if (dateType != null ? !((Object)dateType).equals(internalType12) : internalType12 != null) break block16;
                    string = DateTimeUtils.unixDateToString(row2.getInt(fieldIndex));
                    break block5;
                }
                TimeType timeType = DataTypes.TIME;
                InternalType internalType13 = internalType;
                if (timeType != null ? !((Object)timeType).equals(internalType13) : internalType13 != null) break block17;
                string = DateTimeUtils.unixTimeToString(row2.getInt(fieldIndex));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported data type: ").append((Object)fieldType.toString()).toString());
    }

    public String getPartitionPath(BaseRow row2, RowType partitionSchema, TimeZone timeZone) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.getFieldTypes()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionSchema.getFieldNames()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(row2, timeZone){
            public static final long serialVersionUID = 0L;
            private final BaseRow row$1;
            private final TimeZone timeZone$1;

            public final String apply(Tuple2<Tuple2<DataType, String>, Object> x0$1) {
                Tuple2<Tuple2<DataType, String>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        DataType fieldType = (DataType)tuple22._1();
                        String fieldName = (String)tuple22._2();
                        String string = PartitionPathUtils$.MODULE$.getPartitionDirStr(fieldName, PartitionPathUtils$.MODULE$.org$apache$flink$table$sinks$filesystem$PartitionPathUtils$$getColumnAsString(this.row$1, index, fieldType, this.timeZone$1));
                        return string;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.timeZone$1 = timeZone$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("/");
    }

    public String getPartitionDirStr(String col, String value) {
        String partitionString = value == null || value.isEmpty() ? this.DEFAULT_PARTITION_NAME() : this.escapePathName(value);
        return new StringBuilder().append((Object)this.escapePathName(col)).append((Object)"=").append((Object)partitionString).toString();
    }

    public boolean needsEscaping(char c) {
        return c >= '\u0000' && c < this.charToEscape().size() && this.charToEscape().get(c);
    }

    public String escapePathName(String path) {
        StringBuilder builder = new StringBuilder();
        new StringOps(Predef$.MODULE$.augmentString(path)).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;

            public final StringBuilder apply(char c) {
                StringBuilder stringBuilder;
                if (PartitionPathUtils$.MODULE$.needsEscaping(c)) {
                    this.builder$1.append('%');
                    char arg$macro$6 = c;
                    stringBuilder = this.builder$1.append(new StringOps("%02X").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$6)})));
                } else {
                    stringBuilder = this.builder$1.append(c);
                }
                return stringBuilder;
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private PartitionPathUtils$() {
        void var1_1;
        MODULE$ = this;
        this.DEFAULT_PARTITION_NAME = "__HIVE_DEFAULT_PARTITION__";
        BitSet bitSet = new BitSet(128);
        char[] clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'};
        Predef$.MODULE$.charArrayOps(clist).foreach((Function1)new Serializable(bitSet){
            public static final long serialVersionUID = 0L;
            private final BitSet bitSet$1;

            public final void apply(char x$1) {
                this.bitSet$1.set(x$1);
            }
            {
                this.bitSet$1 = bitSet$1;
            }
        });
        if (Shell.WINDOWS) {
            Predef$.MODULE$.charArrayOps(new char[]{' ', '<', '>', '|'}).foreach((Function1)new Serializable(bitSet){
                public static final long serialVersionUID = 0L;
                private final BitSet bitSet$1;

                public final void apply(char x$2) {
                    this.bitSet$1.set(x$2);
                }
                {
                    this.bitSet$1 = bitSet$1;
                }
            });
        }
        this.charToEscape = var1_1;
    }
}

