/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.sources.orc.OrcSchemaConverter;
import org.apache.flink.table.sources.orc.OrcSerializer;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcOutputFormat;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowOrcOutputFormat
implements OutputFormat<BaseRow> {
    private static final Logger LOG = LoggerFactory.getLogger(RowOrcOutputFormat.class);
    private static final String FILE_PREFIX_NAME = "orc-";
    private static final int DEFAULT_ROW_INDEX_STRIDE = 10000;
    private final InternalType[] fieldTypes;
    private final String[] fieldNames;
    private final String dir;
    private final CompressionKind compression;
    private final String filePrefixName;
    private final int rowIndexStride;
    private RecordWriter<Void, OrcStruct> realWriter;
    private TaskAttemptContext taskContext;
    private final OrcSerializer serializer;
    private final String typeDescription;
    private transient OrcStruct struct;

    public RowOrcOutputFormat(InternalType[] fieldTypes2, String[] fieldNames, String dir) {
        this(fieldTypes2, fieldNames, dir, CompressionKind.NONE, FILE_PREFIX_NAME, 10000);
    }

    public RowOrcOutputFormat(InternalType[] fieldTypes2, String[] fieldNames, String dir, CompressionKind compression) {
        this(fieldTypes2, fieldNames, dir, compression, FILE_PREFIX_NAME, 10000);
    }

    public RowOrcOutputFormat(InternalType[] fieldTypes2, String[] fieldNames, String dir, CompressionKind compression, String filePrefixName, int rowIndexStride) {
        Preconditions.checkArgument(fieldNames != null && fieldNames.length > 0);
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length == fieldNames.length);
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
        this.dir = dir;
        this.compression = compression;
        this.filePrefixName = filePrefixName;
        this.rowIndexStride = rowIndexStride;
        this.serializer = new OrcSerializer(fieldTypes2, fieldNames);
        this.typeDescription = OrcSchemaConverter.convert(fieldTypes2, fieldNames).toString();
        this.struct = (OrcStruct)OrcStruct.createValue((TypeDescription)TypeDescription.fromString((String)this.typeDescription));
    }

    @Override
    public void configure(Configuration parameters) {
    }

    @Override
    public void open(final int taskNumber, int numTasks) throws IOException {
        JobConf jobConf = new JobConf();
        final String fileName = this.filePrefixName + numTasks + "-" + taskNumber + "-" + System.currentTimeMillis() + ".orc";
        Path path = new Path(new Path(this.dir, String.valueOf(taskNumber)), fileName);
        FileSystem fs = path.getFileSystem();
        if (fs instanceof SafetyNetWrapperFileSystem) {
            fs = ((SafetyNetWrapperFileSystem)fs).getWrappedDelegate();
        }
        if (fs instanceof HadoopFileSystem) {
            jobConf.addResource(((HadoopFileSystem)fs).getConfig());
        }
        if (!(fs instanceof LocalFileSystem) && !(fs instanceof HadoopFileSystem)) {
            throw new RuntimeException("FileSystem: " + fs.getClass().getCanonicalName() + " is not supported.");
        }
        fs.delete(path, true);
        OrcOutputFormat<OrcStruct> realOutputFormat = new OrcOutputFormat<OrcStruct>(){

            public org.apache.hadoop.fs.Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
                return new org.apache.hadoop.fs.Path(new org.apache.hadoop.fs.Path(RowOrcOutputFormat.this.dir, String.valueOf(taskNumber)), fileName);
            }
        };
        jobConf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcSchemaConverter.convert(this.fieldTypes, this.fieldNames).toString());
        jobConf.set(OrcConf.COMPRESS.getAttribute(), this.compression.name());
        jobConf.set(OrcConf.ROW_INDEX_STRIDE.getAttribute(), String.valueOf(this.rowIndexStride));
        TaskAttemptID taskAttemptID = new TaskAttemptID();
        this.taskContext = ContextUtil.newTaskAttemptContext((org.apache.hadoop.conf.Configuration)jobConf, (TaskAttemptID)taskAttemptID);
        this.realWriter = realOutputFormat.getRecordWriter(this.taskContext);
    }

    @Override
    public void writeRecord(BaseRow record) throws IOException {
        try {
            this.realWriter.write(null, (Object)this.serializer.serialize(record, this.struct));
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.realWriter != null) {
                this.realWriter.close(this.taskContext);
            }
        }
        catch (InterruptedException e2) {
            throw new IOException(e2);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.struct.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.struct == null) {
            this.struct = new OrcStruct(TypeDescription.fromString((String)this.typeDescription));
        }
        this.struct.readFields((DataInput)in);
    }
}

