/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.orc.TypeDescription;

public class OrcSchemaConverter {
    public static TypeDescription convert(DataType[] fieldTypes2, String[] fieldNames) {
        TypeDescription td = TypeDescription.createStruct();
        for (int i = 0; i < fieldTypes2.length; ++i) {
            td.addField(fieldNames[i], OrcSchemaConverter.convertType(fieldTypes2[i]));
        }
        return td;
    }

    private static TypeDescription convertType(DataType fieldType) {
        if (fieldType instanceof BooleanType) {
            return TypeDescription.createBoolean();
        }
        if (fieldType instanceof ByteType) {
            return TypeDescription.createByte();
        }
        if (fieldType instanceof ShortType) {
            return TypeDescription.createShort();
        }
        if (fieldType instanceof IntType) {
            return TypeDescription.createInt();
        }
        if (fieldType instanceof LongType) {
            return TypeDescription.createLong();
        }
        if (fieldType instanceof FloatType) {
            return TypeDescription.createFloat();
        }
        if (fieldType instanceof DoubleType) {
            return TypeDescription.createDouble();
        }
        if (fieldType instanceof StringType || fieldType instanceof ByteArrayType) {
            return TypeDescription.createString();
        }
        if (fieldType instanceof DateType) {
            return TypeDescription.createDate();
        }
        if (fieldType instanceof TimestampType) {
            return TypeDescription.createTimestamp();
        }
        if (fieldType instanceof DecimalType) {
            int precision = ((DecimalType)fieldType).precision();
            int scale = ((DecimalType)fieldType).scale();
            return TypeDescription.createDecimal().withPrecision(precision).withScale(scale);
        }
        throw new UnsupportedOperationException("Unsupported category: " + fieldType);
    }
}

