/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.serde2.io.DateWritable;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class OrcSerializer
implements Serializable {
    private final DataType[] fieldTypes;
    private final String[] fieldNames;
    private final Converter[] fieldConverters;
    private static final Map<Class<? extends DataType>, Converter> CONVERTER_MAP = new HashMap<Class<? extends DataType>, Converter>(){
        private static final long serialVersionUID = 4338806462093593810L;
        {
            this.put(BooleanType.class, new BooleanConverter());
            this.put(ByteType.class, new ByteConverter());
            this.put(ShortType.class, new ShortConverter());
            this.put(IntType.class, new IntConverter());
            this.put(LongType.class, new LongConverter());
            this.put(FloatType.class, new FloatConverter());
            this.put(DoubleType.class, new DoubleConverter());
            this.put(StringType.class, new StringConverter());
            this.put(DateType.class, new SqlDateConverter());
            this.put(TimestampType.class, new SqlTimestampConverter());
            this.put(DecimalType.class, new DecimalConverter());
        }
    };

    public OrcSerializer(DataType[] fieldTypes2, String[] fieldNames) {
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length > 0);
        Preconditions.checkArgument(fieldNames != null && fieldNames.length == fieldTypes2.length);
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
        this.fieldConverters = new Converter[this.fieldTypes.length];
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            this.fieldConverters[i] = CONVERTER_MAP.get(this.fieldTypes[i].getClass());
        }
    }

    public OrcStruct serialize(BaseRow row2, OrcStruct struct) {
        for (int i = 0; i < this.fieldConverters.length; ++i) {
            if (row2.isNullAt(i)) {
                struct.setFieldValue(i, null);
                continue;
            }
            struct.setFieldValue(i, this.fieldConverters[i].convert(BaseRowUtil.get(row2, i, this.fieldTypes[i])));
        }
        return struct;
    }

    private static class SqlTimestampConverter
    extends Converter {
        private SqlTimestampConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new OrcTimestamp(((Long)value).longValue());
        }
    }

    private static class SqlDateConverter
    extends Converter {
        private SqlDateConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new DateWritable(((Integer)value).intValue());
        }
    }

    private static class DecimalConverter
    extends Converter {
        private DecimalConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)((Decimal)value).toBigDecimal()));
        }
    }

    private static class StringConverter
    extends Converter {
        private StringConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            if (value instanceof BinaryString) {
                return new Text(((BinaryString)value).getBytes());
            }
            if (value instanceof String) {
                return new Text((String)value);
            }
            throw new RuntimeException("Unsupport type: " + value);
        }
    }

    private static class DoubleConverter
    extends Converter {
        private DoubleConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new DoubleWritable(((Double)value).doubleValue());
        }
    }

    private static class FloatConverter
    extends Converter {
        private FloatConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new FloatWritable(((Float)value).floatValue());
        }
    }

    private static class LongConverter
    extends Converter {
        private LongConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new LongWritable(((Long)value).longValue());
        }
    }

    private static class IntConverter
    extends Converter {
        private IntConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new IntWritable(((Integer)value).intValue());
        }
    }

    private static class ShortConverter
    extends Converter {
        private ShortConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new ShortWritable(((Short)value).shortValue());
        }
    }

    private static class ByteConverter
    extends Converter {
        private ByteConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new ByteWritable(((Byte)value).byteValue());
        }
    }

    private static class BooleanConverter
    extends Converter {
        private BooleanConverter() {
        }

        @Override
        protected WritableComparable convert(Object value) {
            return new BooleanWritable(((Boolean)value).booleanValue());
        }
    }

    private static abstract class Converter
    implements Serializable {
        private Converter() {
        }

        protected abstract WritableComparable convert(Object var1);
    }
}

