/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.DateColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.dataformat.vector.ShortColumnVector;
import org.apache.flink.table.dataformat.vector.TimestampColumnVector;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;
import org.apache.flink.table.sources.orc.MissingColumnVector;
import org.apache.flink.table.sources.orc.OrcColumnVector;
import org.apache.flink.table.sources.orc.OrcUtils;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcInputFormat;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class OrcVectorizedReader
extends org.apache.hadoop.mapreduce.RecordReader<Void, Object> {
    private static final int MAX_SIZE = 2048;
    private VectorizedRowBatch batch;
    private TypeDescription orcSchema;
    private int[] requestedColumnIds;
    private RecordReader recordReader;
    protected VectorizedColumnBatch columnarBatch;
    protected org.apache.flink.table.dataformat.vector.ColumnVector[] orcVectorWrappers;
    protected InternalType[] fieldTypes;
    protected String[] fieldNames;
    protected String[] schemaFieldNames;
    private boolean copyToFlink = false;
    private boolean caseSensitive = true;

    public OrcVectorizedReader(InternalType[] fieldTypes2, String[] fieldNames, String[] schemaFieldNames) {
        this(fieldTypes2, fieldNames, schemaFieldNames, false, true);
    }

    public OrcVectorizedReader(InternalType[] fieldTypes2, String[] fieldNames, String[] schemaFieldNames, boolean copyToFlink, boolean caseSensitive) {
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length > 0);
        Preconditions.checkArgument(fieldNames != null && fieldNames.length == fieldTypes2.length);
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
        this.schemaFieldNames = schemaFieldNames;
        this.copyToFlink = copyToFlink;
        this.caseSensitive = caseSensitive;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader reader = OrcFile.createReader((Path)fileSplit.getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)).filesystem(fileSplit.getPath().getFileSystem(conf)));
        Reader.Options options = OrcInputFormat.buildOptions((Configuration)conf, (Reader)reader, (long)fileSplit.getStart(), (long)fileSplit.getLength());
        this.recordReader = reader.rows(options);
        this.orcSchema = reader.getSchema();
        this.requestedColumnIds = OrcUtils.requestedColumnIds(this.caseSensitive, this.fieldNames, this.schemaFieldNames, reader);
        this.initBatch();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.nextBatch();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.columnarBatch;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }

    void initBatch() {
        this.batch = this.orcSchema.createRowBatch(2048);
        assert (!this.batch.selectedInUse);
        if (this.copyToFlink) {
            this.columnarBatch = VectorizedColumnBatch.allocate(this.fieldTypes);
            for (int i = 0; i < this.requestedColumnIds.length; ++i) {
                if (this.requestedColumnIds[i] != -1) continue;
                Arrays.fill(this.columnarBatch.columns[i].isNull, true);
                this.columnarBatch.columns[i].noNulls = false;
            }
        } else {
            this.orcVectorWrappers = new org.apache.flink.table.dataformat.vector.ColumnVector[this.fieldTypes.length];
            for (int i = 0; i < this.fieldTypes.length; ++i) {
                int columnId = this.requestedColumnIds[i];
                this.orcVectorWrappers[i] = columnId == -1 ? new MissingColumnVector(2048) : new OrcColumnVector(this.fieldTypes[i], this.batch.cols[columnId]);
            }
            this.columnarBatch = new VectorizedColumnBatch(this.fieldTypes, 2048, this.orcVectorWrappers);
        }
    }

    protected boolean nextBatch() throws IOException {
        this.recordReader.nextBatch(this.batch);
        int batchSize = this.batch.size;
        if (batchSize == 0) {
            return false;
        }
        this.columnarBatch.reset();
        this.columnarBatch.setNumRows(batchSize);
        if (!this.copyToFlink) {
            for (int i = 0; i < this.fieldTypes.length; ++i) {
                int columnId = this.requestedColumnIds[i];
                if (columnId == -1) continue;
                ((OrcColumnVector)this.orcVectorWrappers[i]).setNullInfo(this.batch.cols[columnId]);
            }
            return true;
        }
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (this.requestedColumnIds[i] < 0) continue;
            ColumnVector fromColumn = this.batch.cols[this.requestedColumnIds[i]];
            if (fromColumn.isRepeating) {
                this.putRepeatingValues(batchSize, this.fieldTypes[i], fromColumn, this.columnarBatch.columns[i]);
                continue;
            }
            if (fromColumn.noNulls) {
                this.putNotNullValues(batchSize, this.fieldTypes[i], fromColumn, this.columnarBatch.columns[i]);
                continue;
            }
            this.putValues(batchSize, this.fieldTypes[i], fromColumn, this.columnarBatch.columns[i]);
        }
        return true;
    }

    private void putRepeatingValues(int batchSize, DataType fieldType, ColumnVector fromColumn, org.apache.flink.table.dataformat.vector.ColumnVector toColumn) {
        if (fromColumn.isNull[0]) {
            Arrays.fill(toColumn.isNull, true);
        } else if (fieldType instanceof BooleanType) {
            Arrays.fill(((BooleanColumnVector)toColumn).vector, ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0] == 1L);
        } else if (fieldType instanceof ByteType) {
            Arrays.fill(((ByteColumnVector)toColumn).vector, (byte)((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof ShortType) {
            Arrays.fill(((ShortColumnVector)toColumn).vector, (short)((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof IntType) {
            Arrays.fill(((IntegerColumnVector)toColumn).vector, (int)((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof LongType) {
            Arrays.fill(((LongColumnVector)toColumn).vector, ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof FloatType) {
            Arrays.fill(((FloatColumnVector)toColumn).vector, (float)((DoubleColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof DoubleType) {
            Arrays.fill(((org.apache.flink.table.dataformat.vector.DoubleColumnVector)toColumn).vector, ((DoubleColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof StringType || fieldType instanceof ByteArrayType) {
            for (int i = 0; i < batchSize; ++i) {
                byte[][] data = ((BytesColumnVector)fromColumn).vector;
                int[] start = ((BytesColumnVector)fromColumn).start;
                int[] length = ((BytesColumnVector)fromColumn).length;
                ((org.apache.flink.table.dataformat.vector.BytesColumnVector)toColumn).setVal(i, data[0], start[0], length[0]);
            }
        } else if (fieldType instanceof DateType) {
            Arrays.fill(((DateColumnVector)toColumn).vector, (int)((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector[0]);
        } else if (fieldType instanceof TimestampType) {
            long time = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).time[0];
            int nanos = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).nanos[0];
            Arrays.fill(((TimestampColumnVector)toColumn).vector, time + (long)(nanos / 1000000));
        } else if (fieldType instanceof DecimalType) {
            DecimalColumnVector data = (DecimalColumnVector)fromColumn;
            int precision = ((DecimalType)fieldType).precision();
            int scale = ((DecimalType)fieldType).scale();
            this.putDecimalWritables(toColumn, batchSize, precision, scale, data.vector[0]);
        } else {
            throw new UnsupportedOperationException("Unsupported Data Type: " + fieldType);
        }
    }

    private void putNotNullValues(int batchSize, DataType fieldType, ColumnVector fromColumn, org.apache.flink.table.dataformat.vector.ColumnVector toColumn) {
        if (fieldType instanceof BooleanType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((BooleanColumnVector)toColumn).vector[i] = data[i] == 1L;
            }
        } else if (fieldType instanceof ByteType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((ByteColumnVector)toColumn).vector[i] = (byte)data[i];
            }
        } else if (fieldType instanceof ShortType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((ShortColumnVector)toColumn).vector[i] = (short)data[i];
            }
        } else if (fieldType instanceof IntType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((IntegerColumnVector)toColumn).vector[i] = (int)data[i];
            }
        } else if (fieldType instanceof LongType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            System.arraycopy(data, 0, ((LongColumnVector)toColumn).vector, 0, batchSize);
        } else if (fieldType instanceof FloatType) {
            double[] data = ((DoubleColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((FloatColumnVector)toColumn).vector[i] = (float)data[i];
            }
        } else if (fieldType instanceof DoubleType) {
            double[] data = ((DoubleColumnVector)fromColumn).vector;
            System.arraycopy(data, 0, ((org.apache.flink.table.dataformat.vector.DoubleColumnVector)toColumn).vector, 0, batchSize);
        } else if (fieldType instanceof StringType || fieldType instanceof ByteArrayType) {
            byte[][] data = ((BytesColumnVector)fromColumn).vector;
            int[] start = ((BytesColumnVector)fromColumn).start;
            int[] length = ((BytesColumnVector)fromColumn).length;
            for (int i = 0; i < batchSize; ++i) {
                ((org.apache.flink.table.dataformat.vector.BytesColumnVector)toColumn).setVal(i, data[i], start[i], length[i]);
            }
        } else if (fieldType instanceof DateType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                ((DateColumnVector)toColumn).vector[i] = (int)data[i];
            }
        } else if (fieldType instanceof TimestampType) {
            long[] time = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).time;
            int[] nanos = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).nanos;
            for (int i = 0; i < batchSize; ++i) {
                ((TimestampColumnVector)toColumn).vector[i] = time[i] + (long)(nanos[i] / 1000000);
            }
        } else if (fieldType instanceof DecimalType) {
            DecimalColumnVector data = (DecimalColumnVector)fromColumn;
            int precision = ((DecimalType)fieldType).precision();
            int scale = ((DecimalType)fieldType).scale();
            for (int i = 0; i < batchSize; ++i) {
                this.putDecimalWritable(toColumn, i, precision, scale, data.vector[i]);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Data Type: " + fieldType);
        }
    }

    private void putValues(int batchSize, DataType fieldType, ColumnVector fromColumn, org.apache.flink.table.dataformat.vector.ColumnVector toColumn) {
        System.arraycopy(fromColumn.isNull, 0, toColumn.isNull, 0, batchSize);
        toColumn.noNulls = fromColumn.noNulls;
        if (fieldType instanceof BooleanType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((BooleanColumnVector)toColumn).vector[i] = data[i] == 1L;
            }
        } else if (fieldType instanceof ByteType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((ByteColumnVector)toColumn).vector[i] = (byte)data[i];
            }
        } else if (fieldType instanceof ShortType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((ShortColumnVector)toColumn).vector[i] = (short)data[i];
            }
        } else if (fieldType instanceof IntType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((IntegerColumnVector)toColumn).vector[i] = (int)data[i];
            }
        } else if (fieldType instanceof LongType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            System.arraycopy(data, 0, ((LongColumnVector)toColumn).vector, 0, batchSize);
        } else if (fieldType instanceof FloatType) {
            double[] data = ((DoubleColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((FloatColumnVector)toColumn).vector[i] = (float)data[i];
            }
        } else if (fieldType instanceof DoubleType) {
            double[] data = ((DoubleColumnVector)fromColumn).vector;
            System.arraycopy(data, 0, ((org.apache.flink.table.dataformat.vector.DoubleColumnVector)toColumn).vector, 0, batchSize);
        } else if (fieldType instanceof StringType || fieldType instanceof ByteArrayType) {
            byte[][] data = ((BytesColumnVector)fromColumn).vector;
            int[] start = ((BytesColumnVector)fromColumn).start;
            int[] length = ((BytesColumnVector)fromColumn).length;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((org.apache.flink.table.dataformat.vector.BytesColumnVector)toColumn).setVal(i, data[i], start[i], length[i]);
            }
        } else if (fieldType instanceof DateType) {
            long[] data = ((org.apache.orc.storage.ql.exec.vector.LongColumnVector)fromColumn).vector;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((DateColumnVector)toColumn).vector[i] = (int)data[i];
            }
        } else if (fieldType instanceof TimestampType) {
            long[] time = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).time;
            int[] nanos = ((org.apache.orc.storage.ql.exec.vector.TimestampColumnVector)fromColumn).nanos;
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                ((TimestampColumnVector)toColumn).vector[i] = time[i] + (long)(nanos[i] / 1000000);
            }
        } else if (fieldType instanceof DecimalType) {
            DecimalColumnVector data = (DecimalColumnVector)fromColumn;
            int precision = ((DecimalType)fieldType).precision();
            int scale = ((DecimalType)fieldType).scale();
            for (int i = 0; i < batchSize; ++i) {
                if (fromColumn.isNull[i]) continue;
                this.putDecimalWritable(toColumn, i, precision, scale, data.vector[i]);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Data Type: " + fieldType);
        }
    }

    private void putDecimalWritables(org.apache.flink.table.dataformat.vector.ColumnVector toColumn, int batchSize, int precision, int scale, HiveDecimalWritable decimalWritable) {
        HiveDecimal decimal = decimalWritable.getHiveDecimal();
        Decimal value = Decimal.fromBigDecimal(decimal.bigDecimalValue(), precision, scale);
        if (Decimal.is32BitDecimal(precision)) {
            Arrays.fill(((IntegerColumnVector)toColumn).vector, (int)value.toUnscaledLong());
        } else if (Decimal.is64BitDecimal(precision)) {
            Arrays.fill(((LongColumnVector)toColumn).vector, value.toUnscaledLong());
        } else {
            byte[] bytes = value.toUnscaledBytes();
            for (int i = 0; i < batchSize; ++i) {
                ((org.apache.flink.table.dataformat.vector.BytesColumnVector)toColumn).setVal(i, bytes);
            }
        }
    }

    private void putDecimalWritable(org.apache.flink.table.dataformat.vector.ColumnVector toColumn, int index, int precision, int scale, HiveDecimalWritable decimalWritable) {
        HiveDecimal decimal = decimalWritable.getHiveDecimal();
        Decimal value = Decimal.fromBigDecimal(decimal.bigDecimalValue(), precision, scale);
        if (Decimal.is32BitDecimal(precision)) {
            ((IntegerColumnVector)toColumn).vector[index] = (int)value.toUnscaledLong();
        } else if (Decimal.is64BitDecimal(precision)) {
            ((LongColumnVector)toColumn).vector[index] = value.toUnscaledLong();
        } else {
            byte[] bytes = value.toUnscaledBytes();
            ((org.apache.flink.table.dataformat.vector.BytesColumnVector)toColumn).setVal(index, bytes);
        }
    }
}

