/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.orc;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.dataformat.ColumnarRow;
import org.apache.flink.table.sources.orc.OrcInputFormat;
import org.apache.flink.table.sources.orc.OrcVectorizedColumnRowReader;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class VectorizedColumnRowInputOrcFormat
extends OrcInputFormat<ColumnarRow, ColumnarRow>
implements ResultTypeQueryable<ColumnarRow> {
    private static final long serialVersionUID = -857535186065774140L;
    private boolean copyToFlink;

    public VectorizedColumnRowInputOrcFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        this(filePath, fieldTypes2, fieldNames, false);
    }

    public VectorizedColumnRowInputOrcFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames, boolean copyToFlink) {
        super(filePath, fieldTypes2, fieldNames);
        this.copyToFlink = copyToFlink;
    }

    @Override
    protected ColumnarRow convert(ColumnarRow current) {
        return current;
    }

    @Override
    protected RecordReader createReader(FileInputSplit fileSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        return new OrcVectorizedColumnRowReader(this.fieldTypes, this.fieldNames, this.schemaFieldNames, this.copyToFlink);
    }

    @Override
    public TypeInformation<ColumnarRow> getProducedType() {
        TypeInformation[] typeInfos = (TypeInformation[])Arrays.stream(this.fieldTypes).map(TypeConverters::createExternalTypeInfoFromDataType).toArray(TypeInformation[]::new);
        return new BaseRowTypeInfo(typeInfos);
    }
}

