/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.table.sources.parquet.ParquetReadSupport;
import org.apache.flink.table.sources.parquet.ParquetSchemaConverter;
import org.apache.flink.table.sources.parquet.RecordReaderIterator;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;

public abstract class ParquetInputFormat<T, R>
extends FileInputFormat<T> {
    private static final long serialVersionUID = 4308499696607786440L;
    protected final InternalType[] fieldTypes;
    protected final String[] fieldNames;
    private byte[] filterBytes;
    protected transient RecordReaderIterator<R> readerIterator;

    protected ParquetInputFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        super(filePath);
        Preconditions.checkArgument(fieldNames != null && fieldNames.length > 0);
        Preconditions.checkArgument(fieldTypes2 != null && fieldTypes2.length == fieldNames.length);
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes2;
    }

    public void setFilterPredicate(FilterPredicate filter) throws Exception {
        this.filterBytes = (byte[])(filter != null ? InstantiationUtil.serializeObject(filter) : null);
    }

    private FilterPredicate getFilterPredicate() {
        if (this.filterBytes != null) {
            try {
                return (FilterPredicate)InstantiationUtil.deserializeObject(this.filterBytes, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    @Override
    public void open(FileInputSplit fileSplit) throws IOException {
        Configuration hadoopConf = new Configuration();
        FileSystem fs = fileSplit.getPath().getFileSystem();
        if (fs instanceof SafetyNetWrapperFileSystem) {
            fs = ((SafetyNetWrapperFileSystem)fs).getWrappedDelegate();
        }
        if (fs instanceof HadoopFileSystem) {
            hadoopConf.addResource(((HadoopFileSystem)fs).getConfig());
        }
        if (!(fs instanceof LocalFileSystem) && !(fs instanceof HadoopFileSystem)) {
            throw new RuntimeException("FileSystem: " + fs.getClass().getCanonicalName() + " is not supported.");
        }
        ParquetInputSplit split = new ParquetInputSplit(new org.apache.hadoop.fs.Path(fileSplit.getPath().toUri()), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getHostnames(), null);
        FilterPredicate filter = this.getFilterPredicate();
        if (filter != null) {
            org.apache.parquet.hadoop.ParquetInputFormat.setFilterPredicate((Configuration)hadoopConf, (FilterPredicate)filter);
        }
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, attemptId);
        RecordReader recordReader = this.createReader(filter);
        try {
            recordReader.initialize((InputSplit)split, (TaskAttemptContext)taskAttemptContext);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        this.readerIterator = new RecordReaderIterator(recordReader);
    }

    protected RecordReader createReader(FilterPredicate filter) {
        ParquetReadSupport readSupport = new ParquetReadSupport(this.fieldTypes, this.fieldNames);
        if (filter != null) {
            return new ParquetRecordReader((ReadSupport)readSupport, FilterCompat.get((FilterPredicate)filter));
        }
        return new ParquetRecordReader((ReadSupport)readSupport);
    }

    @Override
    public void close() throws IOException {
        if (this.readerIterator != null) {
            this.readerIterator.close();
        }
    }

    @Override
    public boolean reachedEnd() throws IOException {
        return !this.readerIterator.hasNext();
    }

    @Override
    public T nextRecord(T reuse) throws IOException {
        R next = this.readerIterator.next();
        return this.convert(next);
    }

    protected abstract T convert(R var1);

    private void checkSchema(Configuration hadoopConf, ParquetInputSplit split) throws IOException {
        ParquetMetadataConverter.MetadataFilter metadataFilter = ParquetMetadataConverter.range((long)split.getStart(), (long)split.getEnd());
        ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)hadoopConf, (org.apache.hadoop.fs.Path)split.getPath(), (ParquetMetadataConverter.MetadataFilter)metadataFilter);
        FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
        MessageType parquetSchema = fileMetaData.getSchema();
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter();
        Map<String, InternalType> fieldName2TypeInfoMap = schemaConverter.convertToInternalType(parquetSchema);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            InternalType fieldType = this.fieldTypes[i];
            if (!fieldName2TypeInfoMap.containsKey(fieldName)) {
                throw new IllegalArgumentException(fieldName + " can not be found in parquet schema");
            }
            InternalType parquetFieldType = fieldName2TypeInfoMap.get(fieldName);
            if (fieldType.equals(parquetFieldType)) continue;
            throw new IllegalArgumentException(parquetFieldType + " can not be convert to " + fieldType);
        }
    }

    @Override
    protected boolean testForUnsplittable(FileStatus pathFile) {
        return false;
    }
}

