/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.sources.parquet.ParquetRecordConverter;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.types.Row;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetReadSupport
extends ReadSupport<Row> {
    private final String[] fieldNames;
    private final InternalType[] fieldTypes;

    public ParquetReadSupport(InternalType[] fieldTypes2, String[] fieldNames) {
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes2;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType requestedSchema = this.clipParquetSchema(context.getFileSchema().asGroupType(), this.fieldNames);
        return new ReadSupport.ReadContext(requestedSchema, new HashMap());
    }

    public RecordMaterializer<Row> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType parquetRequestedSchema = readContext.getRequestedSchema();
        final ParquetRecordConverter recordConverter = new ParquetRecordConverter((GroupType)parquetRequestedSchema, this.fieldTypes);
        return new RecordMaterializer<Row>(){

            public Row getCurrentRecord() {
                return recordConverter.getCurrentRecord();
            }

            public GroupConverter getRootConverter() {
                return recordConverter;
            }
        };
    }

    private MessageType clipParquetSchema(GroupType parquetSchema, String[] fieldNames) {
        Type[] types = new Type[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            if (parquetSchema.getFieldIndex(fieldName) < 0) {
                throw new IllegalArgumentException(fieldName + " does not exist");
            }
            types[i] = parquetSchema.getType(fieldName);
        }
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(types)).named("flink-parquet");
    }
}

