/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeConvertUtils;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetRecordConverter
extends GroupConverter {
    private final Row currentRow;
    private final List<Converter> fieldConverters;
    private static final DecimalType ANY_DEC_TYPE = DecimalType.SYSTEM_DEFAULT;
    private static final Map<InternalType, ConverterCreator> CONVERTER_CREATOR_MAP = new HashMap<InternalType, ConverterCreator>(){
        private static final long serialVersionUID = 2137301835386882070L;
        {
            this.put(DataTypes.STRING, new StringConverterCreator());
            this.put(DataTypes.BOOLEAN, new BooleanConverterCreator());
            this.put(DataTypes.BYTE, new ByteConverterCreator());
            this.put(DataTypes.SHORT, new ShortConverterCreator());
            this.put(DataTypes.INT, new IntConverterCreator());
            this.put(DataTypes.LONG, new LongConverterCreator());
            this.put(DataTypes.FLOAT, new FloatConverterCreator());
            this.put(DataTypes.DOUBLE, new DoubleConverterCreator());
            this.put(ANY_DEC_TYPE, new BigDecConverterCreator());
            this.put(DataTypes.BYTE_ARRAY, new ByteArrayConverterCreator());
            this.put(DataTypes.DATE, new SqlDateConverterCreator());
            this.put(DataTypes.TIME, new SqlTimeConverterCreator());
            this.put(DataTypes.TIMESTAMP, new SqlTimestampConverterCreator());
        }
    };

    public ParquetRecordConverter(GroupType parquetType, InternalType[] fieldTypes2) {
        Preconditions.checkArgument(parquetType.getFieldCount() == fieldTypes2.length);
        int fieldCount = parquetType.getFieldCount();
        this.currentRow = new Row(fieldCount);
        this.fieldConverters = new ArrayList<Converter>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            Type type = parquetType.getType(i);
            InternalType fieldType = fieldTypes2[i];
            InternalType fieldKey = fieldType instanceof DecimalType ? ANY_DEC_TYPE : fieldType;
            ConverterCreator converterCreator = CONVERTER_CREATOR_MAP.get(fieldKey);
            if (converterCreator == null) {
                throw new UnsupportedOperationException(fieldType + " is not support");
            }
            Converter converter = converterCreator.createConverter(type, new RowFieldSetter(this.currentRow, i));
            this.fieldConverters.add(converter);
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this.fieldConverters.get(fieldIndex);
    }

    public Row getCurrentRecord() {
        return this.currentRow;
    }

    public void start() {
        for (int i = 0; i < this.currentRow.getArity(); ++i) {
            this.currentRow.setField(i, null);
        }
    }

    public void end() {
    }

    private static class SqlTimestampConverterCreator
    extends PrimitiveConverterCreator {
        private SqlTimestampConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 && type.getOriginalType() == OriginalType.TIMESTAMP_MILLIS);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addLong(long value) {
                    this.fieldSetter.set(TimeConvertUtils.internalToTimestamp(value));
                }
            };
        }
    }

    private static class SqlTimeConverterCreator
    extends PrimitiveConverterCreator {
        private SqlTimeConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && type.getOriginalType() == OriginalType.TIME_MILLIS);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set(TimeConvertUtils.internalToTime(value));
                }
            };
        }
    }

    private static class SqlDateConverterCreator
    extends PrimitiveConverterCreator {
        private SqlDateConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && type.getOriginalType() == OriginalType.DATE);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set(TimeConvertUtils.internalToDate(value));
                }
            };
        }
    }

    private static class ByteArrayConverterCreator
    extends PrimitiveConverterCreator {
        private ByteArrayConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY && (type.getOriginalType() == null || type.getOriginalType() == OriginalType.BSON || type.getOriginalType() == OriginalType.UTF8));
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addBinary(Binary value) {
                    this.fieldSetter.set(value.getBytes());
                }
            };
        }
    }

    private static class BigDecConverterCreator
    extends PrimitiveConverterCreator {
        private BigDecConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 || type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 || type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY);
            Preconditions.checkArgument(type.getOriginalType() == OriginalType.DECIMAL);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set(new BigDecimal(value));
                }

                public void addLong(long value) {
                    this.fieldSetter.set(new BigDecimal(value));
                }

                public void addBinary(Binary value) {
                    this.fieldSetter.set(new BigDecimal(new BigInteger(value.getBytes())));
                }
            };
        }
    }

    private static class DateConverterCreator
    extends PrimitiveConverterCreator {
        private DateConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && type.getOriginalType() == OriginalType.DATE);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set(new Date(value));
                }
            };
        }
    }

    private static class DoubleConverterCreator
    extends PrimitiveConverterCreator {
        private DoubleConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.DOUBLE);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addDouble(double value) {
                    this.fieldSetter.set(value);
                }
            };
        }
    }

    private static class FloatConverterCreator
    extends PrimitiveConverterCreator {
        private FloatConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addFloat(float value) {
                    this.fieldSetter.set(Float.valueOf(value));
                }
            };
        }
    }

    private static class LongConverterCreator
    extends PrimitiveConverterCreator {
        private LongConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 && (type.getOriginalType() == null || type.getOriginalType() == OriginalType.INT_64));
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addLong(long value) {
                    this.fieldSetter.set(value);
                }
            };
        }
    }

    private static class IntConverterCreator
    extends PrimitiveConverterCreator {
        private IntConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && (type.getOriginalType() == null || type.getOriginalType() == OriginalType.INT_32));
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set(value);
                }
            };
        }
    }

    private static class ShortConverterCreator
    extends PrimitiveConverterCreator {
        private ShortConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && type.getOriginalType() == OriginalType.INT_16);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set((short)value);
                }
            };
        }
    }

    private static class ByteConverterCreator
    extends PrimitiveConverterCreator {
        private ByteConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && type.getOriginalType() == OriginalType.INT_8);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addInt(int value) {
                    this.fieldSetter.set((byte)value);
                }
            };
        }
    }

    private static class BooleanConverterCreator
    extends PrimitiveConverterCreator {
        private BooleanConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BOOLEAN);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addBoolean(boolean value) {
                    this.fieldSetter.set(value);
                }
            };
        }
    }

    private static class StringConverterCreator
    extends PrimitiveConverterCreator {
        private StringConverterCreator() {
        }

        @Override
        protected void validatePrimitiveType(PrimitiveType type) {
            Preconditions.checkArgument(type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY);
        }

        @Override
        protected Converter newConverter(RowFieldSetter fieldSetter) {
            return new ParquetPrimitiveConverter(fieldSetter){

                public void addBinary(Binary value) {
                    this.fieldSetter.set(new String(value.getBytes()));
                }
            };
        }
    }

    private static abstract class PrimitiveConverterCreator
    extends ConverterCreator {
        private PrimitiveConverterCreator() {
        }

        @Override
        protected void validateType(Type type) {
            Preconditions.checkArgument(type.isPrimitive());
            this.validatePrimitiveType(type.asPrimitiveType());
        }

        protected abstract void validatePrimitiveType(PrimitiveType var1);
    }

    private static abstract class ConverterCreator {
        private ConverterCreator() {
        }

        private Converter createConverter(Type type, RowFieldSetter fieldSetter) {
            this.validateType(type);
            return this.newConverter(fieldSetter);
        }

        protected abstract void validateType(Type var1);

        protected abstract Converter newConverter(RowFieldSetter var1);
    }

    private static abstract class ParquetPrimitiveConverter
    extends PrimitiveConverter {
        final RowFieldSetter fieldSetter;

        ParquetPrimitiveConverter(RowFieldSetter fieldSetter) {
            this.fieldSetter = fieldSetter;
        }
    }

    private static class RowFieldSetter {
        private final Row currentRow;
        private final int position;

        RowFieldSetter(Row currentRow2, int position) {
            this.currentRow = currentRow2;
            this.position = position;
        }

        public void set(Object value) {
            this.currentRow.setField(this.position, value);
        }
    }
}

