/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaConverter {
    public Map<String, InternalType> convertToInternalType(MessageType parquetSchema) {
        List types = parquetSchema.asGroupType().getFields();
        HashMap<String, InternalType> result = new HashMap<String, InternalType>();
        block3: for (Type type : types) {
            String name = type.getName();
            switch (type.getRepetition()) {
                case OPTIONAL: 
                case REQUIRED: {
                    result.put(name, this.convertType(type));
                    continue block3;
                }
            }
            throw new UnsupportedOperationException(type + " is not supported");
        }
        return result;
    }

    private InternalType convertType(Type parquetType) {
        if (parquetType.isPrimitive()) {
            return this.convertPrimitiveType(parquetType.asPrimitiveType());
        }
        return this.convertGroupType(parquetType.asGroupType());
    }

    private InternalType convertPrimitiveType(PrimitiveType primitiveType) {
        PrimitiveType.PrimitiveTypeName typeName = primitiveType.getPrimitiveTypeName();
        OriginalType originalType = primitiveType.getOriginalType();
        DecimalMetadata decimalMetadata = primitiveType.getDecimalMetadata();
        switch (typeName) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN;
            }
            case FLOAT: {
                return DataTypes.FLOAT;
            }
            case DOUBLE: {
                return DataTypes.DOUBLE;
            }
            case INT32: {
                return this.convertOriginalType_INT32(originalType, decimalMetadata);
            }
            case INT64: {
                return this.convertOriginalType_INT64(originalType, decimalMetadata);
            }
            case BINARY: {
                return this.convertOriginalType_BINARY(originalType, decimalMetadata);
            }
        }
        throw new UnsupportedOperationException(typeName + " is not supported");
    }

    private InternalType convertOriginalType_INT32(OriginalType originalType, DecimalMetadata decimalMetadata) {
        if (originalType == null) {
            return DataTypes.INT;
        }
        switch (originalType) {
            case INT_8: {
                return DataTypes.BYTE;
            }
            case INT_16: {
                return DataTypes.SHORT;
            }
            case INT_32: {
                return DataTypes.INT;
            }
            case DATE: {
                return DataTypes.DATE;
            }
            case DECIMAL: {
                return DecimalType.of(decimalMetadata.getPrecision(), decimalMetadata.getScale());
            }
        }
        throw new UnsupportedOperationException(originalType + " is not supported");
    }

    private InternalType convertOriginalType_INT64(OriginalType originalType, DecimalMetadata decimalMetadata) {
        if (originalType == null) {
            return DataTypes.LONG;
        }
        switch (originalType) {
            case INT_64: {
                return DataTypes.LONG;
            }
            case DECIMAL: {
                return DecimalType.of(decimalMetadata.getPrecision(), decimalMetadata.getScale());
            }
        }
        throw new UnsupportedOperationException(originalType + " is not supported");
    }

    private InternalType convertOriginalType_BINARY(OriginalType originalType, DecimalMetadata decimalMetadata) {
        if (originalType == null) {
            return DataTypes.BYTE_ARRAY;
        }
        switch (originalType) {
            case UTF8: 
            case ENUM: 
            case JSON: {
                return DataTypes.STRING;
            }
            case BSON: {
                return DataTypes.BYTE_ARRAY;
            }
            case DECIMAL: {
                return DecimalType.of(decimalMetadata.getPrecision(), decimalMetadata.getScale());
            }
        }
        throw new UnsupportedOperationException(originalType + " is not supported");
    }

    private InternalType convertGroupType(GroupType groupType) {
        throw new UnsupportedOperationException(groupType + " is not supported");
    }

    public static MessageType convert(String[] columnNames, InternalType ... types) {
        return new MessageType("flink_schema", ParquetSchemaConverter.convertTypes(columnNames, types));
    }

    private static Type[] convertTypes(String[] columnNames, InternalType ... internalTypes) {
        if (columnNames.length != internalTypes.length) {
            throw new IllegalStateException("Mismatched Flink columns and types. Flink columns names found : " + Arrays.toString(columnNames) + " . And Flink types found : " + Arrays.toString(internalTypes));
        }
        Type[] types = new Type[internalTypes.length];
        for (int i = 0; i < internalTypes.length; ++i) {
            InternalType flinkType = internalTypes[i];
            types[i] = ParquetSchemaConverter.convertType(columnNames[i], flinkType);
        }
        return types;
    }

    private static Type convertType(String name, InternalType flinkType) {
        return ParquetSchemaConverter.convertType(name, flinkType, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, InternalType type, Type.Repetition repetition) {
        if (DataTypes.INT.equals(type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(name);
        }
        if (DataTypes.SHORT.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(name);
        }
        if (DataTypes.BOOLEAN.equals(type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(name);
        }
        if (DataTypes.BYTE.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(name);
        }
        if (DataTypes.DOUBLE.equals(type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(name);
        }
        if (DataTypes.FLOAT.equals(type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(name);
        }
        if (DataTypes.LONG.equals(type)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(name);
        }
        if (DataTypes.STRING.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(name);
        }
        if (DataTypes.DATE.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(name);
        }
        if (DataTypes.TIME.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.TIME_MILLIS)).named(name);
        }
        if (DataTypes.TIMESTAMP.equals(type)) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS)).named(name);
        }
        if (type instanceof DecimalType) {
            int precision = ((DecimalType)type).precision();
            int scale = ((DecimalType)type).scale();
            if (Decimal.is32BitDecimal(precision)) {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).precision(precision)).scale(scale)).as(OriginalType.DECIMAL)).named(name);
            }
            if (Decimal.is64BitDecimal(precision)) {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).precision(precision)).scale(scale)).as(OriginalType.DECIMAL)).named(name);
            }
            int numBytes = ParquetSchemaConverter.computeMinBytesForPrecision(precision);
            return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).precision(precision)).scale(scale)).length(numBytes)).as(OriginalType.DECIMAL)).named(name);
        }
        if (type instanceof ArrayType) {
            return ParquetSchemaConverter.convertListType(name, (ArrayType)type);
        }
        throw new RuntimeException("Unsupported category " + type);
    }

    private static GroupType convertListType(String name, ArrayType arrayType) {
        InternalType subType = arrayType.getElementInternalType();
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).as(OriginalType.LIST)).addField(ParquetSchemaConverter.convertType("array", subType))).named(name);
    }

    public static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }
}

