/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;
import org.apache.flink.table.sources.parquet.VectorizedColumnReader;
import org.apache.flink.table.types.InternalType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetVectorizedReader
extends RecordReader<Void, Object> {
    private Path file;
    private MessageType fileSchema;
    private MessageType requestedSchema;
    protected VectorizedColumnReader[] columnReaders;
    protected long totalRowCount;
    protected long rowsReturned;
    protected long totalCountLoadedSoFar;
    protected ParquetFileReader reader;
    protected VectorizedColumnBatch columnarBatch;
    protected InternalType[] fieldTypes;
    protected String[] fieldNames;

    public ParquetVectorizedReader(InternalType[] fieldTypes2, String[] fieldNames) {
        this.fieldTypes = fieldTypes2;
        this.fieldNames = fieldNames;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        ArrayList<BlockMetaData> blocks;
        Object filter;
        ParquetMetadata footer;
        Configuration configuration = taskAttemptContext.getConfiguration();
        ParquetInputSplit split = (ParquetInputSplit)inputSplit;
        this.file = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)split.getStart(), (long)split.getEnd()));
            MessageType fileSchema = footer.getFileMetaData().getSchema();
            filter = ParquetInputFormat.getFilter((Configuration)configuration);
            blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, (List)footer.getBlocks(), (MessageType)fileSchema);
        } else {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            blocks = new ArrayList<BlockMetaData>();
            filter = footer.getBlocks().iterator();
            while (filter.hasNext()) {
                BlockMetaData block = (BlockMetaData)filter.next();
                if (!offsets.contains(block.getStartingPos())) continue;
                blocks.add(block);
            }
            if (blocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (int i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = ((BlockMetaData)footer.getBlocks().get(i)).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
            }
        }
        this.fileSchema = footer.getFileMetaData().getSchema();
        this.requestedSchema = this.clipParquetSchema((GroupType)this.fileSchema, this.fieldNames);
        this.reader = new ParquetFileReader(configuration, footer.getFileMetaData(), this.file, blocks, this.requestedSchema.getColumns());
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
        this.checkColumn();
        this.resultBatch();
    }

    private void checkColumn() throws IOException, UnsupportedOperationException {
        if (this.fieldTypes.length != this.requestedSchema.getFieldCount()) {
            throw new RuntimeException("The quality of field type is incompatible with the request schema!");
        }
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Type t = (Type)this.requestedSchema.getFields().get(i);
            if (!t.isPrimitive() || t.isRepetition(Type.Repetition.REPEATED)) {
                throw new UnsupportedOperationException("Complex types not supported.");
            }
            Object[] colPath = (String[])this.requestedSchema.getPaths().get(i);
            if (this.fileSchema.containsPath((String[])colPath)) {
                ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])colPath);
                if (fd.equals(this.requestedSchema.getColumns().get(i))) continue;
                throw new UnsupportedOperationException("Schema evolution not supported.");
            }
            if (((ColumnDescriptor)this.requestedSchema.getColumns().get(i)).getMaxDefinitionLevel() != 0) continue;
            throw new IOException("Required column is missing in data file. Col: " + Arrays.toString(colPath));
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.nextBatch();
    }

    void initBatch() {
        this.columnarBatch = VectorizedColumnBatch.allocate(this.fieldTypes);
    }

    public VectorizedColumnBatch resultBatch() throws IOException {
        if (this.columnarBatch == null) {
            this.initBatch();
        }
        return this.columnarBatch;
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.columnarBatch;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.rowsReturned / (float)this.totalRowCount;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected boolean nextBatch() throws IOException {
        this.columnarBatch.reset();
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min(2048L, this.totalCountLoadedSoFar - this.rowsReturned);
        for (int i = 0; i < this.columnReaders.length; ++i) {
            if (this.columnReaders[i] == null) continue;
            this.columnReaders[i].readColumnBatch(num, this.columnarBatch.columns[i], this.fieldTypes[i]);
        }
        this.rowsReturned += (long)num;
        this.columnarBatch.setNumRows(num);
        return true;
    }

    protected void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List columns = this.requestedSchema.getColumns();
        this.columnReaders = new VectorizedColumnReader[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            this.columnReaders[i] = new VectorizedColumnReader((ColumnDescriptor)columns.get(i), pages.getPageReader((ColumnDescriptor)columns.get(i)));
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private MessageType clipParquetSchema(GroupType parquetSchema, String[] fieldNames) {
        Type[] types = new Type[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            if (parquetSchema.getFieldIndex(fieldName) < 0) {
                throw new IllegalArgumentException(fieldName + " does not exist");
            }
            types[i] = parquetSchema.getType(fieldName);
        }
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(types)).named("flink-parquet");
    }
}

