/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import org.apache.flink.table.sources.parquet.ParquetVectorizedReader;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.types.Row;

public class ParquetVectorizedRowReader
extends ParquetVectorizedReader {
    private int rowIdx = 0;
    private int batchSize = 0;

    public ParquetVectorizedRowReader(InternalType[] fieldTypes2, String[] fieldNames) {
        super(fieldTypes2, fieldNames);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.batchSize == 0 || this.rowIdx >= this.batchSize) {
            if (!this.nextBatch()) {
                return false;
            }
            this.batchSize = this.columnarBatch.getNumRows();
            this.rowIdx = 0;
        }
        ++this.rowIdx;
        return true;
    }

    @Override
    public Object getCurrentValue() throws IOException, InterruptedException {
        Row row2 = new Row(this.columnarBatch.getArity());
        for (int colId = 0; colId < this.columnarBatch.getArity(); ++colId) {
            row2.setField(colId, this.columnarBatch.getObject(this.rowIdx - 1, colId));
        }
        return row2;
    }
}

