/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.core.fs.Path;
import org.apache.flink.table.sources.parquet.ParquetInputFormat;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RowParquetInputFormat
extends ParquetInputFormat<Row, Row> {
    private static final long serialVersionUID = -2569974518641072339L;
    private transient Row reuse;

    public RowParquetInputFormat(Path filePath, InternalType[] fieldTypes2, String[] fieldNames) {
        super(filePath, fieldTypes2, fieldNames);
    }

    @Override
    public Row convert(Row current) {
        if (this.reuse == null) {
            return Row.copy(current);
        }
        Preconditions.checkArgument(current.getArity() == this.reuse.getArity());
        for (int i = 0; i < current.getArity(); ++i) {
            this.reuse.setField(i, current.getField(i));
        }
        return this.reuse;
    }
}

