/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.dataformat.vector.ShortColumnVector;
import org.apache.flink.table.sources.parquet.ParquetDictionary;
import org.apache.flink.table.sources.parquet.VectorizedDefValuesReader;
import org.apache.flink.table.sources.parquet.VectorizedPlainValuesReader;
import org.apache.flink.table.sources.parquet.VectorizedRleValuesReader;
import org.apache.flink.table.sources.parquet.VectorizedValuesReader;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.InternalType;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedColumnReader {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedColumnReader.class);
    protected final Dictionary dictionary;
    protected final int maxDefLevel;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;
    protected ValuesReader dataColumn;
    public VectorizedDefValuesReader defColumn;
    private long valuesRead;
    private long endOfPageValueCount;
    private boolean isCurrentPageDictionaryEncoded;
    private int pageValueCount;

    public VectorizedColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e2) {
                throw new IOException("could not decode the dictionary for " + descriptor, e2);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
    }

    public void readColumnBatch(int total, ColumnVector column, InternalType fieldType) throws IOException {
        int rowId = 0;
        IntegerColumnVector dictionaryIds = null;
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(2048);
        }
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                this.defColumn.readIntegers(num, dictionaryIds, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                if (column.hasDictionary() || rowId == 0 && (this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32 || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64 && !fieldType.equals(DataTypes.TIMESTAMP) || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.FLOAT || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.DOUBLE || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY)) {
                    column.setDictionary(new ParquetDictionary(this.dictionary));
                } else {
                    this.decodeDictionaryIds(rowId, num, column, dictionaryIds, fieldType);
                }
            } else {
                if (column.hasDictionary() && rowId != 0) {
                    this.decodeDictionaryIds(0, rowId, column, column.getDictionaryIds(), fieldType);
                }
                column.setDictionary(null);
                switch (this.descriptor.getType()) {
                    case BOOLEAN: {
                        this.defColumn.readBooleans(num, (BooleanColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case INT32: {
                        if (fieldType.equals(DataTypes.SHORT)) {
                            this.defColumn.readShorts(num, (ShortColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                            break;
                        }
                        if (fieldType.equals(DataTypes.BYTE)) {
                            this.defColumn.readBytes(num, (ByteColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                            break;
                        }
                        this.defColumn.readIntegers(num, (IntegerColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case INT64: {
                        this.defColumn.readLongs(num, (LongColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case FLOAT: {
                        this.defColumn.readFloats(num, (FloatColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case DOUBLE: {
                        this.defColumn.readDoubles(num, (DoubleColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case BINARY: {
                        this.defColumn.readBinaries(num, (BytesColumnVector)column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                        break;
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        VectorizedValuesReader data = (VectorizedValuesReader)this.dataColumn;
                        if (fieldType instanceof DecimalType) {
                            int i;
                            DecimalType decimalTypeInfo = (DecimalType)fieldType;
                            if (Decimal.is32BitDecimal(decimalTypeInfo.precision())) {
                                for (i = 0; i < num; ++i) {
                                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                                        ((IntegerColumnVector)column).vector[rowId + i] = (int)this.binaryToUnscaledLong(data.readBinary(this.descriptor.getTypeLength()));
                                        continue;
                                    }
                                    column.noNulls = false;
                                    column.isNull[rowId + i] = true;
                                }
                            } else if (Decimal.is64BitDecimal(decimalTypeInfo.precision())) {
                                for (i = 0; i < num; ++i) {
                                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                                        ((LongColumnVector)column).vector[rowId + i] = this.binaryToUnscaledLong(data.readBinary(this.descriptor.getTypeLength()));
                                        continue;
                                    }
                                    column.noNulls = false;
                                    column.isNull[rowId + i] = true;
                                }
                            } else {
                                for (i = 0; i < num; ++i) {
                                    if (this.defColumn.readInteger() == this.maxDefLevel) {
                                        ((BytesColumnVector)column).setVal(rowId + i, data.readBinary(this.descriptor.getTypeLength()).getBytes());
                                        continue;
                                    }
                                    column.noNulls = false;
                                    column.isNull[rowId + i] = true;
                                }
                            }
                            break;
                        }
                        throw new UnsupportedOperationException("Unimplemented type: " + fieldType);
                    }
                    default: {
                        throw new IOException("Unsupported type: " + this.descriptor.getType());
                    }
                }
            }
            this.valuesRead += (long)num;
            rowId += num;
            total -= num;
        }
    }

    private void decodeDictionaryIds(int rowId, int num, ColumnVector column, IntegerColumnVector dictionaryIds, InternalType fieldType) {
        switch (this.descriptor.getType()) {
            case INT32: {
                if (fieldType.equals(DataTypes.INT) || fieldType instanceof DecimalType && Decimal.is32BitDecimal(((DecimalType)fieldType).precision())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (!column.noNulls && column.isNull[i]) continue;
                        ((IntegerColumnVector)column).vector[i] = this.dictionary.decodeToInt(dictionaryIds.vector[i]);
                    }
                    break;
                }
                if (fieldType.equals(DataTypes.BYTE)) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (!column.noNulls && column.isNull[i]) continue;
                        ((ByteColumnVector)column).vector[i] = (byte)this.dictionary.decodeToInt(dictionaryIds.vector[i]);
                    }
                    break;
                }
                if (fieldType.equals(DataTypes.SHORT)) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (!column.noNulls && column.isNull[i]) continue;
                        ((ShortColumnVector)column).vector[i] = (short)this.dictionary.decodeToInt(dictionaryIds.vector[i]);
                    }
                    break;
                }
                throw new UnsupportedOperationException("Unimplemented type: " + fieldType);
            }
            case INT64: {
                if (fieldType.equals(DataTypes.LONG) || fieldType.equals(DataTypes.TIMESTAMP) || fieldType instanceof DecimalType && Decimal.is64BitDecimal(((DecimalType)fieldType).precision())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (!column.noNulls && column.isNull[i]) continue;
                        ((LongColumnVector)column).vector[i] = this.dictionary.decodeToLong(dictionaryIds.vector[i]);
                    }
                    break;
                }
                throw new UnsupportedOperationException("Unimplemented type: " + fieldType);
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (!column.noNulls && column.isNull[i]) continue;
                    ((FloatColumnVector)column).vector[i] = this.dictionary.decodeToFloat(dictionaryIds.vector[i]);
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (!column.noNulls && column.isNull[i]) continue;
                    ((DoubleColumnVector)column).vector[i] = this.dictionary.decodeToDouble(dictionaryIds.vector[i]);
                }
                break;
            }
            case BINARY: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (!column.noNulls && column.isNull[i]) continue;
                    Binary v = this.dictionary.decodeToBinary(dictionaryIds.vector[i]);
                    ((BytesColumnVector)column).setVal(i, v.getBytes());
                }
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (fieldType instanceof DecimalType) {
                    DecimalType decimalTypeInfo = (DecimalType)fieldType;
                    if (Decimal.is32BitDecimal(decimalTypeInfo.precision())) {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (!column.noNulls && column.isNull[i]) continue;
                            Binary v = this.dictionary.decodeToBinary(dictionaryIds.vector[i]);
                            ((IntegerColumnVector)column).vector[i] = (int)this.binaryToUnscaledLong(v);
                        }
                    } else if (Decimal.is64BitDecimal(decimalTypeInfo.precision())) {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (!column.noNulls && column.isNull[i]) continue;
                            Binary v = this.dictionary.decodeToBinary(dictionaryIds.vector[i]);
                            ((LongColumnVector)column).vector[i] = this.binaryToUnscaledLong(v);
                        }
                    } else {
                        for (int i = rowId; i < rowId + num; ++i) {
                            if (!column.noNulls && column.isNull[i]) continue;
                            Binary v = this.dictionary.decodeToBinary(dictionaryIds.vector[i]);
                            ((BytesColumnVector)column).setVal(i, v.getBytes());
                        }
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.descriptor.getType());
            }
        }
    }

    private void readPage() throws IOException {
        DataPage page = this.pageReader.readPage();
        page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

            public Void visit(DataPageV1 dataPageV) {
                VectorizedColumnReader.this.readPageV1(dataPageV);
                return null;
            }

            public Void visit(DataPageV2 dataPageV2) {
                VectorizedColumnReader.this.readPageV2(dataPageV2);
                return null;
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, byte[] bytes, int offset) throws IOException {
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedPlainValuesReader();
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, bytes, offset);
        }
        catch (IOException e2) {
            throw new IOException("could not read page in col " + this.descriptor, e2);
        }
    }

    private void readPageV1(DataPageV1 page) {
        this.pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + page.getDlEncoding());
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        VectorizedDefValuesReader dlReader = this.defColumn = new VectorizedDefValuesReader(bitWidth);
        try {
            byte[] bytes = page.getBytes().toByteArray();
            LOG.debug("page size " + bytes.length + " bytes and " + this.pageValueCount + " records");
            LOG.debug("reading repetition levels at 0");
            rlReader.initFromPage(this.pageValueCount, bytes, 0);
            int next = rlReader.getNextOffset();
            LOG.debug("reading definition levels at " + next);
            dlReader.initFromPage(this.pageValueCount, bytes, next);
            next = dlReader.getNextOffset();
            LOG.debug("reading data at " + next);
            this.initDataReader(page.getValueEncoding(), bytes, next);
        }
        catch (IOException e2) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, (Throwable)e2);
        }
    }

    private void readPageV2(DataPageV2 page) {
        this.pageValueCount = page.getValueCount();
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedDefValuesReader(bitWidth);
        try {
            this.defColumn.initFromBuffer(this.pageValueCount, page.getDefinitionLevels().toByteArray());
            this.initDataReader(page.getDataEncoding(), page.getData().toByteArray(), 0);
        }
        catch (IOException e2) {
            throw new ParquetDecodingException("could not read page " + page + " in col " + this.descriptor, (Throwable)e2);
        }
    }

    private long binaryToUnscaledLong(Binary binary) {
        ByteBuffer buffer = binary.toByteBuffer();
        byte[] bytes = buffer.array();
        int start = buffer.arrayOffset() + buffer.position();
        int end = buffer.arrayOffset() + buffer.limit();
        long unscaled = 0L;
        for (int i = start; i < end; ++i) {
            unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        unscaled = unscaled << 64 - bits >> 64 - bits;
        return unscaled;
    }
}

