/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources.parquet;

import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntegerColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.sources.parquet.VectorizedRleValuesReaderBase;
import org.apache.flink.table.sources.parquet.VectorizedValuesReader;
import org.apache.parquet.io.api.Binary;

public final class VectorizedRleValuesReader
extends VectorizedRleValuesReaderBase
implements VectorizedValuesReader {
    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }

    public int readValueDictionaryId() {
        return this.readInteger();
    }

    @Override
    public void readIntegers(int total, IntegerColumnVector c, int rowId) {
        int left = total;
        while (left > 0) {
            if (this.currentCount == 0) {
                this.readNextGroup();
            }
            int n = Math.min(left, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    for (int i = 0; i < n; ++i) {
                        c.vector[i + rowId] = this.currentValue;
                    }
                    break;
                }
                case PACKED: {
                    System.arraycopy(this.currentBuffer, this.currentBufferIdx, c.vector, rowId, n);
                    this.currentBufferIdx += n;
                }
            }
            rowId += n;
            left -= n;
            this.currentCount -= n;
        }
    }

    @Override
    public void readDoubles(int total, DoubleColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBytes(int total, ByteColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readLongs(int total, LongColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBinaries(int total, BytesColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public Binary readBinary(int len) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readBooleans(int total, BooleanColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }

    @Override
    public void readFloats(int total, FloatColumnVector c, int rowId) {
        throw new UnsupportedOperationException("only readInts is valid.");
    }
}

