/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceConfiguration;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceOptions;
import org.apache.flink.runtime.io.network.partition.external.LocalResultPartitionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalResultPartitionResolver
extends LocalResultPartitionResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExternalResultPartitionResolver.class);
    private final String rootPath;

    public DefaultExternalResultPartitionResolver(ExternalBlockShuffleServiceConfiguration shuffleServiceConfiguration) {
        super(shuffleServiceConfiguration);
        this.rootPath = shuffleServiceConfiguration.getConfiguration().getString(ExternalBlockShuffleServiceOptions.LOCAL_DIRS);
    }

    public LocalResultPartitionResolver.ResultPartitionFileInfo getResultPartitionDir(ResultPartitionID resultPartitionID) throws IOException {
        long tableHashId = resultPartitionID.getPartitionId().getLowerPart();
        long tablePartition = resultPartitionID.getPartitionId().getUpperPart();
        return new DefaultResultPartitionFileInfo(this.rootPath, this.rootPath + tableHashId + File.separator + tablePartition + File.separator);
    }

    public void recycleResultPartition(ResultPartitionID resultPartitionID) {
        LOG.info("DefaultExternalResultPartitionResolver recycleResultPartition");
    }

    public void initializeApplication(String user, String appId) {
        LOG.info("DefaultExternalResultPartitionResolver initializeApplication");
    }

    public Set<ResultPartitionID> stopApplication(String appId) {
        LOG.info("DefaultExternalResultPartitionResolver initializeApplication");
        return Collections.emptySet();
    }

    public void stop() {
        LOG.info("DefaultExternalResultPartitionResolver stops.");
    }

    public static class DefaultResultPartitionFileInfo
    implements LocalResultPartitionResolver.ResultPartitionFileInfo {
        private final String rootDir;
        private final String partitionDir;

        public DefaultResultPartitionFileInfo(String rootDir, String partitionDir) {
            this.rootDir = rootDir;
            this.partitionDir = partitionDir;
        }

        public String getRootDir() {
            return this.rootDir;
        }

        public String getPartitionDir() {
            return this.partitionDir;
        }

        public long getConsumedPartitionTTL() {
            return Long.MAX_VALUE;
        }

        public long getPartialConsumedPartitionTTL() {
            return Long.MAX_VALUE;
        }
    }
}

