/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.service.LifeCycleAware;
import org.apache.flink.service.ServiceContext;
import org.apache.flink.table.temptable.TableMetaManager;
import org.apache.flink.table.temptable.TableService;
import org.apache.flink.table.temptable.TableServiceMetrics;
import org.apache.flink.table.temptable.TableStorage;
import org.apache.flink.table.temptable.util.TableServiceUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableServiceImpl
implements LifeCycleAware,
TableService {
    private TableStorage tableStorage;
    private static final Logger logger = LoggerFactory.getLogger(TableServiceImpl.class);
    private ServiceContext serviceContext;
    private TableServiceMetrics tableServiceMetrics;
    private TableMetaManager tableMetaManager;
    private boolean isLeader;

    public TableServiceImpl(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    @Override
    public void open(Configuration config) {
        logger.info("FlinkTableService begin open.");
        this.tableStorage = new TableStorage();
        this.tableStorage.open(config);
        this.tableServiceMetrics = new TableServiceMetrics(this.serviceContext.getMetricGroup());
        boolean bl = this.isLeader = this.serviceContext.getIndexOfCurrentInstance() == 0;
        if (this.isLeader) {
            this.tableMetaManager = new TableMetaManager();
        }
        logger.info("FlinkTableService end open.");
    }

    @Override
    public void close() {
        logger.info("FlinkTableService begin close.");
        if (this.tableStorage != null) {
            this.tableStorage.close();
        }
        logger.info("FlinkTableService end close.");
    }

    @Override
    public List<Integer> getPartitions(String tableName) {
        logger.debug("FlinkTableService receive getPartitionCount request");
        List<ResultPartitionID> list = this.tableMetaManager.getResultPartitions(tableName);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ResultPartitionID partitionID : list) {
            result.add((int)partitionID.getPartitionId().getUpperPart());
        }
        return result;
    }

    @Override
    public int write(String tableName, int partitionId, byte[] content) {
        try {
            logger.debug("FlinkTableService receive write request");
            if (content != null) {
                this.tableStorage.write(tableName, partitionId, content);
            }
            int writeLength = content == null ? 0 : content.length;
            this.tableServiceMetrics.getWriteTotalBytesMetrics().inc(writeLength);
            return writeLength;
        }
        catch (Exception e2) {
            logger.debug("FlinkTableService receive write request, but error occurs: " + e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void delete(String tableName, int partitionId) throws Exception {
        try {
            logger.debug("FlinkTableService receive delete request");
            this.tableStorage.delete(tableName, partitionId);
        }
        catch (Exception e2) {
            logger.debug("FlinkTableService receive delete request, but error occurs: " + e2);
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void initializePartition(String tableName, int partitionId) throws Exception {
        logger.debug("FlinkTableService receive initial partition request");
        this.tableStorage.initializePartition(tableName, partitionId);
    }

    @Override
    public void registerPartition(String tableName, int partitionId) throws Exception {
        logger.debug("FlinkTableService receive register partition request");
        Preconditions.checkState(this.isLeader, "Only leader can handle register partition request, this should not happen");
        ResultPartitionID resultPartitionID = TableServiceUtil.tablePartitionToResultPartition(tableName, partitionId);
        this.tableMetaManager.addResultPartition(tableName, resultPartitionID);
    }

    @Override
    public void unregisterPartition(String tableName) throws Exception {
        logger.debug("FlinkTableService receive remove partitions request");
        this.tableMetaManager.removeTablePartitions(tableName);
    }

    @Override
    public void finishPartition(String tableName, int partitionId) throws Exception {
        logger.debug("FlinkTableService receive finish partition request");
        this.tableStorage.finishPartition(tableName, partitionId);
    }
}

