/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable.rpc;

import java.util.List;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.table.temptable.TableService;
import org.apache.flink.table.temptable.rpc.TableServiceMessage;
import org.apache.flink.table.temptable.util.BytesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableServiceServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TableServiceServerHandler.class);
    private TableService tableService;

    public void setTableService(TableService tableService) {
        this.tableService = tableService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        byte[] request = new byte[buf.readableBytes()];
        buf.readBytes(request);
        byte call = request[0];
        switch (call) {
            case 1: {
                this.getPartitions(ctx, request);
                break;
            }
            case 2: {
                this.write(ctx, request);
                break;
            }
            case 3: {
                this.delete(ctx, request);
                break;
            }
            case 4: {
                this.initializePartition(ctx, request);
                break;
            }
            case 5: {
                this.registerPartition(ctx, request);
                break;
            }
            case 6: {
                this.unregisterPartition(ctx, request);
                break;
            }
            case 7: {
                this.finishPartition(ctx, request);
                break;
            }
            default: {
                LOG.error("Unsupported call: " + call);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error(cause.getMessage(), cause);
        ctx.close();
    }

    private void getPartitions(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            String tableName = new String(request, offset, request.length - offset, "UTF-8");
            List<Integer> result = this.tableService.getPartitions(tableName);
            this.sendGetPartitionsResponse(ctx, result);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void write(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            int tableNameLength = BytesUtil.bytesToInt(request, offset);
            String tableName = new String(request, offset += 4, tableNameLength, "UTF-8");
            int partitionId = BytesUtil.bytesToInt(request, offset += tableNameLength);
            byte[] content = new byte[request.length - (offset += 4)];
            System.arraycopy(request, offset, content, 0, request.length - offset);
            LOG.info("tableName: " + tableName + ", partitionId: " + partitionId);
            int writeSize = this.tableService.write(tableName, partitionId, content);
            this.sendWriteResponse(ctx, writeSize);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void delete(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            int tableNameLength = BytesUtil.bytesToInt(request, offset);
            String tableName = new String(request, offset += 4, tableNameLength, "UTF-8");
            int partitionId = BytesUtil.bytesToInt(request, offset += tableNameLength);
            offset += 4;
            this.tableService.delete(tableName, partitionId);
            this.sendVoidResponse(ctx);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void initializePartition(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            int tableNameLength = BytesUtil.bytesToInt(request, offset);
            String tableName = new String(request, offset += 4, tableNameLength, "UTF-8");
            int partitionId = BytesUtil.bytesToInt(request, offset += tableNameLength);
            offset += 4;
            this.tableService.initializePartition(tableName, partitionId);
            this.sendVoidResponse(ctx);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void registerPartition(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            int tableNameLength = BytesUtil.bytesToInt(request, offset);
            String tableName = new String(request, offset += 4, tableNameLength, "UTF-8");
            int partitionId = BytesUtil.bytesToInt(request, offset += tableNameLength);
            offset += 4;
            this.tableService.registerPartition(tableName, partitionId);
            this.sendVoidResponse(ctx);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void unregisterPartition(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            String tableName = new String(request, offset, request.length - offset, "UTF-8");
            this.tableService.unregisterPartition(tableName);
            this.sendVoidResponse(ctx);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void finishPartition(ChannelHandlerContext ctx, byte[] request) {
        int offset = 1;
        try {
            int tableNameLength = BytesUtil.bytesToInt(request, offset);
            String tableName = new String(request, offset += 4, tableNameLength, "UTF-8");
            int partitionId = BytesUtil.bytesToInt(request, offset += tableNameLength);
            offset += 4;
            this.tableService.finishPartition(tableName, partitionId);
            this.sendVoidResponse(ctx);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            this.sendError(ctx, e2.getMessage());
        }
    }

    private void sendError(ChannelHandlerContext ctx, String msg) {
        try {
            byte[] msgBytes = msg.getBytes("UTF-8");
            int totalLength = 9 + msgBytes.length;
            byte[] totalLengthBytes = BytesUtil.intToBytes(totalLength);
            byte[] msgLengthBytes = BytesUtil.intToBytes(msgBytes.length);
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{totalLengthBytes, TableServiceMessage.FAILURE_BYTES, msgLengthBytes, msgBytes});
            ctx.writeAndFlush((Object)buffer);
        }
        catch (Exception e2) {
            LOG.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    private void sendGetPartitionsResponse(ChannelHandlerContext ctx, List<Integer> result) {
        int resultLength = result == null ? 0 : result.size();
        byte[] resultLengthBytes = BytesUtil.intToBytes(resultLength);
        byte[] resultBytes = BytesUtil.intsToBytes(result);
        int totalLength = 9 + resultBytes.length;
        byte[] totalLengthBytes = BytesUtil.intToBytes(totalLength);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{totalLengthBytes, TableServiceMessage.SUCCESS_BYTES, resultLengthBytes, resultBytes});
        ctx.writeAndFlush((Object)buffer);
    }

    private void sendWriteResponse(ChannelHandlerContext ctx, int writeSize) {
        int totalLength = 9;
        byte[] writeSizeBytes = BytesUtil.intToBytes(writeSize);
        byte[] totalLengthBytes = BytesUtil.intToBytes(totalLength);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{totalLengthBytes, TableServiceMessage.SUCCESS_BYTES, writeSizeBytes});
        ctx.writeAndFlush((Object)buffer);
    }

    private void sendVoidResponse(ChannelHandlerContext ctx) {
        int totalLength = 5;
        byte[] totalLengthBytes = BytesUtil.intToBytes(totalLength);
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[][])new byte[][]{totalLengthBytes, TableServiceMessage.SUCCESS_BYTES});
        ctx.writeAndFlush((Object)buffer);
    }
}

