/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.temptable.util;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.service.ServiceDescriptor;
import org.apache.flink.service.ServiceInstance;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.aggfunctions.cardinality.MurmurHash;
import org.apache.flink.table.temptable.FlinkTableServiceFactory;
import org.apache.flink.table.temptable.FlinkTableServiceFactoryDescriptor;
import org.apache.flink.table.temptable.FlinkTableServiceFunction;
import org.apache.flink.table.temptable.TableServiceException;
import org.apache.flink.table.temptable.TableServiceOptions;
import org.apache.flink.table.temptable.rpc.TableServiceRegistry;
import org.apache.flink.table.util.TableProperties;
import org.apache.flink.util.InstantiationUtil;

public final class TableServiceUtil {
    private TableServiceUtil() {
    }

    public static void createTableServiceJob(StreamExecutionEnvironment env, ServiceDescriptor serviceDescriptor) {
        ResourceSpec resourceSpec = ResourceSpec.newBuilder().setCpuCores(serviceDescriptor.getServiceCpuCores()).setHeapMemoryInMB(serviceDescriptor.getServiceHeapMemoryMb()).setDirectMemoryInMB(serviceDescriptor.getServiceDirectMemoryMb()).setNativeMemoryInMB(serviceDescriptor.getServiceNativeMemoryMb()).build();
        SingleOutputStreamOperator ds = env.addSource((SourceFunction)new FlinkTableServiceFunction(serviceDescriptor)).setParallelism(serviceDescriptor.getServiceParallelism()).setMaxParallelism(serviceDescriptor.getServiceParallelism());
        ds.addSink((SinkFunction)new SinkFunction<BaseRow>(){

            public void invoke(BaseRow value, SinkFunction.Context context) {
            }
        }).setParallelism(serviceDescriptor.getServiceParallelism());
    }

    public static ServiceDescriptor createTableServiceDescriptor(Configuration config) {
        ServiceDescriptor tableServiceDescriptor = new ServiceDescriptor().setServiceClassName(config.getString(TableServiceOptions.TABLE_SERVICE_CLASS_NAME)).setServiceParallelism(config.getInteger(TableServiceOptions.TABLE_SERVICE_PARALLELISM)).setServiceHeapMemoryMb(config.getInteger(TableServiceOptions.TABLE_SERVICE_HEAP_MEMORY_MB)).setServiceDirectMemoryMb(config.getInteger(TableServiceOptions.TABLE_SERVICE_DIRECT_MEMORY_MB)).setServiceNativeMemoryMb(config.getInteger(TableServiceOptions.TABLE_SERVICE_NATIVE_MEMORY_MB)).setServiceCpuCores(config.getDouble(TableServiceOptions.TABLE_SERVICE_CPU_CORES));
        tableServiceDescriptor.getConfiguration().addAll(config);
        tableServiceDescriptor.getConfiguration().setInteger(TableServiceOptions.TABLE_SERVICE_READY_RETRY_TIMES, config.getInteger(TableServiceOptions.TABLE_SERVICE_READY_RETRY_TIMES));
        tableServiceDescriptor.getConfiguration().setLong(TableServiceOptions.TABLE_SERVICE_READY_RETRY_BACKOFF_MS, config.getLong(TableServiceOptions.TABLE_SERVICE_READY_RETRY_BACKOFF_MS));
        if (config.getString(TableServiceOptions.TABLE_SERVICE_STORAGE_ROOT_PATH) != null) {
            tableServiceDescriptor.getConfiguration().setString(TableServiceOptions.TABLE_SERVICE_STORAGE_ROOT_PATH, config.getString(TableServiceOptions.TABLE_SERVICE_STORAGE_ROOT_PATH));
        }
        tableServiceDescriptor.getConfiguration().setInteger(TableServiceOptions.TABLE_SERVICE_CLIENT_READ_BUFFER_SIZE, config.getInteger(TableServiceOptions.TABLE_SERVICE_CLIENT_READ_BUFFER_SIZE));
        tableServiceDescriptor.getConfiguration().setInteger(TableServiceOptions.TABLE_SERVICE_CLIENT_WRITE_BUFFER_SIZE, config.getInteger(TableServiceOptions.TABLE_SERVICE_CLIENT_WRITE_BUFFER_SIZE));
        return tableServiceDescriptor;
    }

    public static FlinkTableServiceFactoryDescriptor getDefaultTableServiceFactoryDescriptor() {
        return new FlinkTableServiceFactoryDescriptor(new FlinkTableServiceFactory(), new TableProperties());
    }

    public static void checkTableServiceReady(TableServiceRegistry registry, int maxRetryTimes, long backOffMs) {
        int retryTime = 0;
        while (retryTime++ < maxRetryTimes) {
            if (registry.isTableServiceReady()) {
                return;
            }
            try {
                Thread.sleep(backOffMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new TableServiceException(new RuntimeException("TableService is not ready"));
    }

    public static void checkRegistryServiceReady(TableServiceRegistry registry, int maxRetryTimes, long backOffMs) {
        int retryTime = 0;
        while (retryTime++ < maxRetryTimes) {
            if (registry.getIp() != null && registry.getPort() > 0) {
                return;
            }
            try {
                Thread.sleep(backOffMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new TableServiceException(new RuntimeException("RegistryService is not ready"));
    }

    public static ResultPartitionID tablePartitionToResultPartition(String tableName, int partitionIndex) {
        long lower = MurmurHash.hash(tableName) & Integer.MAX_VALUE;
        long upper = partitionIndex;
        return new ResultPartitionID(new IntermediateResultPartitionID(lower, upper), new ExecutionAttemptID(0L, 0L));
    }

    public static int tablePartitionToIndex(String tableName, int partitionIndex, int totalCount) {
        int hashCode2 = Objects.hash(tableName, partitionIndex);
        int index = hashCode2 % totalCount;
        if (index < 0) {
            index += totalCount;
        }
        return index;
    }

    public static void injectTableServiceInstances(Map<Integer, ServiceInstance> map2, Configuration configuration) {
        byte[] serializedBytes;
        try {
            serializedBytes = InstantiationUtil.serializeObject(map2);
        }
        catch (IOException e2) {
            throw new TableServiceException(e2);
        }
        String serializedString = Base64.encodeBase64URLSafeString((byte[])serializedBytes);
        configuration.setString(TableServiceOptions.TABLE_SERVICE_INSTANCES, serializedString);
    }

    public static Map<Integer, ServiceInstance> buildTableServiceInstance(Configuration configuration) {
        Map map2;
        String serializedString = configuration.getString(TableServiceOptions.TABLE_SERVICE_INSTANCES);
        try {
            map2 = (Map)InstantiationUtil.deserializeObject(Base64.decodeBase64((String)serializedString), ServiceInstance.class.getClassLoader());
        }
        catch (Exception e2) {
            throw new TableServiceException(e2);
        }
        return map2;
    }
}

