/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import org.apache.flink.table.types.AtomicType;

public class DecimalType
extends AtomicType {
    private static final long serialVersionUID = 1L;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 18;
    private final int precision;
    private final int scale;
    public static final DecimalType USER_DEFAULT = new DecimalType(10, 0);
    public static final DecimalType SYSTEM_DEFAULT = new DecimalType(38, 18);

    public DecimalType(int precision, int scale) {
        if (scale > precision) {
            throw new IllegalArgumentException(String.format("Decimal scale (%s) cannot be greater than precision (%s).", scale, precision));
        }
        if (precision > 38) {
            throw new IllegalArgumentException("DecimalType can only support precision up to 38");
        }
        this.precision = precision;
        this.scale = scale;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public static DecimalType of(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DecimalType of(BigDecimal value) {
        return DecimalType.of(value.precision(), value.scale());
    }

    public static DecimalType of(String qualifiedName) {
        int end;
        if (!qualifiedName.startsWith("decimal(")) {
            throw new IllegalArgumentException("Illegal form of qualified decimal type " + qualifiedName);
        }
        int start = qualifiedName.indexOf(40);
        String ps = qualifiedName.substring(start + 1, end = qualifiedName.indexOf(41));
        String[] sArray = ps.split(",");
        if (sArray.length != 2) {
            throw new IllegalArgumentException("Illegal form of qualified decimal type " + qualifiedName);
        }
        int precision = Integer.parseInt(sArray[0]);
        int scale = Integer.parseInt(sArray[1]);
        return new DecimalType(precision, scale);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Override
    public String toString() {
        return "DecimalType{precision=" + this.precision + ", scale=" + this.scale + '}';
    }
}

